/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import org.nutz.lang.Encoding;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.FileVisitor;

public abstract class Disks {
    public static int visitFile(File f, FileVisitor fv, FileFilter filter) {
        int re = 0;
        if (f.isFile()) {
            fv.visit(f);
            ++re;
        } else if (f.isDirectory()) {
            File[] fs;
            File[] fileArray = fs = null == filter ? f.listFiles() : f.listFiles(filter);
            if (fs != null) {
                for (File theFile : fs) {
                    re += Disks.visitFile(theFile, fv, filter);
                }
            }
        }
        return re;
    }

    public static int visitFileWithDir(File f, FileVisitor fv, FileFilter filter) {
        int re = 0;
        fv.visit(f);
        ++re;
        if (f.isDirectory()) {
            File[] fs;
            File[] fileArray = fs = null == filter ? f.listFiles() : f.listFiles(filter);
            if (fs != null) {
                for (File theFile : fs) {
                    re += Disks.visitFileWithDir(theFile, fv, filter);
                }
            }
        }
        return re;
    }

    public static String getRelativePath(File base, File file) {
        String pathBase = base.getAbsolutePath();
        if (base.isDirectory()) {
            pathBase = pathBase + "/";
        }
        String pathFile = file.getAbsolutePath();
        if (file.isDirectory()) {
            pathFile = pathFile + "/";
        }
        return Disks.getRelativePath(pathBase, pathFile);
    }

    public static String getRelativePath(String base, String path) {
        return Disks.getRelativePath(base, path, "./");
    }

    public static String getRelativePath(String base, String path, String equalPath) {
        int pos;
        if (base.equals(path)) {
            return equalPath;
        }
        String[] bb = Strings.splitIgnoreBlank(Disks.getCanonicalPath(base), "[\\\\/]");
        String[] ff = Strings.splitIgnoreBlank(Disks.getCanonicalPath(path), "[\\\\/]");
        int len = Math.min(bb.length, ff.length);
        for (pos = 0; pos < len && bb[pos].equals(ff[pos]); ++pos) {
        }
        if (len == pos && bb.length == ff.length) {
            return equalPath;
        }
        int dir = 1;
        if (base.endsWith("/")) {
            dir = 0;
        }
        StringBuilder sb = new StringBuilder(Strings.dup("../", bb.length - pos - dir));
        return sb.append((CharSequence)Lang.concat(pos, ff.length - pos, Character.valueOf('/'), ff)).toString();
    }

    public static String getIntersectPath(String ph0, String ph1, String dft) {
        int pos;
        if (null == ph0 || null == ph1) {
            return dft;
        }
        String[] ss0 = Strings.splitIgnoreBlank(ph0, "[\\\\/]");
        String[] ss1 = Strings.splitIgnoreBlank(ph1, "[\\\\/]");
        int len = Math.min(ss0.length, ss1.length);
        for (pos = 0; pos < len && ss0[pos].equals(ss1[pos]); ++pos) {
        }
        if (pos == 0) {
            return dft;
        }
        String re = Lang.concat(0, pos, "/", ss0).toString();
        if (ph0.endsWith("/") && ph1.endsWith("/")) {
            return re + "/";
        }
        return re;
    }

    public static String getCanonicalPath(String path) {
        if (Strings.isBlank(path)) {
            return path;
        }
        String[] pa = Strings.splitIgnoreBlank(path, "[\\\\/]");
        LinkedList<String> paths = new LinkedList<String>();
        for (String s : pa) {
            if ("..".equals(s)) {
                if (paths.size() <= 0) continue;
                paths.removeLast();
                continue;
            }
            if (".".equals(s)) continue;
            paths.add(s);
        }
        if (path.charAt(0) == '/') {
            return Lang.concat((Object)"/", paths).insert(0, '/').toString();
        }
        return Lang.concat((Object)"/", paths).toString();
    }

    public static String home() {
        return System.getProperty("user.home");
    }

    public static String home(String path) {
        return Disks.home() + path;
    }

    public static String absolute(String path) {
        return Disks.absolute(path, ClassTools.getClassLoader(), Encoding.defaultEncoding());
    }

    public static String absolute(String path, ClassLoader klassLoader, String enc) {
        if (Strings.isEmpty(path = Disks.normalize(path, enc))) {
            return null;
        }
        File f = new File(path);
        if (!f.exists()) {
            URL url = null;
            try {
                url = klassLoader.getResource(path);
                if (null == url) {
                    url = Thread.currentThread().getContextClassLoader().getResource(path);
                }
                if (null == url) {
                    url = ClassLoader.getSystemResource(path);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (null != url) {
                return Disks.normalize(url.getPath(), "UTF-8");
            }
            return null;
        }
        return path;
    }

    public static String normalize(String path) {
        return Disks.normalize(path, Encoding.defaultEncoding());
    }

    public static String normalize(String path, String enc) {
        if (Strings.isEmpty(path)) {
            return null;
        }
        if (path.charAt(0) == '~') {
            path = Disks.home() + path.substring(1);
        }
        try {
            return URLDecoder.decode(path, enc);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static final void visitFile(String path, final String regex, final boolean deep, final FileVisitor fv) {
        File d = Files.findFile(path);
        if (null == d) {
            return;
        }
        Disks.visitFile(d, new FileVisitor(){

            @Override
            public void visit(File f) {
                if (f.isDirectory()) {
                    return;
                }
                fv.visit(f);
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return deep;
                }
                if (f.isHidden()) {
                    return false;
                }
                if (Strings.isEmpty(regex)) {
                    return true;
                }
                return f.getName().matches(regex);
            }
        });
    }

    public static final void visitFileWithDir(String path, final String regex, final boolean deep, final FileVisitor fv) {
        File d = Files.findFile(path);
        if (null == d) {
            return;
        }
        Disks.visitFileWithDir(d, new FileVisitor(){

            @Override
            public void visit(File f) {
                fv.visit(f);
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return deep;
                }
                if (f.isHidden()) {
                    return false;
                }
                if (Strings.isEmpty(regex)) {
                    return true;
                }
                return f.getName().matches(regex);
            }
        });
    }

    public static String appendPath(String ... phs) {
        String[] paths = Lang.without(phs, null);
        if (null != paths && paths.length > 0) {
            String str = Lang.concat((Object)"/", paths).toString();
            String[] ss = Strings.splitIgnoreBlank(str, "/");
            str = Lang.concat((Object)"/", ss).toString();
            if (paths[0].startsWith("/")) {
                return "/" + str;
            }
            return str;
        }
        return null;
    }
}

