/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import java.util.List;

public class PagerUtils {
    public static String count(String sql, String dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() != 1) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        return PagerUtils.count(selectStmt.getSelect(), dbType);
    }

    public static String limit(String sql, String dbType, int offset, int count) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() != 1) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        return PagerUtils.limit(selectStmt.getSelect(), dbType, offset, count);
    }

    public static String limit(SQLSelect select, String dbType, int offset, int count) {
        PagerUtils.limit(select, dbType, offset, count, false);
        return SQLUtils.toSQLString(select, dbType);
    }

    public static boolean limit(SQLSelect select, String dbType, int offset, int count, boolean check) {
        SQLSelectQuery query = select.getQuery();
        if ("oracle".equals(dbType)) {
            return PagerUtils.limitOracle(select, dbType, offset, count, check);
        }
        if ("db2".equals(dbType)) {
            return PagerUtils.limitDB2(select, dbType, offset, count, check);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return PagerUtils.limitSQLServer(select, dbType, offset, count, check);
        }
        if (query instanceof SQLSelectQueryBlock) {
            return PagerUtils.limitQueryBlock(select, dbType, offset, count, check);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean limitQueryBlock(SQLSelect select, String dbType, int offset, int count, boolean check) {
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)select.getQuery();
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return PagerUtils.limitMySqlQueryBlock(queryBlock, dbType, offset, count, check);
        }
        if ("postgresql".equals(dbType)) {
            return PagerUtils.limitPostgreSQLQueryBlock((PGSelectQueryBlock)queryBlock, dbType, offset, count, check);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean limitPostgreSQLQueryBlock(PGSelectQueryBlock queryBlock, String dbType, int offset, int count, boolean check) {
        SQLLimit limit = queryBlock.getLimit();
        if (limit != null) {
            int rowCount;
            if (offset > 0) {
                limit.setOffset(new SQLIntegerExpr(offset));
            }
            if (check && limit.getRowCount() instanceof SQLNumericLiteralExpr && (rowCount = ((SQLNumericLiteralExpr)limit.getRowCount()).getNumber().intValue()) <= count && offset <= 0) {
                return false;
            }
            limit.setRowCount(new SQLIntegerExpr(count));
        }
        limit = new SQLLimit();
        if (offset > 0) {
            limit.setOffset(new SQLIntegerExpr(offset));
        }
        limit.setRowCount(new SQLIntegerExpr(count));
        queryBlock.setLimit(limit);
        return true;
    }

    private static boolean limitDB2(SQLSelect select, String dbType, int offset, int count, boolean check) {
        SQLSelectQuery query = select.getQuery();
        SQLBinaryOpExpr gt = new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.GreaterThan, new SQLNumberExpr(offset), "db2");
        SQLBinaryOpExpr lteq = new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.LessThanOrEqual, new SQLNumberExpr(count + offset), "db2");
        SQLBinaryOpExpr pageCondition = new SQLBinaryOpExpr(gt, SQLBinaryOperator.BooleanAnd, lteq, "db2");
        if (query instanceof SQLSelectQueryBlock) {
            DB2SelectQueryBlock queryBlock = (DB2SelectQueryBlock)query;
            if (offset <= 0) {
                int rowCount;
                SQLExpr first = queryBlock.getFirst();
                if (check && first != null && first instanceof SQLNumericLiteralExpr && (rowCount = ((SQLNumericLiteralExpr)first).getNumber().intValue()) < count) {
                    return false;
                }
                queryBlock.setFirst(new SQLIntegerExpr(count));
                return true;
            }
            SQLAggregateExpr aggregateExpr = new SQLAggregateExpr("ROW_NUMBER");
            SQLOrderBy orderBy = select.getOrderBy();
            if (orderBy == null && select.getQuery() instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock selectQueryBlcok = (SQLSelectQueryBlock)select.getQuery();
                orderBy = selectQueryBlcok.getOrderBy();
                selectQueryBlcok.setOrderBy(null);
            } else {
                select.setOrderBy(null);
            }
            aggregateExpr.setOver(new SQLOver(orderBy));
            queryBlock.getSelectList().add(new SQLSelectItem(aggregateExpr, "ROWNUM"));
            DB2SelectQueryBlock countQueryBlock = new DB2SelectQueryBlock();
            countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
            countQueryBlock.setFrom(new SQLSubqueryTableSource(select.clone(), "XX"));
            countQueryBlock.setWhere(pageCondition);
            select.setQuery(countQueryBlock);
            return true;
        }
        DB2SelectQueryBlock countQueryBlock = new DB2SelectQueryBlock();
        countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLPropertyExpr(new SQLIdentifierExpr("XX"), "*")));
        SQLAggregateExpr aggregateExpr = new SQLAggregateExpr("ROW_NUMBER");
        SQLOrderBy orderBy = select.getOrderBy();
        aggregateExpr.setOver(new SQLOver(orderBy));
        select.setOrderBy(null);
        countQueryBlock.getSelectList().add(new SQLSelectItem(aggregateExpr, "ROWNUM"));
        countQueryBlock.setFrom(new SQLSubqueryTableSource(select.clone(), "XX"));
        if (offset <= 0) {
            select.setQuery(countQueryBlock);
            return true;
        }
        DB2SelectQueryBlock offsetQueryBlock = new DB2SelectQueryBlock();
        offsetQueryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
        offsetQueryBlock.setFrom(new SQLSubqueryTableSource(new SQLSelect(countQueryBlock), "XXX"));
        offsetQueryBlock.setWhere(pageCondition);
        select.setQuery(offsetQueryBlock);
        return true;
    }

    private static boolean limitSQLServer(SQLSelect select, String dbType, int offset, int count, boolean check) {
        SQLSelectQuery query = select.getQuery();
        SQLBinaryOpExpr gt = new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.GreaterThan, new SQLNumberExpr(offset), "sqlserver");
        SQLBinaryOpExpr lteq = new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.LessThanOrEqual, new SQLNumberExpr(count + offset), "sqlserver");
        SQLBinaryOpExpr pageCondition = new SQLBinaryOpExpr(gt, SQLBinaryOperator.BooleanAnd, lteq, "sqlserver");
        if (query instanceof SQLSelectQueryBlock) {
            SQLServerSelectQueryBlock queryBlock = (SQLServerSelectQueryBlock)query;
            if (offset <= 0) {
                int rowCount;
                SQLServerTop top = queryBlock.getTop();
                if (check && top != null && !top.isPercent() && top.getExpr() instanceof SQLNumericLiteralExpr && (rowCount = ((SQLNumericLiteralExpr)top.getExpr()).getNumber().intValue()) <= count) {
                    return false;
                }
                queryBlock.setTop(new SQLServerTop(new SQLNumberExpr(count)));
                return true;
            }
            SQLAggregateExpr aggregateExpr = new SQLAggregateExpr("ROW_NUMBER");
            SQLOrderBy orderBy = select.getOrderBy();
            aggregateExpr.setOver(new SQLOver(orderBy));
            select.setOrderBy(null);
            queryBlock.getSelectList().add(new SQLSelectItem(aggregateExpr, "ROWNUM"));
            SQLServerSelectQueryBlock countQueryBlock = new SQLServerSelectQueryBlock();
            countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
            countQueryBlock.setFrom(new SQLSubqueryTableSource(select.clone(), "XX"));
            countQueryBlock.setWhere(pageCondition);
            select.setQuery(countQueryBlock);
            return true;
        }
        SQLServerSelectQueryBlock countQueryBlock = new SQLServerSelectQueryBlock();
        countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLPropertyExpr(new SQLIdentifierExpr("XX"), "*")));
        countQueryBlock.setFrom(new SQLSubqueryTableSource(select.clone(), "XX"));
        if (offset <= 0) {
            countQueryBlock.setTop(new SQLServerTop(new SQLNumberExpr(count)));
            select.setQuery(countQueryBlock);
            return true;
        }
        SQLAggregateExpr aggregateExpr = new SQLAggregateExpr("ROW_NUMBER");
        SQLOrderBy orderBy = select.getOrderBy();
        aggregateExpr.setOver(new SQLOver(orderBy));
        select.setOrderBy(null);
        countQueryBlock.getSelectList().add(new SQLSelectItem(aggregateExpr, "ROWNUM"));
        SQLServerSelectQueryBlock offsetQueryBlock = new SQLServerSelectQueryBlock();
        offsetQueryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
        offsetQueryBlock.setFrom(new SQLSubqueryTableSource(new SQLSelect(countQueryBlock), "XXX"));
        offsetQueryBlock.setWhere(pageCondition);
        select.setQuery(offsetQueryBlock);
        return true;
    }

    private static boolean limitOracle(SQLSelect select, String dbType, int offset, int count, boolean check) {
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            OracleSelectQueryBlock queryBlock = (OracleSelectQueryBlock)query;
            SQLOrderBy orderBy = select.getOrderBy();
            if (orderBy == null && queryBlock.getOrderBy() != null) {
                orderBy = queryBlock.getOrderBy();
            }
            if (queryBlock.getGroupBy() == null && orderBy == null && offset <= 0) {
                SQLBinaryOpExpr binaryOpWhere;
                SQLExpr where = queryBlock.getWhere();
                if (check && where instanceof SQLBinaryOpExpr && (binaryOpWhere = (SQLBinaryOpExpr)where).getOperator() == SQLBinaryOperator.LessThanOrEqual) {
                    int rowCount;
                    SQLExpr left = binaryOpWhere.getLeft();
                    SQLExpr right = binaryOpWhere.getRight();
                    if (left instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)left).getName().equalsIgnoreCase("ROWNUM") && right instanceof SQLNumericLiteralExpr && (rowCount = ((SQLNumericLiteralExpr)right).getNumber().intValue()) <= count) {
                        return false;
                    }
                }
                SQLBinaryOpExpr condition = new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.LessThanOrEqual, new SQLNumberExpr(count), "oracle");
                if (queryBlock.getWhere() == null) {
                    queryBlock.setWhere(condition);
                } else {
                    queryBlock.setWhere(new SQLBinaryOpExpr(queryBlock.getWhere(), SQLBinaryOperator.BooleanAnd, condition, "oracle"));
                }
                return true;
            }
        }
        OracleSelectQueryBlock countQueryBlock = new OracleSelectQueryBlock();
        countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLPropertyExpr(new SQLIdentifierExpr("XX"), "*")));
        countQueryBlock.getSelectList().add(new SQLSelectItem(new SQLIdentifierExpr("ROWNUM"), "RN"));
        countQueryBlock.setFrom(new SQLSubqueryTableSource(select.clone(), "XX"));
        countQueryBlock.setWhere(new SQLBinaryOpExpr(new SQLIdentifierExpr("ROWNUM"), SQLBinaryOperator.LessThanOrEqual, new SQLNumberExpr(count + offset), "oracle"));
        select.setOrderBy(null);
        if (offset <= 0) {
            select.setQuery(countQueryBlock);
            return true;
        }
        OracleSelectQueryBlock offsetQueryBlock = new OracleSelectQueryBlock();
        offsetQueryBlock.getSelectList().add(new SQLSelectItem(new SQLAllColumnExpr()));
        offsetQueryBlock.setFrom(new SQLSubqueryTableSource(new SQLSelect(countQueryBlock), "XXX"));
        offsetQueryBlock.setWhere(new SQLBinaryOpExpr(new SQLIdentifierExpr("RN"), SQLBinaryOperator.GreaterThan, new SQLNumberExpr(offset), "oracle"));
        select.setQuery(offsetQueryBlock);
        return true;
    }

    private static boolean limitMySqlQueryBlock(SQLSelectQueryBlock queryBlock, String dbType, int offset, int count, boolean check) {
        SQLLimit limit = queryBlock.getLimit();
        if (limit != null) {
            int rowCount;
            if (offset > 0) {
                limit.setOffset(new SQLIntegerExpr(offset));
            }
            if (check && limit.getRowCount() instanceof SQLNumericLiteralExpr ? (rowCount = ((SQLNumericLiteralExpr)limit.getRowCount()).getNumber().intValue()) <= count && offset <= 0 : check && limit.getRowCount() instanceof SQLVariantRefExpr) {
                return false;
            }
            limit.setRowCount(new SQLIntegerExpr(count));
        }
        if (limit == null) {
            limit = new SQLLimit();
            if (offset > 0) {
                limit.setOffset(new SQLIntegerExpr(offset));
            }
            limit.setRowCount(new SQLIntegerExpr(count));
            queryBlock.setLimit(limit);
        }
        return true;
    }

    private static String count(SQLSelect select, String dbType) {
        if (select.getOrderBy() != null) {
            select.setOrderBy(null);
        }
        SQLSelectQuery query = select.getQuery();
        PagerUtils.clearOrderBy(query);
        if (query instanceof SQLSelectQueryBlock) {
            SQLSelectItem countItem = PagerUtils.createCountItem(dbType);
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            List<SQLSelectItem> selectList = queryBlock.getSelectList();
            if (queryBlock.getGroupBy() != null && queryBlock.getGroupBy().getItems().size() > 0) {
                return PagerUtils.createCountUseSubQuery(select, dbType);
            }
            int option = queryBlock.getDistionOption();
            if (option == 2 && selectList.size() >= 1) {
                SQLAggregateExpr countExpr = new SQLAggregateExpr("COUNT", SQLAggregateOption.DISTINCT);
                for (int i = 0; i < selectList.size(); ++i) {
                    countExpr.addArgument(selectList.get(i).getExpr());
                }
                selectList.clear();
                queryBlock.setDistionOption(0);
                queryBlock.addSelectItem(countExpr);
            } else {
                selectList.clear();
                selectList.add(countItem);
            }
            return SQLUtils.toSQLString(select, dbType);
        }
        if (query instanceof SQLUnionQuery) {
            return PagerUtils.createCountUseSubQuery(select, dbType);
        }
        throw new IllegalStateException();
    }

    private static String createCountUseSubQuery(SQLSelect select, String dbType) {
        SQLSelectQueryBlock countSelectQuery = PagerUtils.createQueryBlock(dbType);
        SQLSelectItem countItem = PagerUtils.createCountItem(dbType);
        countSelectQuery.getSelectList().add(countItem);
        SQLSubqueryTableSource fromSubquery = new SQLSubqueryTableSource(select);
        fromSubquery.setAlias("ALIAS_COUNT");
        countSelectQuery.setFrom(fromSubquery);
        SQLSelect countSelect = new SQLSelect(countSelectQuery);
        SQLSelectStatement countStmt = new SQLSelectStatement(countSelect, dbType);
        return SQLUtils.toSQLString(countStmt, dbType);
    }

    private static SQLSelectQueryBlock createQueryBlock(String dbType) {
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "aliyun_ads".equals(dbType)) {
            return new MySqlSelectQueryBlock();
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlSelectQueryBlock();
        }
        if ("h2".equals(dbType)) {
            return new MySqlSelectQueryBlock();
        }
        if ("oracle".equals(dbType)) {
            return new OracleSelectQueryBlock();
        }
        if ("postgresql".equals(dbType)) {
            return new PGSelectQueryBlock();
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerSelectQueryBlock();
        }
        if ("db2".equals(dbType)) {
            return new DB2SelectQueryBlock();
        }
        return new SQLSelectQueryBlock();
    }

    private static SQLSelectItem createCountItem(String dbType) {
        SQLAggregateExpr countExpr = new SQLAggregateExpr("COUNT");
        countExpr.addArgument(new SQLAllColumnExpr());
        SQLSelectItem countItem = new SQLSelectItem(countExpr);
        return countItem;
    }

    private static void clearOrderBy(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getOrderBy() != null) {
                queryBlock.setOrderBy(null);
            }
            return;
        }
        if (query instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)query;
            if (union.getOrderBy() != null) {
                union.setOrderBy(null);
            }
            PagerUtils.clearOrderBy(union.getLeft());
            PagerUtils.clearOrderBy(union.getRight());
        }
    }

    public static int getLimit(String sql, String dbType) {
        SQLSelectStatement selectStmt;
        SQLSelectQuery query;
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() != 1) {
            return -1;
        }
        SQLStatement stmt = stmtList.get(0);
        if (stmt instanceof SQLSelectStatement && (query = (selectStmt = (SQLSelectStatement)stmt).getSelect().getQuery()) instanceof SQLSelectQueryBlock) {
            if (query instanceof MySqlSelectQueryBlock) {
                SQLLimit limit = ((MySqlSelectQueryBlock)query).getLimit();
                if (limit == null) {
                    return -1;
                }
                SQLExpr rowCountExpr = limit.getRowCount();
                if (rowCountExpr instanceof SQLNumericLiteralExpr) {
                    int rowCount = ((SQLNumericLiteralExpr)rowCountExpr).getNumber().intValue();
                    return rowCount;
                }
                return Integer.MAX_VALUE;
            }
            if (query instanceof OdpsSelectQueryBlock) {
                SQLExpr rowCountExpr;
                SQLLimit limit = ((OdpsSelectQueryBlock)query).getLimit();
                SQLExpr sQLExpr = rowCountExpr = limit != null ? limit.getRowCount() : null;
                if (rowCountExpr instanceof SQLNumericLiteralExpr) {
                    int rowCount = ((SQLNumericLiteralExpr)rowCountExpr).getNumber().intValue();
                    return rowCount;
                }
                return Integer.MAX_VALUE;
            }
            return -1;
        }
        return -1;
    }

    public static boolean hasUnorderedLimit(String sql, String dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if ("mysql".equals(dbType)) {
            MySqlUnorderedLimitDetectVisitor visitor = new MySqlUnorderedLimitDetectVisitor();
            for (SQLStatement stmt : stmtList) {
                stmt.accept(visitor);
            }
            return visitor.unorderedLimitCount > 0;
        }
        if ("oracle".equals(dbType)) {
            OracleUnorderedLimitDetectVisitor visitor = new OracleUnorderedLimitDetectVisitor();
            for (SQLStatement stmt : stmtList) {
                stmt.accept(visitor);
            }
            return visitor.unorderedLimitCount > 0;
        }
        throw new DruidRuntimeException("not supported. dbType : " + dbType);
    }

    private static class OracleUnorderedLimitDetectVisitor
    extends OracleASTVisitorAdapter {
        public int unorderedLimitCount;

        private OracleUnorderedLimitDetectVisitor() {
        }

        @Override
        public boolean visit(SQLBinaryOpExpr x) {
            SQLExpr left = x.getLeft();
            SQLExpr right = x.getRight();
            boolean rownum = false;
            if (left instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)left).getName().equalsIgnoreCase("ROWNUM") && right instanceof SQLLiteralExpr) {
                rownum = true;
            } else if (right instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)right).getName().equalsIgnoreCase("ROWNUM") && left instanceof SQLLiteralExpr) {
                rownum = true;
            }
            SQLSelectQueryBlock selectQuery = null;
            if (rownum) {
                for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                    SQLSelect subSelect;
                    if (!(parent instanceof SQLSelectQuery)) continue;
                    if (!(parent instanceof OracleSelectQueryBlock)) break;
                    OracleSelectQueryBlock queryBlock = (OracleSelectQueryBlock)parent;
                    SQLTableSource from = queryBlock.getFrom();
                    if (from instanceof SQLExprTableSource) {
                        selectQuery = queryBlock;
                        break;
                    }
                    if (!(from instanceof SQLSubqueryTableSource) || !((subSelect = ((SQLSubqueryTableSource)from).getSelect()).getQuery() instanceof OracleSelectQueryBlock)) break;
                    selectQuery = (OracleSelectQueryBlock)subSelect.getQuery();
                    break;
                }
            }
            if (selectQuery != null) {
                SQLOrderBy orderBy = selectQuery.getOrderBy();
                SQLObject parent = selectQuery.getParent();
                if (orderBy == null && parent instanceof SQLSelect) {
                    SQLSelect select = (SQLSelect)parent;
                    orderBy = select.getOrderBy();
                }
                if (orderBy == null || orderBy.getItems().size() == 0) {
                    ++this.unorderedLimitCount;
                }
            }
            return true;
        }

        @Override
        public boolean visit(OracleSelectQueryBlock queryBlock) {
            boolean isExprTableSrc = queryBlock.getFrom() instanceof SQLExprTableSource;
            if (!isExprTableSrc) {
                return true;
            }
            boolean rownum = false;
            for (SQLSelectItem item : queryBlock.getSelectList()) {
                SQLExpr itemExpr = item.getExpr();
                if (!(itemExpr instanceof SQLIdentifierExpr) || !((SQLIdentifierExpr)itemExpr).getName().equalsIgnoreCase("ROWNUM")) continue;
                rownum = true;
                break;
            }
            if (!rownum) {
                return true;
            }
            SQLObject parent = queryBlock.getParent();
            if (!(parent instanceof SQLSelect)) {
                return true;
            }
            SQLSelect select = (SQLSelect)parent;
            if (select.getOrderBy() == null || select.getOrderBy().getItems().size() == 0) {
                ++this.unorderedLimitCount;
            }
            return false;
        }
    }

    private static class MySqlUnorderedLimitDetectVisitor
    extends MySqlASTVisitorAdapter {
        public int unorderedLimitCount;

        private MySqlUnorderedLimitDetectVisitor() {
        }

        @Override
        public boolean visit(MySqlSelectQueryBlock x) {
            SQLOrderBy orderBy = x.getOrderBy();
            SQLLimit limit = x.getLimit();
            if (limit != null && (orderBy == null || orderBy.getItems().size() == 0)) {
                SQLSelectQueryBlock subquery;
                SQLSubqueryTableSource subqueryTabSrc;
                SQLSelect select;
                boolean subQueryHasOrderBy = false;
                SQLTableSource from = x.getFrom();
                if (from instanceof SQLSubqueryTableSource && (select = (subqueryTabSrc = (SQLSubqueryTableSource)from).getSelect()).getQuery() instanceof SQLSelectQueryBlock && (subquery = (SQLSelectQueryBlock)select.getQuery()).getOrderBy() != null && subquery.getOrderBy().getItems().size() > 0) {
                    subQueryHasOrderBy = true;
                }
                if (!subQueryHasOrderBy) {
                    ++this.unorderedLimitCount;
                }
            }
            return true;
        }
    }
}

