/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.quartz;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.dao.pager.Pager;
import org.nutz.integration.quartz.QuartzJob;
import org.nutz.integration.quartz.QuartzManager;
import org.nutz.integration.quartz.Quartzs;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzManagerImpl
implements QuartzManager {
    protected Scheduler scheduler;

    @Override
    public QuartzJob fetch(String name, String group) {
        try {
            JobKey jobKey = new JobKey(name, group);
            if (!this.scheduler.checkExists(jobKey)) {
                return null;
            }
            JobDetail jd = this.scheduler.getJobDetail(jobKey);
            Trigger trigger = this.scheduler.getTrigger(new TriggerKey(name, group));
            QuartzJob qj = new QuartzJob(jobKey, trigger, jd);
            return qj;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cron(String cron, Class<?> klass) {
        String name = klass.getName();
        this.cron(cron, klass, name, "DEFAULT");
    }

    @Override
    public void cron(String cron, Class<?> klass, String name, String group) {
        QuartzJob qj = new QuartzJob();
        qj.setClassName(klass.getName());
        qj.setJobName(name);
        qj.setJobGroup(group);
        qj.setCron(cron);
        this.add(qj);
    }

    @Override
    public List<QuartzJob> query(String namePatten, String groupPatten, Pager pager) {
        try {
            int offset = pager == null ? 0 : pager.getOffset();
            int size = pager == null ? 0 : pager.getPageSize();
            int index = 0;
            Pattern nameP = Strings.isBlank((CharSequence)namePatten) ? null : Pattern.compile(namePatten);
            Pattern groupP = Strings.isBlank((CharSequence)groupPatten) ? null : Pattern.compile(groupPatten);
            ArrayList<QuartzJob> jobs = new ArrayList<QuartzJob>();
            for (String groupName : this.scheduler.getJobGroupNames()) {
                if (groupName != null && groupP != null && !groupP.matcher(groupName).find()) continue;
                for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                    if (nameP != null && !nameP.matcher(jobKey.getName()).find()) continue;
                    List triggers = this.scheduler.getTriggersOfJob(jobKey);
                    if (size == 0 || index >= offset && index < offset + size) {
                        jobs.add(new QuartzJob(jobKey, (Trigger)triggers.get(0), this.scheduler.getJobDetail(jobKey)));
                    }
                    ++index;
                }
            }
            return jobs;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(QuartzJob qj) {
        return this.delete(qj.getJobKey());
    }

    @Override
    public boolean delete(JobKey jobKey) {
        try {
            if (this.scheduler.checkExists(jobKey)) {
                return this.scheduler.deleteJob(jobKey);
            }
            return false;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(String name, String group, String cron, Class<?> klass) {
        this.cron(cron, klass, name, group);
    }

    @Override
    public void add(QuartzJob qj) {
        try {
            Class<?> klass = Class.forName(qj.getClassName());
            JobKey jobKey = qj.getJobKey();
            Trigger trigger = qj.getTrigger();
            HashSet<Trigger> triggers = new HashSet<Trigger>();
            triggers.add(trigger);
            NutMap tmp = null;
            if (!Strings.isBlank((CharSequence)qj.getDataMap())) {
                tmp = (NutMap)Json.fromJson(NutMap.class, (CharSequence)qj.getDataMap());
            }
            JobDataMap data = tmp == null ? new JobDataMap() : new JobDataMap((Map)tmp);
            this.scheduler.scheduleJob(Quartzs.makeJob(jobKey, klass, data), triggers, true);
        }
        catch (ClassNotFoundException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        catch (SchedulerException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    @Override
    public boolean exist(QuartzJob qj) {
        return this.exist(qj.getJobKey());
    }

    @Override
    public boolean exist(JobKey jobKey) {
        try {
            return this.scheduler.checkExists(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resume(JobKey jobKey) {
        try {
            this.scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resume(QuartzJob qj) {
        this.resume(qj.getJobKey());
    }

    @Override
    public void clear() {
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pause(QuartzJob qj) {
        this.pause(qj.getJobKey());
    }

    @Override
    public void pause(JobKey jobKey) {
        try {
            this.scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void interrupt(JobKey jobKey) {
        try {
            this.scheduler.interrupt(jobKey);
        }
        catch (UnableToInterruptJobException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void interrupt(QuartzJob qj) {
        this.interrupt(qj.getJobKey());
    }

    @Override
    public Trigger.TriggerState getState(QuartzJob qj) {
        try {
            if (this.scheduler instanceof StdScheduler) {
                QuartzScheduler qs = (QuartzScheduler)Mirror.me((Object)this.scheduler).getEjecting("sched").eject((Object)this.scheduler);
                return qs.getTriggerState(qj.getTrigger().getKey());
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        throw Lang.noImplement();
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

