/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop.config.impl;

import java.util.regex.Pattern;
import org.nutz.aop.MethodMatcher;
import org.nutz.aop.matcher.MethodMatcherFactory;

public class AopConfigrationItem {
    private String className;
    private String methodName;
    private String interceptor;
    private boolean singleton;
    private MethodMatcher methodMatcher;
    private Pattern classnamePattern;

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean matchClassName(String className) {
        return this.classnamePattern.matcher(className).find();
    }

    public AopConfigrationItem() {
    }

    public AopConfigrationItem(String className, String methodName, String interceptor, boolean singleton) {
        this.className = className;
        this.methodName = methodName;
        this.interceptor = interceptor;
        this.singleton = singleton;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        this.classnamePattern = Pattern.compile(className);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.methodMatcher = MethodMatcherFactory.matcher(methodName);
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }
}

