/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DaoException;
import org.nutz.dao.DaoInterceptorChain;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.nutz.trans.Transaction;

public class NutDaoRunner
implements DaoRunner {
    private static final Log log = Logs.get();
    protected DataSource slaveDataSource;
    protected DatabaseMeta meta;

    @Override
    public void run(final DataSource dataSource, final ConnCallback callback) {
        if (callback instanceof DaoInterceptorChain) {
            DaoInterceptorChain chain = (DaoInterceptorChain)callback;
            DaoStatement[] sts = chain.getDaoStatements();
            boolean useTrans = false;
            boolean isAllSelect = true;
            for (DaoStatement st : sts) {
                if (st.isSelect() || st.isForceExecQuery()) continue;
                isAllSelect = false;
                break;
            }
            switch (this.meta.getType()) {
                case PSQL: {
                    useTrans = true;
                    break;
                }
                case SQLITE: {
                    Transaction t = Trans.get();
                    if (t == null) {
                        if (isAllSelect) {
                            useTrans = false;
                            break;
                        }
                        chain.setAutoTransLevel(1);
                        useTrans = true;
                        break;
                    }
                    if (t.getLevel() == 8 || t.getLevel() == 1) break;
                    t.setLevel(1);
                    useTrans = true;
                    break;
                }
                default: {
                    boolean bl = useTrans = !Trans.isTransactionNone() || sts.length != 1 && !isAllSelect;
                }
            }
            if (useTrans && chain.getAutoTransLevel() > 0) {
                Trans.exec(chain.getAutoTransLevel(), new Atom(){

                    @Override
                    public void run() {
                        NutDaoRunner.this._run(dataSource, callback);
                    }
                });
                return;
            }
        }
        this._run(dataSource, callback);
    }

    public void _run(DataSource dataSource, ConnCallback callback) {
        Transaction t = Trans.get();
        if (null != t) {
            this._runWithTransaction(t, dataSource, callback);
        } else {
            this._runWithoutTransaction(dataSource, callback);
        }
    }

    protected void _runWithTransaction(Transaction t, DataSource dataSource, ConnCallback callback) {
        Connection conn = null;
        Savepoint sp = null;
        try {
            conn = t.getConnection(this.selectDataSource(t, dataSource, callback));
            if (this.meta != null && this.meta.isPostgresql()) {
                sp = conn.setSavepoint();
            }
            this.runCallback(conn, callback);
        }
        catch (Exception e) {
            if (sp != null && conn != null) {
                try {
                    conn.rollback(sp);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (e instanceof DaoException) {
                throw (DaoException)e;
            }
            throw new DaoException(e);
        }
    }

    public void _runWithoutTransaction(DataSource dataSource, ConnCallback callback) {
        Connection conn = null;
        try {
            conn = this.selectDataSource(null, dataSource, callback).getConnection();
            this.runCallback(conn, callback);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DaoException) {
                throw (DaoException)e;
            }
            throw new DaoException(e);
        }
        finally {
            block16: {
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (SQLException closeE) {
                        if (!log.isWarnEnabled()) break block16;
                        log.warn("Fail to close connection!", closeE);
                    }
                }
            }
        }
    }

    protected void runCallback(Connection conn, ConnCallback callback) throws Exception {
        callback.invoke(conn);
    }

    public void setMeta(DatabaseMeta meta) {
        this.meta = meta;
    }

    public void setSlaveDataSource(DataSource slaveDataSource) {
        this.slaveDataSource = slaveDataSource;
    }

    protected DataSource selectDataSource(Transaction t, DataSource master, ConnCallback callback) {
        DaoInterceptorChain chain;
        DaoStatement[] sts;
        if (this.slaveDataSource == null) {
            return master;
        }
        if (t == null && callback instanceof DaoInterceptorChain && (sts = (chain = (DaoInterceptorChain)callback).getDaoStatements()).length == 1 && (sts[0].isSelect() || sts[0].isForceExecQuery())) {
            return this.slaveDataSource;
        }
        return master;
    }
}

