/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log;

import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.impl.Log4jLogAdapter;
import org.nutz.log.impl.NopLog;
import org.nutz.log.impl.SystemLogAdapter;
import org.nutz.plugin.SimplePluginManager;

public final class Logs {
    private static LogAdapter adapter;
    public static LogAdapter NOP_ADAPTER;

    public static Log getLog(Class<?> clazz) {
        return Logs.getLog(clazz.getName());
    }

    public static Log getLog(String className) {
        return adapter.getLogger(className);
    }

    public static Log get() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (Lang.isAndroid) {
            for (int i = 0; i < sts.length; ++i) {
                if (!sts[i].getClassName().equals(Logs.class.getName())) continue;
                return adapter.getLogger(sts[i + 1].getClassName());
            }
        }
        return adapter.getLogger(sts[2].getClassName());
    }

    public static void init() {
        try {
            String packageName = Logs.class.getPackage().getName() + ".impl.";
            adapter = (LogAdapter)new SimplePluginManager(packageName + "CustomLogAdapter", packageName + "Slf4jLogAdapter", packageName + "Log4jLogAdapter", packageName + "SystemLogAdapter").get();
        }
        catch (Throwable e) {
            try {
                Log4jLogAdapter tmp = new Log4jLogAdapter();
                adapter = tmp.canWork() ? tmp : new SystemLogAdapter();
            }
            catch (Throwable _e) {
                adapter = new SystemLogAdapter();
            }
        }
    }

    public static void setAdapter(LogAdapter adapter) {
        Logs.adapter = adapter;
    }

    static {
        Logs.init();
        NOP_ADAPTER = NopLog.NOP;
    }
}

