/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Nums;
import org.nutz.lang.Strings;

public abstract class Times {
    private static final Pattern _p_tm = Pattern.compile("^([0-9]{1,2}):([0-9]{1,2})(:([0-9]{1,2})([.,]([0-9]{1,3}))?)?$");
    private static Pattern _P_TIME = Pattern.compile("^((\\d{2,4})([/\\\\-])?(\\d{1,2})([/\\\\-])?(\\d{1,2}))?(([ T])?(\\d{1,2})(:)(\\d{1,2})((:)(\\d{1,2}))?(([.])(\\d{1,}))?)?(([+-])(\\d{1,2})(:\\d{1,2})?)?$");
    private static Pattern _P_TIME_LONG = Pattern.compile("^[0-9]+(L)?$");
    private static final int[] _MDs = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] _MMM = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final DateFormat DF_DATE_TIME_MS = new SimpleDateFormat("y-M-d H:m:s.S");
    private static final DateFormat DF_DATE_TIME_MS2 = new SimpleDateFormat("yy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat DF_DATE_TIME_MS4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat DF_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final long T_1S = 1000L;
    public static final long T_1M = 60000L;
    public static final long T_1H = 3600000L;
    public static final long T_1D = 86400000L;
    private static String TIME_S_EN = "s";
    private static String TIME_M_EN = "m";
    private static String TIME_H_EN = "h";
    private static String TIME_D_EN = "d";
    private static String TIME_S_CN = "\u79d2";
    private static String TIME_M_CN = "\u5206";
    private static String TIME_H_CN = "\u65f6";
    private static String TIME_D_CN = "\u5929";
    public static final long T_1MS = 1L;
    public static final long T_1W = 604800000L;

    public static boolean leapYear(int year) {
        if (year < 4) {
            return false;
        }
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    public static int countLeapYear(int year) {
        int span = year - 1;
        return span / 4 - span / 100 + span / 400;
    }

    public static int[] T(int sec) {
        TmInfo ti = Times.Ti(sec);
        return Nums.array(ti.hour, ti.minute, ti.second);
    }

    public static int T(String ts) {
        return Times.Ti((String)ts).value;
    }

    public static TmInfo Ti(int sec) {
        TmInfo ti = new TmInfo();
        ti.valueInMillisecond = sec * 1000;
        ti.__recound_by_valueInMilliSecond();
        return ti;
    }

    public static TmInfo Tims(long ams) {
        TmInfo ti = new TmInfo();
        ti.valueInMillisecond = (int)ams;
        ti.__recound_by_valueInMilliSecond();
        return ti;
    }

    public static TmInfo Ti(String ts) {
        Matcher m = _p_tm.matcher(ts);
        if (m.find()) {
            TmInfo ti = new TmInfo();
            if (null == m.group(3)) {
                ti.hour = Integer.parseInt(m.group(1));
                ti.minute = Integer.parseInt(m.group(2));
                ti.second = 0;
                ti.millisecond = 0;
            } else if (null == m.group(5)) {
                ti.hour = Integer.parseInt(m.group(1));
                ti.minute = Integer.parseInt(m.group(2));
                ti.second = Integer.parseInt(m.group(4));
                ti.millisecond = 0;
            } else {
                ti.hour = Integer.parseInt(m.group(1));
                ti.minute = Integer.parseInt(m.group(2));
                ti.second = Integer.parseInt(m.group(4));
                ti.millisecond = Integer.parseInt(m.group(6));
            }
            ti.value = ti.hour * 3600 + ti.minute * 60 + ti.second;
            ti.valueInMillisecond = ti.value * 1000 + ti.millisecond;
            return ti;
        }
        throw Lang.makeThrow("Wrong format of time string '%s'", ts);
    }

    public static Date now() {
        return new Date(System.currentTimeMillis());
    }

    public static long ams(String ds) {
        return Times.ams(ds, null);
    }

    public static long ams(String ds, TimeZone tz) {
        Matcher m = _P_TIME.matcher(ds);
        if (m.find()) {
            int yy = Times._int(m, 2, 1970);
            int MM = Times._int(m, 4, 1);
            int dd = Times._int(m, 6, 1);
            int HH = Times._int(m, 9, 0);
            int mm = Times._int(m, 11, 0);
            int ss = Times._int(m, 14, 0);
            int ms = Times._int(m, 17, 0);
            String str = String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d", yy, MM, dd, HH, mm, ss, ms);
            SimpleDateFormat df = (SimpleDateFormat)DF_DATE_TIME_MS4.clone();
            if (null == tz && !Strings.isBlank(m.group(18))) {
                tz = TimeZone.getTimeZone(String.format("GMT%s%s:00", m.group(19), m.group(20)));
            }
            if (null != tz) {
                df.setTimeZone(tz);
            }
            try {
                return df.parse(str).getTime();
            }
            catch (ParseException e) {
                throw Lang.wrapThrow(e);
            }
        }
        if (_P_TIME_LONG.matcher(ds).find()) {
            if (ds.endsWith("L")) {
                ds.substring(0, ds.length() - 1);
            }
            return Long.parseLong(ds);
        }
        throw Lang.makeThrow("Unexpect date format '%s'", ds);
    }

    @Deprecated
    public static long ms(String ds, TimeZone tz) {
        return Times.ams(ds, tz);
    }

    public static long ms(Date d) {
        return Times.ms(Times.C(d));
    }

    public static int ms(Calendar c) {
        int ms = c.get(11) * 3600000;
        ms += c.get(12) * 60000;
        ms += c.get(13) * 1000;
        return ms += c.get(14);
    }

    public static int ms() {
        return Times.ms(Calendar.getInstance());
    }

    public static int ms(String str) {
        return Times.Ti((String)str).valueInMillisecond;
    }

    public static String mss(int ms) {
        int sec = ms / 1000;
        return Times.secs(sec) + "." + Strings.alignRight(ms -= sec * 1000, 3, '0');
    }

    public static String secs(int sec) {
        int hh = sec / 3600;
        int mm = (sec -= hh * 3600) / 60;
        return Strings.alignRight(hh, 2, '0') + ":" + Strings.alignRight(mm, 2, '0') + ":" + Strings.alignRight(sec -= mm * 60, 2, '0');
    }

    public static int sec(Date d) {
        Calendar c = Times.C(d);
        int sec = c.get(11) * 3600;
        sec += c.get(12) * 60;
        return sec += c.get(13);
    }

    public static int sec() {
        return Times.sec(Times.now());
    }

    public static Date D(String ds) {
        return Times.D(Times.ams(ds));
    }

    private static int _int(Matcher m, int index, int dft) {
        String s = m.group(index);
        if (Strings.isBlank(s)) {
            return dft;
        }
        return Integer.parseInt(s);
    }

    public static int D1970(int yy, int MM, int dd) {
        int year = yy < 100 ? yy + 1970 : yy;
        int day = (year - 1970) * 365;
        day += Times.countLeapYear(year) - Times.countLeapYear(1970);
        int mi = Math.min(MM - 1, 11);
        boolean isLeapYear = Times.leapYear(yy);
        for (int i = 0; i < mi; ++i) {
            day += _MDs[i];
        }
        if (isLeapYear && MM > 2) {
            ++day;
        }
        day += Math.min(dd, _MDs[mi]) - 1;
        if (isLeapYear && dd == 29) {
            ++day;
        }
        return day;
    }

    public static Date D(long ms) {
        return new Date(ms);
    }

    public static Calendar C(String ds) {
        return Times.C(Times.D(ds));
    }

    public static Calendar C(Date d) {
        return Times.C(d.getTime());
    }

    public static Calendar C(long ms) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ms);
        return c;
    }

    public static String sDTms(Date d) {
        return Times.format(DF_DATE_TIME_MS, d);
    }

    public static String sDTms2(Date d) {
        return Times.format(DF_DATE_TIME_MS2, d);
    }

    public static String sDTms4(Date d) {
        return Times.format(DF_DATE_TIME_MS4, d);
    }

    public static String sDT(Date d) {
        return Times.format(DF_DATE_TIME, d);
    }

    public static String sD(Date d) {
        return Times.format(DF_DATE, d);
    }

    public static String sT(int sec) {
        int[] ss = Times.T(sec);
        return Strings.alignRight(ss[0], 2, '0') + ":" + Strings.alignRight(ss[1], 2, '0') + ":" + Strings.alignRight(ss[2], 2, '0');
    }

    public static String sTmin(int sec) {
        int[] ss = Times.T(sec);
        return Strings.alignRight(ss[0], 2, '0') + ":" + Strings.alignRight(ss[1], 2, '0');
    }

    public static String sTms(long ams) {
        return Times.Tims(ams).toString("HH:mm:ss,SSS");
    }

    public static Date[] week(int off) {
        return Times.week(System.currentTimeMillis(), off);
    }

    public static Date[] week(long base, int off) {
        return Times.weeks(base, off, off);
    }

    public static Date[] weeks(int offL, int offR) {
        return Times.weeks(System.currentTimeMillis(), offL, offR);
    }

    public static Date[] weeks(long base, int offL, int offR) {
        int from = Math.min(offL, offR);
        int len = Math.abs(offL - offR);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(base);
        Date[] re = new Date[2];
        c.add(6, 7 * from);
        c.set(7, 2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        re[0] = c.getTime();
        c.add(6, 7 * (len + 1));
        c.add(14, -1);
        re[1] = c.getTime();
        return re;
    }

    public static String formatForRead(Date d) {
        long ms = System.currentTimeMillis() - d.getTime();
        if (ms < 60000L) {
            return "Just Now";
        }
        if (ms < 3600000L) {
            return "" + ms / 60000L + "Min.";
        }
        if (ms < 86400000L) {
            return "" + ms / 3600000L + "hr.";
        }
        if (ms < 604800000L) {
            return "" + ms / 86400000L + "Day";
        }
        Calendar c = Calendar.getInstance();
        int thisYear = c.get(1);
        c.setTime(d);
        int yy = c.get(1);
        int mm = c.get(2);
        if (thisYear == yy) {
            int dd = c.get(5);
            return String.format("%s %d", _MMM[mm], dd);
        }
        return String.format("%s %d", _MMM[mm], yy);
    }

    public static String format(DateFormat fmt, Date d) {
        return ((DateFormat)fmt.clone()).format(d);
    }

    public static String format(String fmt, Date d) {
        return new SimpleDateFormat(fmt, Locale.ENGLISH).format(d);
    }

    public static Date parseq(DateFormat fmt, String s) {
        try {
            return Times.parse(fmt, s);
        }
        catch (ParseException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Date parseq(String fmt, String s) {
        try {
            return Times.parse(fmt, s);
        }
        catch (ParseException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Date parse(DateFormat fmt, String s) throws ParseException {
        return ((DateFormat)fmt.clone()).parse(s);
    }

    public static Date parse(String fmt, String s) throws ParseException {
        return new SimpleDateFormat(fmt).parse(s);
    }

    public static long toMillis(String tstr) {
        if (Strings.isBlank(tstr)) {
            return 0L;
        }
        tstr = tstr.toLowerCase();
        String tl = tstr.substring(0, tstr.length() - 1);
        String tu = tstr.substring(tstr.length() - 1);
        if (TIME_S_EN.equals(tu)) {
            return 1000L * Long.valueOf(tl);
        }
        if (TIME_M_EN.equals(tu)) {
            return 60000L * Long.valueOf(tl);
        }
        if (TIME_H_EN.equals(tu)) {
            return 3600000L * Long.valueOf(tl);
        }
        if (TIME_D_EN.equals(tu)) {
            return 86400000L * Long.valueOf(tl);
        }
        return Long.valueOf(tstr);
    }

    public static String fromMillis(long mi) {
        return Times._fromMillis(mi, true);
    }

    public static String fromMillisCN(long mi) {
        return Times._fromMillis(mi, false);
    }

    private static String _fromMillis(long mi, boolean useEnglish) {
        if (mi <= 1000L) {
            return "1" + (useEnglish ? TIME_S_EN : TIME_S_CN);
        }
        if (mi < 60000L && mi > 1000L) {
            return (int)(mi / 1000L) + (useEnglish ? TIME_S_EN : TIME_S_CN);
        }
        if (mi >= 60000L && mi < 3600000L) {
            int m = (int)(mi / 60000L);
            return m + (useEnglish ? TIME_M_EN : TIME_M_CN) + Times._fromMillis(mi - (long)m * 60000L, useEnglish);
        }
        if (mi >= 3600000L && mi < 86400000L) {
            int h = (int)(mi / 3600000L);
            return h + (useEnglish ? TIME_H_EN : TIME_H_CN) + Times._fromMillis(mi - (long)h * 3600000L, useEnglish);
        }
        int d = (int)(mi / 86400000L);
        return d + (useEnglish ? TIME_D_EN : TIME_D_CN) + Times._fromMillis(mi - (long)d * 86400000L, useEnglish);
    }

    public static boolean sDTcompare(String t1, String t2) {
        Date d2;
        Date d1 = Times.parseq(DF_DATE_TIME, t1);
        return d1.before(d2 = Times.parseq(DF_DATE_TIME, t2));
    }

    public static String ts2S(long timestamp, String sf) {
        SimpleDateFormat format = new SimpleDateFormat(sf);
        return format.format(new Date(Long.parseLong(timestamp * 1000L + "")));
    }

    public static long getTS() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String sDT2TS(String str, DateFormat df) {
        String timestamp = null;
        try {
            Date date = df.parse(str);
            long l = date.getTime();
            String tmp = String.valueOf(l);
            timestamp = tmp.substring(0, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static String getNowSDT() {
        return Times.sDT(Times.now());
    }

    public static int getDaysOfMonth(String year, String month) {
        int days = 0;
        days = month.equals("1") || month.equals("3") || month.equals("5") || month.equals("7") || month.equals("8") || month.equals("10") || month.equals("12") ? 31 : (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") ? 30 : (Integer.parseInt(year) % 4 == 0 && Integer.parseInt(year) % 100 != 0 || Integer.parseInt(year) % 400 == 0 ? 29 : 28));
        return days;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static int getToday() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static int getToMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static int getToYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static long dayDiff(Date date1, Date date2) {
        return (date2.getTime() - date1.getTime()) / 86400000L;
    }

    public static int yearDiff(String before, String after) {
        Date beforeDay = Times.parseq(DF_DATE, before);
        Date afterDay = Times.parseq(DF_DATE, after);
        return Times.getYear(afterDay) - Times.getYear(beforeDay);
    }

    public static int yearDiffCurr(String after) {
        Date beforeDay = new Date();
        Date afterDay = Times.parseq(DF_DATE, after);
        return Times.getYear(beforeDay) - Times.getYear(afterDay);
    }

    public static long dayDiffCurr(String before) {
        Date currDate = Times.parseq(DF_DATE, Times.sD(Times.now()));
        Date beforeDate = Times.parseq(DF_DATE, before);
        return (currDate.getTime() - beforeDate.getTime()) / 86400000L;
    }

    public static String getAstro(String birth) {
        if (!Times.isDate(birth)) {
            birth = "2000" + birth;
        }
        if (!Times.isDate(birth)) {
            return "";
        }
        int month = Integer.parseInt(birth.substring(birth.indexOf("-") + 1, birth.lastIndexOf("-")));
        int day = Integer.parseInt(birth.substring(birth.lastIndexOf("-") + 1));
        String s = "\u9b54\u7faf\u6c34\u74f6\u53cc\u9c7c\u7261\u7f8a\u91d1\u725b\u53cc\u5b50\u5de8\u87f9\u72ee\u5b50\u5904\u5973\u5929\u79e4\u5929\u874e\u5c04\u624b\u9b54\u7faf";
        int[] arr = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
        int start = month * 2 - (day < arr[month - 1] ? 2 : 0);
        return s.substring(start, start + 2) + "\u5ea7";
    }

    public static boolean isDate(String date) {
        StringBuffer reg = new StringBuffer("^((\\d{2}(([02468][048])|([13579][26]))-?((((0?");
        reg.append("[13578])|(1[02]))-?((0?[1-9])|([1-2][0-9])|(3[01])))");
        reg.append("|(((0?[469])|(11))-?((0?[1-9])|([1-2][0-9])|(30)))|");
        reg.append("(0?2-?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][12");
        reg.append("35679])|([13579][01345789]))-?((((0?[13578])|(1[02]))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(30)))|(0?2-?((0?[");
        reg.append("1-9])|(1[0-9])|(2[0-8]))))))");
        Pattern p = Pattern.compile(reg.toString());
        return p.matcher(date).matches();
    }

    public static Date nextYear(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(1, years);
        return cal.getTime();
    }

    public static Date nextMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date nextWeek(Date date, int week) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(4, week);
        return cal.getTime();
    }

    public static Date nextDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(6, day);
        return cal.getTime();
    }

    public static int getDayNum() {
        int daynum = 0;
        GregorianCalendar gd = new GregorianCalendar();
        Date dt = gd.getTime();
        GregorianCalendar gd1 = new GregorianCalendar(1900, 1, 1);
        Date dt1 = gd1.getTime();
        daynum = (int)((dt.getTime() - dt1.getTime()) / 86400000L);
        return daynum;
    }

    public static Date getDateByNum(int day) {
        GregorianCalendar gd = new GregorianCalendar(1900, 1, 1);
        Date date = gd.getTime();
        date = Times.nextDay(date, day);
        return date;
    }

    public static String nextDay(int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Times.now());
        cal.add(6, day);
        return Times.format(DF_DATE, cal.getTime());
    }

    public static String afterDay() {
        return Times.nextDay(1);
    }

    public static String befoDay() {
        return Times.nextDay(-1);
    }

    public static String getLastDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return Times.format(DF_DATE, cal.getTime());
    }

    public static String getFirstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return Times.format(DF_DATE, cal.getTime());
    }

    public static long between(Date s, Date e, long unit) {
        Date end;
        Date start;
        if (s.before(e)) {
            start = s;
            end = e;
        } else {
            start = e;
            end = s;
        }
        long diff = end.getTime() - start.getTime();
        return diff / unit;
    }

    public static Date nextMinute(Date date, int minute) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(12, minute);
        return cal.getTime();
    }

    public static Date nextSecond(Date date, int second) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(13, second);
        return cal.getTime();
    }

    public static Date nextHour(Date date, int hour) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(10, hour);
        return cal.getTime();
    }

    public static Date ts2D(long timestamp) {
        return new Date(Long.parseLong(timestamp * 1000L + ""));
    }

    public static long d2TS(Date date) {
        if (Lang.isEmpty(date)) {
            return Times.getTS();
        }
        return Long.parseLong(Times.sDT2TS(Times.sDT(date), DF_DATE_TIME));
    }

    public static class TmInfo {
        public int value;
        public int valueInMillisecond;
        public int hour;
        public int minute;
        public int second;
        public int millisecond;
        private static Pattern _p_tmfmt = Pattern.compile("a|[HhKkms]{1,2}|S(SS)?");

        public void offset(int sec) {
            this.valueInMillisecond += sec * 1000;
            this.__recound_by_valueInMilliSecond();
        }

        public void offsetInMillisecond(int ms) {
            this.valueInMillisecond += ms;
            this.__recound_by_valueInMilliSecond();
        }

        private void __recound_by_valueInMilliSecond() {
            if (this.valueInMillisecond >= 86400000) {
                this.valueInMillisecond %= 86400000;
            } else if (this.valueInMillisecond < 0) {
                this.valueInMillisecond %= 86400000;
                if (this.valueInMillisecond < 0) {
                    this.valueInMillisecond = 86400000 + this.valueInMillisecond;
                }
            }
            this.value = this.valueInMillisecond / 1000;
            this.millisecond = this.valueInMillisecond - this.value * 1000;
            this.hour = Math.min(23, this.value / 3600);
            this.minute = Math.min(59, (this.value - this.hour * 3600) / 60);
            this.second = Math.min(59, this.value - this.hour * 3600 - this.minute * 60);
        }

        public String toString() {
            String fmt = "HH:mm";
            if (0 != this.millisecond) {
                fmt = fmt + ":ss.SSS";
            } else if (0 != this.second) {
                fmt = fmt + ":ss";
            }
            return this.toString(fmt);
        }

        public String toString(String fmt) {
            StringBuilder sb = new StringBuilder();
            fmt = Strings.sBlank(fmt, "HH:mm:ss");
            Matcher m = _p_tmfmt.matcher(fmt);
            int pos = 0;
            while (m.find()) {
                int l = m.start();
                if (l > pos) {
                    sb.append(fmt.substring(pos, l));
                }
                pos = m.end();
                String s = m.group(0);
                if ("a".equals(s)) {
                    sb.append(this.value > 43200 ? "PM" : "AM");
                    continue;
                }
                if ("H".equals(s)) {
                    sb.append(this.hour);
                    continue;
                }
                if ("k".equals(s)) {
                    sb.append(this.hour + 1);
                    continue;
                }
                if ("K".equals(s)) {
                    sb.append(this.hour % 12);
                    continue;
                }
                if ("h".equals(s)) {
                    sb.append(this.hour % 12 + 1);
                    continue;
                }
                if ("m".equals(s)) {
                    sb.append(this.minute);
                    continue;
                }
                if ("s".equals(s)) {
                    sb.append(this.second);
                    continue;
                }
                if ("S".equals(s)) {
                    sb.append(this.millisecond);
                    continue;
                }
                if ("HH".equals(s)) {
                    sb.append(String.format("%02d", this.hour));
                    continue;
                }
                if ("kk".equals(s)) {
                    sb.append(String.format("%02d", this.hour + 1));
                    continue;
                }
                if ("KK".equals(s)) {
                    sb.append(String.format("%02d", this.hour % 12));
                    continue;
                }
                if ("hh".equals(s)) {
                    sb.append(String.format("%02d", this.hour % 12 + 1));
                    continue;
                }
                if ("mm".equals(s)) {
                    sb.append(String.format("%02d", this.minute));
                    continue;
                }
                if ("ss".equals(s)) {
                    sb.append(String.format("%02d", this.second));
                    continue;
                }
                if ("SSS".equals(s)) {
                    sb.append(String.format("%03d", this.millisecond));
                    continue;
                }
                sb.append(s);
            }
            if (pos < fmt.length()) {
                sb.append(fmt.substring(pos));
            }
            return sb.toString();
        }
    }
}

