/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import org.nutz.dao.entity.Entity;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.util.cri.AbstractSqlExpression;

public class Like
extends AbstractSqlExpression {
    private static final long serialVersionUID = 1L;
    private String value;
    private boolean ignoreCase;
    private String left;
    private String right;

    static Like create(String name, String value, boolean ignoreCase) {
        Like like = new Like(name);
        like.value = value;
        like.ignoreCase = ignoreCase;
        like.left = "%";
        like.right = "%";
        return like;
    }

    private Like(String name) {
        super(name);
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        String colName = this._fmtcol(en);
        if (this.not) {
            sb.append(" NOT ");
        }
        if (this.ignoreCase) {
            sb.append("LOWER(").append(colName).append(") LIKE LOWER(?)");
        } else {
            sb.append(colName).append(" LIKE ?");
        }
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        adaptors[off++] = Jdbcs.Adaptor.asString;
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        params[off++] = (null == this.left ? "" : this.left) + this.value + (null == this.right ? "" : this.right);
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return 1;
    }

    public Like left(String left) {
        this.left = left;
        return this;
    }

    public Like right(String right) {
        this.right = right;
        return this;
    }

    public Like ignoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }
}

