/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.filepool.FilePool;
import org.nutz.filepool.UU32FilePool;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.adaptor.PairAdaptor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.upload.FastUploading;
import org.nutz.mvc.upload.FieldMeta;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadException;
import org.nutz.mvc.upload.UploadingContext;
import org.nutz.mvc.upload.injector.FileInjector;
import org.nutz.mvc.upload.injector.FileMetaInjector;
import org.nutz.mvc.upload.injector.InputStreamInjector;
import org.nutz.mvc.upload.injector.MapSelfInjector;
import org.nutz.mvc.upload.injector.ReaderInjector;
import org.nutz.mvc.upload.injector.TempFileArrayInjector;
import org.nutz.mvc.upload.injector.TempFileInjector;

public class WhaleAdaptor
extends PairAdaptor {
    protected static Log log = Logs.get();
    protected UploadingContext uploadCtx;

    public WhaleAdaptor() {
        this("");
    }

    public WhaleAdaptor(String path) {
        String appRoot = Mvcs.getServletContext().getRealPath("/");
        if (appRoot == null && (appRoot = (String)Mvcs.getServletContext().getAttribute("javax.servlet.context.tmpdir")) == null && (appRoot = System.getProperty("java.io.tmpdir")) == null) {
            appRoot = "/tmp";
        }
        if (path.isEmpty()) {
            path = "${app.root}/WEB-INF/tmp/nutzupload2";
        }
        if (path.contains("${app.root}")) {
            path = path.replace("${app.root}", appRoot);
        }
        this.uploadCtx = new UploadingContext(new UU32FilePool(path));
    }

    public WhaleAdaptor(FilePool pool) {
        this(new UploadingContext(pool));
    }

    public WhaleAdaptor(UploadingContext up) {
        this.uploadCtx = up;
    }

    @Override
    protected ParamInjector evalInjectorBy(Type type, Param param) {
        String pn;
        Class<?> clazz = Lang.getTypeClass(type);
        if (clazz == null) {
            if (log.isWarnEnabled()) {
                log.warnf("!!Fail to get Type Class : type=%s , param=%s", type, param);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapSelfInjector();
        }
        String string = pn = null == param ? this.getParamRealName(this.curIndex) : param.value();
        if (File.class.isAssignableFrom(clazz)) {
            return new FileInjector(pn);
        }
        if (FieldMeta.class.isAssignableFrom(clazz)) {
            return new FileMetaInjector(pn);
        }
        if (TempFile.class.isAssignableFrom(clazz)) {
            return new TempFileInjector(pn);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return new InputStreamInjector(pn);
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return new ReaderInjector(pn);
        }
        if (TempFile[].class.isAssignableFrom(clazz)) {
            return new TempFileArrayInjector(pn);
        }
        return super.evalInjectorBy(type, param);
    }

    @Override
    protected Object getReferObject(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        String type = req.getHeader("Content-Type");
        if (!Strings.isBlank(type)) {
            if (type.contains("json")) {
                try {
                    return Json.fromJson(req.getReader());
                }
                catch (Exception e) {
                    throw Lang.wrapThrow(e);
                }
            }
            if (type.contains("multipart/form-data")) {
                FastUploading uploading = new FastUploading();
                try {
                    return uploading.parse(req, this.uploadCtx);
                }
                catch (UploadException e) {
                    throw Lang.wrapThrow(e);
                }
            }
        }
        return super.getReferObject(sc, req, resp, pathArgs);
    }
}

