/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nutz.http.Http;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;

public class Header {
    private Map<String, String> items = new HashMap<String, String>();

    protected Header() {
    }

    public Collection<String> keys() {
        return this.items.keySet();
    }

    public String get(String key) {
        return this.items.get(key);
    }

    public Header set(String key, String value) {
        if (null != key) {
            this.items.put(key, value);
        }
        return this;
    }

    public Header remove(String key) {
        this.items.remove(key);
        return this;
    }

    public Header clear() {
        this.items.clear();
        return this;
    }

    public Set<Map.Entry<String, String>> getAll() {
        return this.items.entrySet();
    }

    public Header addAll(Map<String, String> map) {
        if (null != map) {
            this.items.putAll(map);
        }
        return this;
    }

    public String toString() {
        return Json.toJson(this.items, JsonFormat.nice().setIgnoreNull(false));
    }

    public static Header create(Map<String, String> properties) {
        return new Header().addAll(properties);
    }

    public static Header create(String properties) {
        return Header.create((Map)Json.fromJson(properties));
    }

    public static Header create() {
        Header header = new Header();
        header.addAll(Http.DEFAULT_HEADERS);
        return header;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public Header asJsonContentType() {
        return this.asJsonContentType(null);
    }

    public Header asFormContentType() {
        return this.asFormContentType(null);
    }

    public Header asJsonContentType(String enc) {
        if (enc == null) {
            enc = Charset.defaultCharset().name();
        }
        this.set("Content-Type", "application/json; charset=" + enc.toUpperCase());
        return this;
    }

    public Header asFormContentType(String enc) {
        if (enc == null) {
            enc = Charset.defaultCharset().name();
        }
        this.set("Content-Type", "application/x-www-form-urlencoded; charset=" + enc.toUpperCase());
        return this;
    }
}

