/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityField;
import org.nutz.dao.entity.EntityIndex;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.PK;
import org.nutz.dao.impl.entity.field.ManyManyLinkField;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class AbstractJdbcExpert
implements JdbcExpert {
    private static final Log log = Logs.get();
    private static String DEFAULT_COMMENT_TABLE = "comment on table $table is '$tableComment'";
    private static String DEFAULT_COMMENT_COLUMN = "comment on column $table.$column is '$columnComment'";
    protected Set<String> keywords;
    protected JdbcExpertConfigFile conf;

    public AbstractJdbcExpert(JdbcExpertConfigFile conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupEntityField(Connection conn, Entity<?> en) {
        ArrayList<MappingField> mfs = new ArrayList<MappingField>();
        for (MappingField mf : en.getMappingFields()) {
            if (!mf.getTypeMirror().isEnum()) continue;
            mfs.add(mf);
        }
        if (mfs.isEmpty()) {
            return;
        }
        Statement stat = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            stat = conn.createStatement();
            rs = stat.executeQuery(this.createResultSetMetaSql(en));
            rsmd = rs.getMetaData();
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> columnLabels = new ArrayList<String>();
            int columnCount = rsmd.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnNames.add(rsmd.getColumnName(i));
                columnLabels.add(rsmd.getColumnLabel(i));
            }
            for (MappingField mf : mfs) {
                try {
                    int ci = columnNames.indexOf(mf.getColumnName()) + 1;
                    if (ci == 0) {
                        log.debugf("Can not find @Column(%s) in table/view (%s), skip checking", mf.getColumnName(), rsmd.getTableName(1));
                        continue;
                    }
                    if (Daos.isIntLikeColumn(rsmd, ci)) {
                        mf.setColumnType(ColType.INT);
                        continue;
                    }
                    mf.setColumnType(ColType.VARCHAR);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            block12: {
                try {
                    if (!log.isDebugEnabled()) break block12;
                    log.debugf("Table '%s' doesn't exist! class=%s", en.getViewName(), en.getType().getName());
                }
                catch (Throwable throwable) {
                    Daos.safeClose(stat, rs);
                    throw throwable;
                }
            }
            Daos.safeClose(stat, rs);
        }
        Daos.safeClose(stat, rs);
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        Mirror<?> mirror = ef.getTypeMirror();
        if (mirror.isEnum() && ColType.INT == ef.getColumnType()) {
            return Jdbcs.Adaptor.asEnumInt;
        }
        return Jdbcs.getAdaptor(mirror);
    }

    @Override
    public Pojo createPojo(SqlType type) {
        return new NutPojo().setSqlType(type);
    }

    @Override
    public boolean dropEntity(Dao dao, Entity<?> en) {
        String tableName = en.getTableName();
        String viewName = en.getViewName();
        try {
            this.dropRelation(dao, en);
            if (!tableName.equals(viewName) && dao.exists(viewName)) {
                dao.execute(Sqls.create("DROP VIEW " + viewName));
            }
            dao.execute(Sqls.create("DROP TABLE " + tableName));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getConf() {
        return this.conf.getConfig();
    }

    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " where 1!=1";
    }

    @Override
    public void createRelation(Dao dao, Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>(5);
        for (LinkField lf : en.visitManyMany(null, null, null)) {
            Sql sql = this.createRelation(dao, lf);
            if (sql == null) continue;
            sqls.add(sql);
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    protected Sql createRelation(Dao dao, LinkField lf) {
        ManyManyLinkField mm = (ManyManyLinkField)lf;
        if (dao.exists(mm.getRelationName())) {
            return null;
        }
        String sql = "CREATE TABLE " + mm.getRelationName() + "(\n";
        sql = sql + mm.getFromColumnName() + " " + this.evalFieldType(mm.getHostField()) + ",\n";
        sql = sql + mm.getToColumnName() + " " + this.evalFieldType(mm.getLinkedField()) + "\n";
        sql = sql + ")";
        return Sqls.create(sql);
    }

    @Override
    public void dropRelation(Dao dao, Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>(5);
        for (LinkField lf : en.visitManyMany(null, null, null)) {
            ManyManyLinkField mm = (ManyManyLinkField)lf;
            if (!dao.exists(mm.getRelationName())) continue;
            sqls.add(Sqls.create("DROP TABLE " + mm.getRelationName()));
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case CHAR: {
                return "CHAR(" + mf.getWidth() + ")";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case VARCHAR: {
                return "VARCHAR(" + mf.getWidth() + ")";
            }
            case TEXT: {
                return "TEXT";
            }
            case BINARY: {
                return "BLOB";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case DATETIME: {
                return "DATETIME";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case INT: {
                if (mf.getWidth() > 0) {
                    return "INT(" + mf.getWidth() + ")";
                }
                return "INT";
            }
            case FLOAT: {
                if (mf.getWidth() > 0 && mf.getPrecision() > 0) {
                    return "NUMERIC(" + mf.getWidth() + "," + mf.getPrecision() + ")";
                }
                if (mf.getTypeMirror().isDouble()) {
                    return "NUMERIC(15,10)";
                }
                return "FLOAT";
            }
            case PSQL_ARRAY: {
                return "ARRAY";
            }
            case PSQL_JSON: 
            case MYSQL_JSON: {
                return "JSON";
            }
        }
        throw Lang.makeThrow("Unsupport colType '%s' of field '%s' in '%s' ", new Object[]{mf.getColumnType(), mf.getName(), mf.getEntity().getType().getName()});
    }

    protected static List<DaoStatement> wrap(String ... sqls) {
        ArrayList<DaoStatement> sts = new ArrayList<DaoStatement>(sqls.length);
        for (String sql : sqls) {
            if (Strings.isBlank(sql)) continue;
            sts.add(Sqls.create(sql));
        }
        return sts;
    }

    protected static List<DaoStatement> wrap(List<String> sqls) {
        ArrayList<DaoStatement> sts = new ArrayList<DaoStatement>(sqls.size());
        for (String sql : sqls) {
            if (Strings.isBlank(sql)) continue;
            sts.add(Sqls.create(sql));
        }
        return sts;
    }

    protected static String gSQL(String ptn, String table, String field) {
        CharSegment cs = new CharSegment(ptn);
        cs.set("T", table).set("F", field);
        return cs.toString();
    }

    protected String getDefaultValue(MappingField mf) {
        return mf.getDefaultValue(null).replaceAll("@", "@@");
    }

    protected List<Sql> createIndexs(Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>();
        for (EntityIndex index : en.getIndexes()) {
            sqls.add(this.createIndexSql(en, index));
        }
        return sqls;
    }

    @Override
    public Sql createIndexSql(Entity<?> en, EntityIndex index) {
        StringBuilder sb = new StringBuilder();
        if (index.isUnique()) {
            sb.append("Create UNIQUE Index ");
        } else {
            sb.append("Create Index ");
        }
        sb.append(index.getName(en));
        sb.append(" ON ").append(en.getTableName()).append("(");
        for (EntityField field : index.getFields()) {
            if (field instanceof MappingField) {
                MappingField mf = (MappingField)field;
                sb.append(mf.getColumnNameInSql()).append(',');
                continue;
            }
            throw Lang.makeThrow(DaoException.class, "%s %s is NOT a mapping field, can't use as index field!!", en.getClass(), field.getName());
        }
        sb.setCharAt(sb.length() - 1, ')');
        return Sqls.create(sb.toString());
    }

    public void addComment(Dao dao, Entity<?> en) {
        this.addComment(dao, en, null, null);
    }

    public void addComment(Dao dao, Entity<?> en, String commentTable, String commentColumn) {
        if (!en.hasTableComment() && !en.hasColumnComment()) {
            return;
        }
        ArrayList<Sql> sqls = new ArrayList<Sql>();
        if (en.hasTableComment()) {
            Sql tableCommentSQL = Sqls.create(Strings.isBlank(commentTable) ? DEFAULT_COMMENT_TABLE : commentTable);
            tableCommentSQL.vars().set("table", en.getTableName()).set("tableComment", en.getTableComment());
            sqls.add(tableCommentSQL);
        }
        if (en.hasColumnComment()) {
            for (MappingField mf : en.getMappingFields()) {
                if (!mf.hasColumnComment() || mf.isReadonly()) continue;
                Sql columnCommentSQL = Sqls.create(Strings.isBlank(commentColumn) ? DEFAULT_COMMENT_COLUMN : commentColumn);
                columnCommentSQL.vars().set("table", en.getTableName()).set("column", mf.getColumnName()).set("columnComment", mf.getColumnComment());
                sqls.add(columnCommentSQL);
            }
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    @Override
    public void formatQuery(DaoStatement daoStatement) {
        if (daoStatement == null) {
            return;
        }
        SqlContext ctx = daoStatement.getContext();
        if (ctx == null || ctx.getPager() == null) {
            return;
        }
        if (daoStatement instanceof Pojo) {
            this.formatQuery((Pojo)daoStatement);
        } else if (daoStatement instanceof Sql) {
            this.formatQuery((Sql)daoStatement);
        } else {
            throw Lang.noImplement();
        }
    }

    public abstract void formatQuery(Pojo var1);

    public void formatQuery(Sql sql) {
        throw Lang.noImplement();
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        String autoSql = "SELECT MAX($field) AS $field FROM $view";
        SqlFieldMacro autoInfo = new SqlFieldMacro(idField, autoSql);
        autoInfo.setEntity(en);
        return autoInfo;
    }

    @Override
    public boolean isSupportAutoIncrement() {
        return true;
    }

    public String makePksName(Entity<?> en) {
        String name = en.getType().getAnnotation(PK.class).name();
        if (Strings.isBlank(name)) {
            StringBuilder sb = new StringBuilder();
            for (MappingField mf : en.getPks()) {
                sb.append("_").append(mf.getColumnName());
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return name;
    }

    public void addDefaultValue(StringBuilder sb, MappingField mf) {
        if (!mf.hasDefaultValue()) {
            return;
        }
        String dft = this.getDefaultValue(mf);
        if (mf.getColumnType() == ColType.VARCHAR || mf.getTypeMirror().isStringLike()) {
            sb.append(" DEFAULT '").append(dft).append('\'');
        } else {
            sb.append(" DEFAULT ").append(dft);
        }
    }

    @Override
    public boolean addColumnNeedColumn() {
        return true;
    }

    @Override
    public boolean supportTimestampDefault() {
        return true;
    }

    @Override
    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public String wrapKeywork(String columnName, boolean force) {
        if (force || this.keywords.contains(columnName.toUpperCase())) {
            return "`" + columnName + "`";
        }
        return null;
    }

    @Override
    public boolean isSupportGeneratedKeys() {
        return true;
    }

    @Override
    public void checkDataSource(Connection conn) throws SQLException {
    }

    @Override
    public Sql createAddColumnSql(Entity<?> en, MappingField mf) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        sb.append(en.getTableName()).append(" ADD ");
        if (this.addColumnNeedColumn()) {
            sb.append("COLUMN ");
        }
        sb.append(mf.getColumnNameInSql()).append(" ").append(this.evalFieldType(mf));
        if (mf.isUnsigned()) {
            sb.append(" UNSIGNED");
        }
        if (mf.isNotNull()) {
            sb.append(" NOT NULL");
        }
        if (mf.getColumnType() == ColType.TIMESTAMP && this.supportTimestampDefault()) {
            if (mf.hasDefaultValue()) {
                sb.append(" ").append(mf.getDefaultValue(null).replaceAll("@", "@@"));
            } else if (mf.isNotNull()) {
                sb.append(" DEFAULT 0");
            } else {
                sb.append(" NULL DEFAULT NULL");
            }
        } else if (mf.hasDefaultValue()) {
            this.addDefaultValue(sb, mf);
        }
        if (mf.hasColumnComment() && this.canCommentWhenAddIndex()) {
            sb.append(" COMMENT '").append(mf.getColumnComment()).append("'");
        }
        return Sqls.create(sb.toString());
    }

    @Override
    public boolean canCommentWhenAddIndex() {
        return false;
    }

    @Override
    public List<String> getIndexNames(Entity<?> en, Connection conn) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        String showIndexs = "show index from " + en.getTableName();
        PreparedStatement ppstat = conn.prepareStatement(showIndexs);
        ResultSet rest = ppstat.executeQuery();
        while (rest.next()) {
            String index = rest.getString(3);
            names.add(index);
        }
        return names;
    }
}

