/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.nutz.castor.Castors;
import org.nutz.http.Http;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class HttpServerResponse
implements Cloneable {
    private static final Log log = Logs.get();
    private int statusCode;
    private String statusText;
    private Map<String, String> header = new HashMap<String, String>();
    private byte[] body;
    private static final Pattern _P = Pattern.compile("^HTTP/1.\\d\\s+(\\d+)(\\s+(.*))?$");

    public HttpServerResponse clone() {
        HttpServerResponse re = new HttpServerResponse();
        re.statusCode = this.statusCode;
        re.statusText = this.statusText;
        re.header = new HashMap<String, String>();
        if (this.header != null) {
            re.header.putAll(this.header);
        }
        re.body = this.body;
        return re;
    }

    public void updateBy(String str) {
        try {
            if (str.startsWith("HTTP/1.")) {
                int end;
                int pos = str.indexOf(10);
                String sStatus = str.substring(0, pos);
                Matcher m = _P.matcher(sStatus);
                if (!m.find()) {
                    throw Lang.makeThrow("invalid HTTP status line: %s", sStatus);
                }
                this.statusCode = Integer.parseInt(m.group(1));
                this.statusText = Strings.trim(m.group(3));
                if (Strings.isBlank(this.statusText)) {
                    this.statusText = Http.getStatusText(this.statusCode);
                }
                ++pos;
                while ((end = str.indexOf(10, pos)) > pos) {
                    String line = str.substring(pos, end);
                    int p2 = line.indexOf(58);
                    String key = Strings.trim(line.substring(0, p2));
                    String val = Strings.trim(line.substring(p2 + 1));
                    this.header.put(key, val);
                    pos = end + 1;
                }
                if (++pos < str.length()) {
                    this.body = str.substring(pos).getBytes("UTF-8");
                }
            } else {
                if (this.statusCode <= 0) {
                    this.updateCode(200, null);
                }
                this.body = str.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public void update(Map<?, ?> map) {
        for (Map.Entry<?, ?> en : map.entrySet()) {
            String key = en.getKey().toString();
            Object val = en.getValue();
            if (null == val) continue;
            if ("statusCode".equals(key)) {
                this.statusCode = Castors.me().castTo(val, Integer.class);
                this.statusText = Http.getStatusText(this.statusCode);
                continue;
            }
            if ("statusText".equals(key)) {
                this.statusText = val.toString();
                continue;
            }
            if ("body".equals(key)) {
                try {
                    this.body = val.toString().getBytes("UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw Lang.wrapThrow(e);
                }
            }
            this.header.put(key.toUpperCase(), val.toString());
        }
    }

    public void updateCode(int statusCode, String statusText) {
        this.statusCode = statusCode;
        this.statusText = Strings.sNull(statusText, Http.getStatusText(statusCode));
    }

    public void updateBody(String body) {
        if (!Strings.isBlank(body)) {
            try {
                this.body = body.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw Lang.wrapThrow(e);
            }
        }
    }

    public void render(HttpServletResponse resp) {
        boolean flag;
        resp.setStatus(this.statusCode);
        boolean bl = flag = this.statusCode >= 400;
        if (null != this.header && this.header.size() > 0) {
            for (Map.Entry<String, String> en : this.header.entrySet()) {
                resp.setHeader(en.getKey(), en.getValue());
            }
            flag = false;
        }
        if (this.body != null) {
            ServletOutputStream out;
            resp.setContentLength(this.body.length);
            try {
                out = resp.getOutputStream();
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
            Streams.writeAndClose((OutputStream)out, this.body);
            flag = false;
        }
        if (flag) {
            try {
                resp.sendError(this.statusCode);
            }
            catch (IOException e) {
                log.debugf("sendError(%d) failed -- %s", this.statusCode, e.getMessage());
            }
        }
    }
}

