/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.Encoding;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback2;
import org.nutz.lang.util.NutMap;
import org.nutz.lang.util.Tag;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Xmls {
    public static String HEAD = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";

    public static DocumentBuilder xmls() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public static Document xml(InputStream ins) {
        return Xmls.xml(ins, null);
    }

    public static Document xml(InputStream ins, Charset charset) {
        try {
            if (charset == null) {
                charset = Encoding.CHARSET_UTF8;
            }
            Document document = Xmls.xmls().parse(new InputSource(new InputStreamReader(ins, charset)));
            return document;
        }
        catch (SAXException e) {
            throw Lang.wrapThrow(e);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        catch (ParserConfigurationException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ins);
        }
    }

    public static Document xml(File xmlFile) {
        return Xmls.xml(xmlFile, null);
    }

    public static Document xml(File xmlFile, Charset charset) {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(xmlFile);
            return Xmls.xml(ins, charset);
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String get(Element ele, String subTagName) {
        Element sub = Xmls.firstChild(ele, subTagName);
        if (null == sub) {
            return null;
        }
        return Xmls.getText(sub);
    }

    public static String getText(Element ele) {
        StringBuilder sb = new StringBuilder();
        Xmls.joinText(ele, sb);
        return Strings.trim(sb);
    }

    public static void joinText(Element ele, StringBuilder sb) {
        if (null == ele) {
            return;
        }
        NodeList nl = ele.getChildNodes();
        block5: for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            switch (nd.getNodeType()) {
                case 3: {
                    sb.append(nd.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append(nd.getNodeValue());
                    continue block5;
                }
                case 1: {
                    Xmls.joinText((Element)nd, sb);
                    continue block5;
                }
            }
        }
    }

    public static Element firstChild(Element ele) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, null, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        });
        return tag[0];
    }

    public static Element firstChild(Element ele, String regex) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        });
        return tag[0];
    }

    public static Element getEle(Element ele, String xpath) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xp = factory.newXPath();
        try {
            XPathExpression expression = xp.compile(xpath);
            return (Element)expression.evaluate(ele, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Element getChild(Element ele, int index) {
        return Xmls.getChild(ele, index, null);
    }

    public static Element getChild(Element ele, int index, String regex) {
        final int pos = index;
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, null, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                if (index >= pos) {
                    tag[0] = cld;
                    Lang.Break();
                }
            }
        });
        return tag[0];
    }

    public static Element lastChild(Element ele) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, null, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        }, -1);
        return tag[0];
    }

    public static Element lastChild(Element ele, String regex) {
        final Element[] tag = new Element[1];
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                tag[0] = cld;
                Lang.Break();
            }
        }, -1);
        return tag[0];
    }

    public static List<Element> children(Element ele) {
        return Xmls.children(ele, null);
    }

    public static List<Element> children(Element ele, String regex) {
        final ArrayList<Element> list = new ArrayList<Element>(ele.getChildNodes().getLength());
        Xmls.eachChildren(ele, regex, new Each<Element>(){

            @Override
            public void invoke(int index, Element cld, int length) {
                list.add(cld);
            }
        });
        return list;
    }

    public static void eachChildren(Element ele, Each<Element> callback) {
        Xmls.eachChildren(ele, null, callback);
    }

    public static void eachChildren(Element ele, String regex, Each<Element> callback) {
        Xmls.eachChildren(ele, regex, callback, 0);
    }

    public static boolean hasChild(Element ele, String regex) {
        NodeList nl = ele.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!(nd instanceof Element)) continue;
            if (null == regex) {
                return false;
            }
            if (!((Element)nd).getTagName().matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static void eachChildren(Element ele, String regex, final Each<Element> callback, int off) {
        if (null == ele || null == callback) {
            return;
        }
        final Pattern p = null == regex ? null : Pattern.compile(regex);
        NodeList nl = ele.getChildNodes();
        final int len = nl.getLength();
        Callback2<Integer, Node> eachInvoke = new Callback2<Integer, Node>(){

            @Override
            public void invoke(Integer index, Node nd) {
                if (nd instanceof Element) {
                    try {
                        Element tag = (Element)nd;
                        if (null == p || p.matcher(tag.getTagName()).find()) {
                            callback.invoke(index, tag, len);
                        }
                    }
                    catch (ExitLoop e) {
                        throw Lang.wrapThrow(e);
                    }
                    catch (ContinueLoop e) {
                    }
                    catch (LoopException e) {
                        throw Lang.wrapThrow(e);
                    }
                }
            }
        };
        try {
            if (off < 0) {
                for (int i = len + off; i >= 0; --i) {
                    eachInvoke.invoke(i, nl.item(i));
                }
            } else {
                for (int i = off; i < len; ++i) {
                    eachInvoke.invoke(i, nl.item(i));
                }
            }
        }
        catch (ExitLoop i) {
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ExitLoop) {
                return;
            }
            throw e;
        }
    }

    public static Map<String, String> getAttrs(Element ele) {
        NamedNodeMap nodeMap = ele.getAttributes();
        HashMap<String, String> attrs = new HashMap<String, String>(nodeMap.getLength());
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            attrs.put(nodeMap.item(i).getNodeName(), nodeMap.item(i).getNodeValue());
        }
        return attrs;
    }

    public static String getAttr(Element ele, String attrName) {
        Node node = ele.getAttributes().getNamedItem(attrName);
        return node != null ? node.getNodeValue() : null;
    }

    public static NutMap asMap(Element ele) {
        return Xmls.asMap(ele, false);
    }

    public static NutMap asMap(Element ele, boolean lowFirst) {
        return Xmls.asMap(ele, lowFirst, false);
    }

    public static NutMap asMap(Element ele, boolean lowFirst, boolean dupAsList) {
        return Xmls.asMap(ele, lowFirst, dupAsList, null);
    }

    public static NutMap asMap(Element ele, final boolean lowerFirst, final boolean dupAsList, final List<String> alwaysAsList) {
        final NutMap map = new NutMap();
        Xmls.eachChildren(ele, new Each<Element>(){

            @Override
            public void invoke(int index, Element _ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                NutMap tmp;
                String key = _ele.getNodeName();
                if (lowerFirst) {
                    key = Strings.lowerFirst(key);
                }
                if (!(tmp = Xmls.asMap(_ele, lowerFirst, dupAsList, alwaysAsList)).isEmpty()) {
                    if (alwaysAsList != null && alwaysAsList.contains(key)) {
                        map.addv2(key, tmp);
                    } else if (dupAsList) {
                        map.addv(key, tmp);
                    } else {
                        map.setv(key, tmp);
                    }
                    return;
                }
                String val = Xmls.getText(_ele);
                if (!Strings.isBlank(val)) {
                    if (alwaysAsList != null && alwaysAsList.contains(key)) {
                        map.addv2(key, map);
                    } else if (dupAsList) {
                        map.addv(key, val);
                    } else {
                        map.setv(key, val);
                    }
                }
            }
        });
        return map;
    }

    public static NutMap xmlToMap(String xml) {
        return Xmls.asMap(Xmls.xml(Lang.ins(xml)).getDocumentElement());
    }

    public static NutMap xmlToMap(InputStream ins) {
        return Xmls.asMap(Xmls.xml(ins).getDocumentElement());
    }

    public static NutMap xmlToMap(InputStream ins, boolean lowerFirst, boolean dupAsList, List<String> alwaysAsList) {
        return Xmls.asMap(Xmls.xml(ins).getDocumentElement(), lowerFirst, dupAsList, alwaysAsList);
    }

    public static String mapToXml(Map<String, Object> map) {
        return Xmls.mapToXml("xml", map);
    }

    public static String mapToXml(String root, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        Xmls.map2Tag(root, map).toXml(sb, 0);
        return sb.toString();
    }

    protected static Tag map2Tag(String rootName, Map<String, Object> map) {
        Tag rootTag = Tag.tag(rootName, new String[0]);
        for (Map.Entry<String, Object> en : map.entrySet()) {
            String key = en.getKey();
            Object val = en.getValue();
            List<Tag> children = Xmls.obj2tag(key, val);
            for (Tag child : children) {
                rootTag.add(child);
            }
        }
        return rootTag;
    }

    public static List<Tag> obj2tag(String nodeName, Object val) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (null == val) {
            return tags;
        }
        if (val instanceof Map) {
            tags.add(Xmls.map2Tag(nodeName, (Map)val));
        } else if (val instanceof Collection) {
            for (Object object : (Collection)val) {
                for (Tag tag : Xmls.obj2tag(nodeName, object)) {
                    tags.add(tag);
                }
            }
        } else {
            tags.add(Tag.tag(nodeName, new String[0]).setText(val.toString()));
        }
        return tags;
    }

    public static List<Element> getEles(Element ele, String xpath) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xp = factory.newXPath();
        try {
            XPathExpression expression = xp.compile(xpath);
            NodeList nodes = (NodeList)expression.evaluate(ele, XPathConstants.NODESET);
            ArrayList<Element> list = new ArrayList<Element>();
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                list.add((Element)node);
            }
            return list;
        }
        catch (XPathExpressionException e) {
            throw Lang.wrapThrow(e);
        }
    }
}

