/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class Code {
    private static CodeAnalysisConf CODE_INFO_JAVA = new CodeAnalysisConf();

    private Code() {
    }

    public static CodeAnalysisResult countingCode(File file, CodeAnalysisConf conf) {
        BufferedReader br;
        if (!Files.isFile(file)) {
            throw new RuntimeException("file is not a File, can't analysis it.");
        }
        if (null == conf) {
            conf = CODE_INFO_JAVA;
        }
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw Lang.wrapThrow(e);
        }
        boolean comment = false;
        long whiteLines = 0L;
        long commentLines = 0L;
        long normalLines = 0L;
        long importLines = 0L;
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith(conf.multiLineCommentStart) && !line.endsWith(conf.multiLineCommentEnd)) {
                    ++commentLines;
                    comment = true;
                    continue;
                }
                if (comment) {
                    ++commentLines;
                    if (!line.endsWith(conf.multiLineCommentEnd)) continue;
                    comment = false;
                    continue;
                }
                if (line.matches(conf.emptyLinePattern)) {
                    ++whiteLines;
                    continue;
                }
                if (line.startsWith(conf.singleLineCommentStart) || line.startsWith(conf.multiLineCommentStart) && line.endsWith(conf.multiLineCommentEnd)) {
                    ++commentLines;
                    continue;
                }
                if (line.startsWith(conf.pakStart) || line.startsWith(conf.impStart)) {
                    ++importLines;
                    continue;
                }
                ++normalLines;
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new CodeAnalysisResult(normalLines, commentLines, whiteLines, importLines);
    }

    public static CodeStatisticsResult countingCode(File src, String suffix, boolean countSubFolder, CodeAnalysisConf conf) {
        if (!Files.isDirectory(src)) {
            throw new RuntimeException("src is not a File, can't analysis it.");
        }
        if (null == conf) {
            conf = CODE_INFO_JAVA;
        }
        CodeStatisticsResult statisticsResult = new CodeStatisticsResult(src);
        boolean useParticularType = !Strings.isBlank(suffix);
        Code.folderAnalysis(src, useParticularType, suffix, countSubFolder, conf, statisticsResult);
        return statisticsResult;
    }

    private static void folderAnalysis(File src, boolean useParticularType, String suffix, boolean countSubFolder, CodeAnalysisConf conf, CodeStatisticsResult statisticsResult) {
        for (File f : src.listFiles()) {
            if (countSubFolder && Files.isDirectory(f)) {
                Code.folderAnalysis(f, useParticularType, suffix, countSubFolder, conf, statisticsResult);
                continue;
            }
            if (useParticularType && !suffix.equalsIgnoreCase(f.getName().substring(f.getName().lastIndexOf(46) + 1))) continue;
            statisticsResult.addCodeAnalysisResult(Code.countingCode(f, conf));
        }
    }

    static {
        Code.CODE_INFO_JAVA.pakStart = "package ";
        Code.CODE_INFO_JAVA.impStart = "import ";
        Code.CODE_INFO_JAVA.singleLineCommentStart = "//";
        Code.CODE_INFO_JAVA.multiLineCommentStart = "/*";
        Code.CODE_INFO_JAVA.multiLineCommentEnd = "*/";
        Code.CODE_INFO_JAVA.emptyLinePattern = "^[\\s&&[^\\n]]*$";
    }

    public static class CodeAnalysisConf {
        public String pakStart;
        public String impStart;
        public String singleLineCommentStart;
        public String multiLineCommentStart;
        public String multiLineCommentEnd;
        public String emptyLinePattern;
    }

    public static class CodeStatisticsResult
    extends CodeAnalysisResult {
        private File src;
        private int fileCount;

        public CodeStatisticsResult(File src) {
            this.src = src;
        }

        public void addCodeAnalysisResult(CodeAnalysisResult analysisResult) {
            this.normalLines += analysisResult.getNormalLines();
            this.commentLines += analysisResult.getCommentLines();
            this.whiteLines += analysisResult.getWhiteLines();
            this.importLines += analysisResult.getImportLines();
            ++this.fileCount;
        }

        public File getSrc() {
            return this.src;
        }

        public int getFileCount() {
            return this.fileCount;
        }
    }

    public static class CodeAnalysisResult {
        protected long normalLines;
        protected long commentLines;
        protected long whiteLines;
        protected long importLines;

        public CodeAnalysisResult() {
        }

        public CodeAnalysisResult(long normalLines, long commentLines, long whiteLines, long importLines) {
            this.normalLines = normalLines;
            this.commentLines = commentLines;
            this.whiteLines = whiteLines;
            this.importLines = importLines;
        }

        public long getNormalLines() {
            return this.normalLines;
        }

        public long getCommentLines() {
            return this.commentLines;
        }

        public long getWhiteLines() {
            return this.whiteLines;
        }

        public long getImportLines() {
            return this.importLines;
        }

        public long getTotalLines() {
            return this.normalLines + this.commentLines + this.whiteLines + this.importLines;
        }

        public String toString() {
            return String.format("All      : %d lines\ncomments : %d lines\nblank    : %d lines\nimports  : %d lines\n", this.normalLines, this.commentLines, this.whiteLines, this.importLines);
        }
    }
}

