/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.dao.Chain;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.impl.sql.pojo.ConditionPItem;
import org.nutz.dao.impl.sql.pojo.EntityTableNamePItem;
import org.nutz.dao.impl.sql.pojo.EntityViewNamePItem;
import org.nutz.dao.impl.sql.pojo.InsertFieldsPItem;
import org.nutz.dao.impl.sql.pojo.InsertValuesPItem;
import org.nutz.dao.impl.sql.pojo.PkConditionPItem;
import org.nutz.dao.impl.sql.pojo.QueryEntityFieldsPItem;
import org.nutz.dao.impl.sql.pojo.SingleColumnCondtionPItem;
import org.nutz.dao.impl.sql.pojo.SqlTypePItem;
import org.nutz.dao.impl.sql.pojo.StaticPItem;
import org.nutz.dao.impl.sql.pojo.UpdateFieldsByChainPItem;
import org.nutz.dao.impl.sql.pojo.UpdateFieldsPItem;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Criteria;
import org.nutz.dao.sql.PItem;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.PojoCallback;
import org.nutz.dao.sql.SqlType;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Pojos {
    public static final Log log = Logs.get();
    private static final Pattern ptn = Pattern.compile("^(WHERE|ORDER BY)(.+)", 2);

    public static Pojo createRun(PojoCallback callback) {
        return new NutPojo().setSqlType(SqlType.RUN).setAfter(callback);
    }

    public static List<MappingField> getFieldsForInsert(Entity<?> en, FieldMatcher fm) {
        ArrayList<MappingField> re = new ArrayList<MappingField>(en.getMappingFields().size());
        for (MappingField mf : en.getMappingFields()) {
            if (null != fm && !fm.match(mf.getName())) continue;
            if (!mf.isAutoIncreasement() && !mf.isReadonly() && mf.isInsert()) {
                re.add(mf);
                continue;
            }
            if (fm == null || !mf.isId() || fm.isIgnoreId()) continue;
            re.add(mf);
        }
        if (re.isEmpty() && log.isDebugEnabled()) {
            log.debug("none field for insert!");
        }
        return re;
    }

    public static List<MappingField> getFieldsForUpdate(Entity<?> en, FieldMatcher fm, Object refer) {
        ArrayList<MappingField> re = new ArrayList<MappingField>(en.getMappingFields().size());
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isPk() && (en.getPkType() == PkType.ID && mf.isId() || en.getPkType() == PkType.NAME && mf.isName() || en.getPkType() == PkType.COMPOSITE && mf.isCompositePk()) || mf.isReadonly() || mf.isAutoIncreasement() || !mf.isUpdate() || null != fm && null != refer && fm.isIgnoreNull() && null == mf.getValue(Lang.first(refer)) || null != fm && !fm.match(mf.getName())) continue;
            re.add(mf);
        }
        if (re.isEmpty() && log.isDebugEnabled()) {
            log.debug("none field for update!");
        }
        return re;
    }

    public static String formatCondition(Entity<?> en, Condition cnd) {
        return Pojos.formatCondition(en, cnd, true);
    }

    public static String formatCondition(Entity<?> en, Condition cnd, boolean top) {
        if (null != cnd) {
            String str = Strings.trim(cnd.toSql(en));
            if (top && !ptn.matcher(str).find()) {
                return "WHERE " + str;
            }
            return str;
        }
        return "";
    }

    public static Pojo pojo(JdbcExpert expert, Entity<?> en, SqlType type) {
        Pojo pojo = expert.createPojo(type);
        pojo.getContext().setFieldMatcher(FieldFilter.get(en.getType()));
        return pojo;
    }

    public static class Items {
        public static PItem sqlType() {
            return new SqlTypePItem();
        }

        public static PItem entityTableName() {
            return new EntityTableNamePItem();
        }

        public static PItem entityViewName() {
            return new EntityViewNamePItem();
        }

        public static PItem wrap(String str) {
            return new StaticPItem(str);
        }

        public static PItem wrapf(String fmt, Object ... args) {
            return new StaticPItem(String.format(fmt, args));
        }

        public static PItem insertFields() {
            return new InsertFieldsPItem();
        }

        public static PItem insertValues() {
            return new InsertValuesPItem();
        }

        public static PItem updateFields(Object refer) {
            return new UpdateFieldsPItem(refer);
        }

        public static PItem updateFieldsBy(Chain chain) {
            return new UpdateFieldsByChainPItem(chain);
        }

        public static PItem queryEntityFields() {
            return new QueryEntityFieldsPItem();
        }

        public static PItem cndId(Entity<?> en, Number id) {
            MappingField mappingField = en.getIdField();
            if (mappingField == null) {
                throw new DaoException("expect @Id but NOT found. " + en.getType().getName());
            }
            return Items.cndColumn(mappingField, id);
        }

        public static PItem cndName(Entity<?> en, String name) {
            MappingField mappingField = en.getNameField();
            if (mappingField == null) {
                throw new DaoException("expect @Name but NOT found. " + en.getType().getName());
            }
            return Items.cndColumn(mappingField, name);
        }

        public static PItem cndColumn(MappingField mappingField, Object def) {
            SingleColumnCondtionPItem re = new SingleColumnCondtionPItem(mappingField, def);
            re.setCasesensitive(mappingField.isCasesensitive());
            return re;
        }

        public static PItem cndColumn(String colName, MappingField mappingField, Object def) {
            return new SingleColumnCondtionPItem(colName, mappingField.getTypeClass(), mappingField.getAdaptor(), def);
        }

        public static PItem cndPk(Entity<?> en, Object[] pks) {
            ValueAdaptor[] vas = new ValueAdaptor[en.getCompositePKFields().size()];
            int i = 0;
            for (MappingField mf : en.getCompositePKFields()) {
                vas[i++] = mf.getAdaptor();
            }
            return new PkConditionPItem(vas, pks);
        }

        public static PItem cndAuto(Entity<?> en, Object obj) {
            obj = Lang.first(obj);
            switch (en.getPkType()) {
                case ID: {
                    String name;
                    Number id;
                    Number number = id = null != obj ? (Number)((Number)en.getIdField().getValue(obj)) : (Number)null;
                    if (id == null && en.getNameField() != null && !Strings.isBlank(name = (String)en.getNameField().getValue(obj))) {
                        return Items.cndName(en, name);
                    }
                    return Items.cndId(en, id);
                }
                case NAME: {
                    String name = null != obj ? Strings.sNull(en.getNameField().getValue(obj), null) : null;
                    return Items.cndName(en, name);
                }
                case COMPOSITE: {
                    Object[] pks = null;
                    if (null != obj) {
                        pks = new Object[en.getCompositePKFields().size()];
                        int i = 0;
                        for (EntityField entityField : en.getCompositePKFields()) {
                            pks[i++] = entityField.getValue(obj);
                        }
                    }
                    return Items.cndPk(en, pks);
                }
            }
            if (Map.class.isAssignableFrom(en.getType())) {
                return null;
            }
            throw Lang.makeThrow("Don't know how to make fetch key %s:'%s', need any of @Id/@Name/@Pk", en.getType().getName(), obj);
        }

        public static PItem[] cnd(Condition cnd) {
            LinkedList<PItem> list = new LinkedList<PItem>();
            if (null != cnd) {
                if (cnd instanceof Criteria) {
                    list.add((Criteria)cnd);
                } else {
                    list.add(new ConditionPItem(cnd));
                }
            }
            return list.toArray(new PItem[list.size()]);
        }

        public static Pager pager(Condition cnd) {
            if (null == cnd) {
                return null;
            }
            if (cnd instanceof Criteria) {
                return ((Criteria)cnd).getPager();
            }
            return null;
        }
    }
}

