/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.SqlManager;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.LinkVisitor;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.DaoSupport;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.EntityOperator;
import org.nutz.dao.impl.link.DoClearLinkVisitor;
import org.nutz.dao.impl.link.DoClearRelationByHostFieldLinkVisitor;
import org.nutz.dao.impl.link.DoClearRelationByLinkedFieldLinkVisitor;
import org.nutz.dao.impl.link.DoDeleteLinkVisitor;
import org.nutz.dao.impl.link.DoInsertLinkVisitor;
import org.nutz.dao.impl.link.DoInsertRelationLinkVisitor;
import org.nutz.dao.impl.link.DoUpdateLinkVisitor;
import org.nutz.dao.impl.link.DoUpdateRelationLinkVisitor;
import org.nutz.dao.impl.sql.pojo.ConditionPItem;
import org.nutz.dao.impl.sql.pojo.PojoEachEntityCallback;
import org.nutz.dao.impl.sql.pojo.PojoEachRecordCallback;
import org.nutz.dao.impl.sql.pojo.PojoFetchEntityByJoinCallback;
import org.nutz.dao.impl.sql.pojo.PojoFetchEntityCallback;
import org.nutz.dao.impl.sql.pojo.PojoFetchIntCallback;
import org.nutz.dao.impl.sql.pojo.PojoFetchObjectCallback;
import org.nutz.dao.impl.sql.pojo.PojoFetchRecordCallback;
import org.nutz.dao.impl.sql.pojo.PojoQueryEntityByJoinCallback;
import org.nutz.dao.impl.sql.pojo.PojoQueryEntityCallback;
import org.nutz.dao.impl.sql.pojo.PojoQueryRecordCallback;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Criteria;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.GroupBy;
import org.nutz.dao.sql.PItem;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.PojoCallback;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Daos;
import org.nutz.dao.util.Pojos;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.trans.Atom;
import org.nutz.trans.Molecule;

public class NutDao
extends DaoSupport
implements Dao {
    private PojoCallback _pojo_queryEntity = new PojoQueryEntityCallback();
    private PojoCallback _pojo_fetchEntity = new PojoFetchEntityCallback();
    private PojoCallback _pojo_eachEntity = new PojoEachEntityCallback();
    private PojoCallback _pojo_queryRecord;
    private PojoCallback _pojo_fetchRecord;
    private PojoCallback _pojo_eachRecord;
    private PojoCallback _pojo_fetchInt = new PojoFetchIntCallback();
    private PojoCallback _pojo_fetchObject = new PojoFetchObjectCallback();

    public NutDao() {
        this._pojo_queryRecord = new PojoQueryRecordCallback();
        this._pojo_fetchRecord = new PojoFetchRecordCallback();
        this._pojo_eachRecord = new PojoEachRecordCallback();
    }

    public NutDao(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public NutDao(DataSource dataSource, SqlManager sqlManager) {
        this(dataSource);
        this.setSqlManager(sqlManager);
    }

    public NutDao(DataSource dataSource, EntityMaker maker) {
        this(dataSource);
        this.holder.maker = maker;
        maker.init(dataSource, this.expert, this.holder);
    }

    @Override
    public <T> T getObject(Class<T> classOfT, ResultSet rs, FieldMatcher fm) {
        return this.getObject(classOfT, rs, fm, null);
    }

    @Override
    public <T> T getObject(Class<T> classOfT, ResultSet rs, FieldMatcher fm, String prefix) {
        return this.holder.getEntity(classOfT).getObject(rs, fm, prefix);
    }

    @Override
    public <T> T insert(T obj) {
        Object first = Lang.first(obj);
        final EntityOperator opt = this._optBy(first);
        if (null == opt) {
            return null;
        }
        int size = Lang.eleSize(obj);
        opt.addInsert(opt.entity, first);
        if (size > 1) {
            if (opt.getPojoListSize() == 1) {
                return this.fastInsert(obj);
            }
            Lang.each(obj, false, new Each<Object>(){

                @Override
                public void invoke(int i, Object ele, int length) throws ExitLoop, LoopException {
                    if (i != 0) {
                        opt.addInsert(opt.entity, ele);
                    }
                }
            });
        }
        opt.exec();
        return obj;
    }

    @Override
    public <T> T insert(final T obj, FieldFilter filter) {
        if (filter == null) {
            return this.insert(obj);
        }
        filter.run(new Atom(){

            @Override
            public void run() {
                NutDao.this.insert(obj);
            }
        });
        return obj;
    }

    @Override
    public void insert(String tableName, Chain chain) {
        if (chain.isSpecial()) {
            Daos.insertBySpecialChain(this, null, tableName, chain);
            return;
        }
        EntityOperator opt = this._optBy(chain.toEntityMap(tableName));
        if (null == opt) {
            return;
        }
        opt.addInsert();
        opt.exec();
    }

    @Override
    public void insert(Class<?> classOfT, Chain chain) {
        if (chain.isSpecial()) {
            Daos.insertBySpecialChain(this, this.getEntity(classOfT), null, chain);
            return;
        }
        EntityOperator opt = this._opt(classOfT);
        opt.myObj = chain;
        opt.addInsertSelfOnly();
        opt.exec();
    }

    @Override
    public <T> T fastInsert(T obj) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return null;
        }
        opt.addInsertSelfOnly();
        opt.exec();
        return obj;
    }

    @Override
    public <T> T insertWith(T obj, String regex) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return null;
        }
        final LinkVisitor one = this.doInsert(opt);
        final boolean[] flag = new boolean[1];
        opt.entity.visitOne(obj, regex, new LinkVisitor(){

            @Override
            public void visit(Object obj, LinkField lnk) {
                if (lnk.getHostField().isId()) {
                    flag[0] = true;
                    return;
                }
                one.visit(obj, lnk);
            }
        });
        opt.addInsert();
        opt.entity.visitMany(obj, regex, this.doInsert(opt));
        opt.entity.visitManyMany(obj, regex, this.doInsert(opt));
        opt.entity.visitManyMany(obj, regex, this.doInsertRelation(opt));
        opt.exec();
        if (flag[0]) {
            opt = this._optBy(obj);
            final LinkVisitor _one = this.doInsert(opt);
            opt.entity.visitOne(obj, regex, new LinkVisitor(){

                @Override
                public void visit(Object obj, LinkField lnk) {
                    if (!lnk.getHostField().isId()) {
                        return;
                    }
                    _one.visit(obj, lnk);
                }
            });
            opt.exec();
        }
        return obj;
    }

    @Override
    public <T> T insertLinks(T obj, String regex) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return null;
        }
        opt.entity.visitOne(obj, regex, this.doInsert(opt));
        opt.entity.visitMany(obj, regex, this.doInsert(opt));
        opt.entity.visitManyMany(obj, regex, this.doInsert(opt));
        opt.entity.visitManyMany(obj, regex, this.doInsertRelation(opt));
        opt.exec();
        return obj;
    }

    @Override
    public <T> T insertRelation(T obj, String regex) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return null;
        }
        opt.entity.visitManyMany(obj, regex, this.doInsertRelation(opt));
        opt.exec();
        return obj;
    }

    @Override
    public int update(Object obj) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return 0;
        }
        opt.addUpdate();
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int update(Object obj, String actived) {
        Object first = Lang.first(obj);
        if (null == first) {
            return 0;
        }
        if (Strings.isBlank(actived)) {
            return this.update(obj);
        }
        return this.update(obj, FieldFilter.create(first.getClass(), actived));
    }

    @Override
    public int update(Object obj, String actived, String locked, boolean ignoreNull) {
        Object first = Lang.first(obj);
        if (null == first) {
            return 0;
        }
        return this.update(obj, FieldFilter.create(first.getClass(), actived, locked, ignoreNull));
    }

    @Override
    public int update(final Object obj, FieldFilter fieldFilter) {
        if (fieldFilter == null) {
            return this.update(obj);
        }
        return fieldFilter.run(new Molecule<Integer>(){

            @Override
            public void run() {
                this.setObj(NutDao.this.update(obj));
            }
        });
    }

    @Override
    public int update(final Object obj, FieldFilter fieldFilter, final Condition cnd) {
        if (fieldFilter == null) {
            return this.update(obj, cnd);
        }
        return fieldFilter.run(new Molecule<Integer>(){

            @Override
            public void run() {
                this.setObj(NutDao.this.update(obj, cnd));
            }
        });
    }

    @Override
    public int update(Object obj, Condition cnd) {
        if (cnd == null) {
            return this.update(obj);
        }
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return 0;
        }
        opt.addUpdateByPkAndCnd(cnd);
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int updateIgnoreNull(Object obj) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return 0;
        }
        opt.addUpdateForIgnoreNull(opt.entity, obj, FieldFilter.get(opt.entity.getType()));
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int update(String tableName, Chain chain, Condition cnd) {
        EntityOperator opt = this._optBy(chain.toEntityMap(tableName));
        if (null == opt) {
            return 0;
        }
        opt.addUpdate(chain, cnd);
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int update(Class<?> classOfT, Chain chain, Condition cnd) {
        EntityOperator opt = this._opt(classOfT);
        opt.addUpdate(chain, cnd);
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public <T> T updateWith(T obj, final String regex) {
        if (null == obj) {
            return null;
        }
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                EntityOperator opt = NutDao.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitOne(ele, regex, NutDao.this.doUpdate(opt));
                opt.addUpdate();
                opt.entity.visitMany(ele, regex, NutDao.this.doUpdate(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doUpdate(opt));
                opt.exec();
            }
        });
        return obj;
    }

    @Override
    public <T> T updateLinks(T obj, final String regex) {
        if (null == obj) {
            return null;
        }
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                EntityOperator opt = NutDao.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitOne(ele, regex, NutDao.this.doUpdate(opt));
                opt.entity.visitMany(ele, regex, NutDao.this.doUpdate(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doUpdate(opt));
                opt.exec();
            }
        });
        return obj;
    }

    @Override
    public int updateRelation(Class<?> classOfT, String regex, Chain chain, Condition cnd) {
        if (chain.isSpecial()) {
            throw Lang.noImplement();
        }
        EntityOperator opt = this._opt(classOfT);
        opt.entity.visitManyMany(null, regex, this.doUpdateRelation(opt, chain, cnd));
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int delete(Class<?> classOfT, long id) {
        Entity<?> en = this.holder.getEntity(classOfT);
        Pojo pojo = this.pojoMaker.makeDelete(en).append(Pojos.Items.cndId(en, id));
        pojo.addParamsBy(id);
        this._exec(pojo);
        return pojo.getUpdateCount();
    }

    @Override
    public int delete(Class<?> classOfT, String name) {
        Entity<?> en = this.holder.getEntity(classOfT);
        Pojo pojo = this.pojoMaker.makeDelete(en).append(Pojos.Items.cndName(en, name)).addParamsBy(name);
        this._exec(pojo);
        return pojo.getUpdateCount();
    }

    @Override
    public <T> int deletex(Class<T> classOfT, Object ... pks) {
        Entity<T> en = this.holder.getEntity(classOfT);
        Pojo pojo = this.pojoMaker.makeDelete(en).append(Pojos.Items.cndPk(en, pks));
        this._exec(pojo);
        return pojo.getUpdateCount();
    }

    @Override
    public int delete(Object obj) {
        EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return 0;
        }
        opt.addDeleteSelfOnly();
        opt.exec();
        return opt.getUpdateCount();
    }

    @Override
    public int deleteWith(Object obj, final String regex) {
        if (null == obj) {
            return 0;
        }
        final int[] re = new int[1];
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                EntityOperator opt = NutDao.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitMany(ele, regex, NutDao.this.doDelete(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doClearRelationByLinkedField(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doDelete(opt));
                opt.addDeleteSelfOnly();
                opt.entity.visitOne(ele, regex, NutDao.this.doDelete(opt));
                re[0] = re[0] + opt.exec().getUpdateCount();
            }
        });
        return re[0];
    }

    @Override
    public int deleteLinks(Object obj, final String regex) {
        if (null == obj) {
            return 0;
        }
        final int[] re = new int[1];
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                EntityOperator opt = NutDao.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitMany(ele, regex, NutDao.this.doDelete(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doClearRelationByLinkedField(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doDelete(opt));
                opt.entity.visitOne(ele, regex, NutDao.this.doDelete(opt));
                re[0] = re[0] + opt.exec().getUpdateCount();
            }
        });
        return re[0];
    }

    @Override
    public <T> List<T> query(Class<T> classOfT, Condition cnd, Pager pager) {
        Pojo pojo = this.pojoMaker.makeQuery(this.holder.getEntity(classOfT)).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setPager(pager).setAfter(this._pojo_queryEntity);
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        return pojo.getList(classOfT);
    }

    @Override
    public <T> List<T> query(Class<T> classOfT, Condition cnd) {
        return this.query(classOfT, cnd, Pojos.Items.pager(cnd));
    }

    @Override
    public <T> int each(Class<T> classOfT, Condition cnd, Pager pager, Each<T> callback) {
        Pojo pojo = this.pojoMaker.makeQuery(this.holder.getEntity(classOfT)).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setPager(pager).setAfter(this._pojo_queryEntity);
        this.expert.formatQuery(pojo);
        pojo.setAfter(this._pojo_eachEntity);
        pojo.getContext().attr(Each.class.getName(), callback);
        pojo.getContext().attr("dao-cache-skip", (Object)"true");
        this._exec(pojo);
        return pojo.getInt();
    }

    @Override
    public <T> int each(Class<T> classOfT, Condition cnd, Each<T> callback) {
        return this.each(classOfT, cnd, Pojos.Items.pager(cnd), callback);
    }

    @Override
    public List<Record> query(String tableName, Condition cnd, Pager pager) {
        return this.query(tableName, cnd, pager, "*");
    }

    @Override
    public List<Record> query(String tableName, Condition cnd, Pager pager, String fields) {
        Pojo pojo = this.pojoMaker.makeQuery(tableName, fields).addParamsBy(fields).setPager(pager).append(Pojos.Items.cnd(cnd));
        this.expert.formatQuery(pojo);
        pojo.setAfter(this._pojo_queryRecord);
        this._exec(pojo);
        return pojo.getList(Record.class);
    }

    @Override
    public List<Record> query(String tableName, Condition cnd) {
        return this.query(tableName, cnd, Pojos.Items.pager(cnd));
    }

    @Override
    public int each(String tableName, Condition cnd, Pager pager, Each<Record> callback, String fields) {
        Pojo pojo = this.pojoMaker.makeQuery(tableName, fields).addParamsBy(fields).setPager(pager).append(Pojos.Items.cnd(cnd));
        this.expert.formatQuery(pojo);
        pojo.setAfter(this._pojo_eachRecord);
        pojo.getContext().attr(Each.class.getName(), callback);
        pojo.getContext().attr("dao-cache-skip", (Object)"true");
        this._exec(pojo);
        return pojo.getInt();
    }

    @Override
    public int each(String tableName, Condition cnd, Pager pager, Each<Record> callback) {
        return this.each(tableName, cnd, pager, callback, "*");
    }

    @Override
    public int each(String tableName, Condition cnd, Each<Record> callback) {
        return this.each(tableName, cnd, Pojos.Items.pager(cnd), callback);
    }

    @Override
    public <T> T fetch(Class<T> classOfT, long id) {
        Entity<T> en = this.holder.getEntity(classOfT);
        if (en.getIdField() == null) {
            throw new DaoException("Need @Id for " + classOfT);
        }
        Pojo pojo = this.pojoMaker.makeQuery(en).append(Pojos.Items.cndId(en, id)).addParamsBy(id).setAfter(this._pojo_fetchEntity);
        this._exec(pojo);
        return pojo.getObject(classOfT);
    }

    @Override
    public <T> T fetch(Class<T> classOfT, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name MUST NOT NULL!");
        }
        Entity<T> en = this.holder.getEntity(classOfT);
        if (en.getNameField() == null) {
            throw new DaoException("Need @Name for " + classOfT);
        }
        Pojo pojo = this.pojoMaker.makeQuery(en).append(Pojos.Items.cndName(en, name)).addParamsBy(name).setAfter(this._pojo_fetchEntity);
        this._exec(pojo);
        return pojo.getObject(classOfT);
    }

    @Override
    public <T> T fetchx(Class<T> classOfT, Object ... pks) {
        Entity<T> en = this.holder.getEntity(classOfT);
        Pojo pojo = this.pojoMaker.makeQuery(en).append(Pojos.Items.cndPk(en, pks)).setAfter(this._pojo_fetchEntity);
        this._exec(pojo);
        return pojo.getObject(classOfT);
    }

    @Override
    public <T> T fetch(Class<T> classOfT, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeQuery(this.holder.getEntity(classOfT)).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setPager(this.createPager(1, 1)).setAfter(this._pojo_fetchEntity);
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        return pojo.getObject(classOfT);
    }

    @Override
    public Record fetch(String tableName, Condition cnd) {
        return this.fetch(tableName, cnd, "*");
    }

    @Override
    public Record fetch(String tableName, Condition cnd, String fields) {
        Pojo pojo = this.pojoMaker.makeQuery(tableName, fields).append(Pojos.Items.cnd(cnd)).addParamsBy(fields).setPager(this.createPager(1, 1)).setAfter(this._pojo_fetchRecord);
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        return pojo.getObject(Record.class);
    }

    @Override
    public <T> T fetch(T obj) {
        Entity<?> en = this.holder.getEntityBy(obj);
        Pojo pojo = this.pojoMaker.makeQuery(en).append(Pojos.Items.cndAuto(en, obj)).setAfter(this._pojo_fetchEntity).setPager(this.createPager(1, 1));
        this._exec(pojo);
        return (T)pojo.getResult();
    }

    @Override
    public <T> T fetch(Class<T> classOfT) {
        List<T> list = this.query(classOfT, null, this.createPager(1, 1));
        if (null != list && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> T fetchLinks(T obj, String regex) {
        return this.fetchLinks(obj, regex, null);
    }

    @Override
    public <T> T fetchLinks(T obj, final String regex, final Condition cnd) {
        if (null == obj) {
            return null;
        }
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                NutDao.this._fetchLinks(ele, regex, true, true, true, cnd);
            }
        });
        return obj;
    }

    @Override
    public int clear(Class<?> classOfT, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeDelete(this.holder.getEntity(classOfT)).append(Pojos.Items.cnd(cnd));
        this._exec(pojo);
        return pojo.getUpdateCount();
    }

    @Override
    public int clear(String tableName, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeDelete(tableName).append(Pojos.Items.cnd(cnd));
        this._exec(pojo);
        return pojo.getUpdateCount();
    }

    @Override
    public int clear(Class<?> classOfT) {
        return this.clear(classOfT, null);
    }

    @Override
    public int clear(String tableName) {
        return this.clear(tableName, null);
    }

    @Override
    public <T> T clearLinks(T obj, final String regex) {
        if (null == obj) {
            return null;
        }
        Lang.each(obj, false, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                EntityOperator opt = NutDao.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitMany(ele, regex, NutDao.this.doClear(opt));
                opt.entity.visitManyMany(ele, regex, NutDao.this.doClearRelationByHostField(opt));
                opt.entity.visitOne(ele, regex, NutDao.this.doClear(opt));
                opt.exec();
            }
        });
        return obj;
    }

    @Override
    public <T> Entity<T> getEntity(Class<T> classOfT) {
        return this.holder.getEntity(classOfT);
    }

    @Override
    public int count(Class<?> classOfT, Condition cnd) {
        Entity<?> en = this.holder.getEntity(classOfT);
        return this._count(en, en.getViewName(), cnd);
    }

    @Override
    public int count(Class<?> classOfT) {
        Entity<?> en = this.holder.getEntity(classOfT);
        return this._count(en, en.getViewName(), null);
    }

    @Override
    public int count(String tableName) {
        return this.count(tableName, null);
    }

    @Override
    public int count(String tableName, Condition cnd) {
        return this._count(null, tableName, cnd);
    }

    private int _count(Entity<?> en, String tableName, Condition cnd) {
        if (null != cnd) {
            Pojo pojo = this.pojoMaker.makeFunc(tableName, "COUNT", "*");
            pojo.setEntity(en);
            if (cnd instanceof Criteria) {
                pojo.append(((Criteria)cnd).where());
                GroupBy gb = ((Criteria)cnd).getGroupBy();
                pojo.append(gb);
            } else {
                String str = Pojos.formatCondition(en, cnd);
                if (!Strings.isBlank(str)) {
                    String[] ss = str.toUpperCase().split("ORDER BY");
                    pojo.append(Pojos.Items.wrap(str.substring(0, ss[0].length())));
                }
            }
            pojo.setAfter(this._pojo_fetchInt);
            this._exec(pojo);
            return pojo.getInt();
        }
        return this.func(tableName, "COUNT", "*");
    }

    @Override
    public int getMaxId(Class<?> classOfT) {
        Entity<?> en = this.holder.getEntity(classOfT);
        return this.func(en.getViewName(), "MAX", en.getIdField().getColumnNameInSql());
    }

    @Override
    public int func(Class<?> classOfT, String funcName, String fieldName) {
        return this.func(classOfT, funcName, fieldName, null);
    }

    @Override
    public int func(String tableName, String funcName, String colName) {
        return this.func(tableName, funcName, colName, null);
    }

    @Override
    public int func(Class<?> classOfT, String funcName, String colName, Condition cnd) {
        Entity<?> en = this.holder.getEntity(classOfT);
        if (null != en.getField(colName)) {
            colName = en.getField(colName).getColumnNameInSql();
        }
        DaoStatement pojo = this.pojoMaker.makeFunc(en.getViewName(), funcName, colName).append(Pojos.Items.cnd(cnd)).setAfter(this._pojo_fetchInt).setEntity(en);
        this._exec(pojo);
        return pojo.getInt();
    }

    @Override
    public int func(String tableName, String funcName, String colName, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeFunc(tableName, funcName, colName).append(Pojos.Items.cnd(cnd)).setAfter(this._pojo_fetchInt);
        this._exec(pojo);
        return pojo.getInt();
    }

    @Override
    public Object func2(Class<?> classOfT, String func2Name, String fieldName) {
        return this.func2(classOfT, func2Name, fieldName, null);
    }

    @Override
    public Object func2(String tableName, String func2Name, String colName) {
        return this.func2(tableName, func2Name, colName, null);
    }

    @Override
    public Object func2(Class<?> classOfT, String func2Name, String colName, Condition cnd) {
        Entity<?> en = this.holder.getEntity(classOfT);
        if (null != en.getField(colName)) {
            colName = en.getField(colName).getColumnNameInSql();
        }
        DaoStatement pojo = this.pojoMaker.makeFunc(en.getViewName(), func2Name, colName).append(Pojos.Items.cnd(cnd)).setAfter(this._pojo_fetchObject).setEntity(en);
        this._exec(pojo);
        return pojo.getResult();
    }

    @Override
    public Object func2(String tableName, String func2Name, String colName, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeFunc(tableName, func2Name, colName).append(Pojos.Items.cnd(cnd)).setAfter(this._pojo_fetchObject);
        this._exec(pojo);
        return pojo.getResult();
    }

    @Override
    public Pager createPager(int pageNumber, int pageSize) {
        Pager pager = new Pager();
        pager.setPageNumber(pageNumber);
        pager.setPageSize(pageSize);
        return pager;
    }

    @Override
    public synchronized <T> Entity<T> create(Class<T> classOfT, boolean dropIfExists) {
        Entity<T> en = this.holder.getEntity(classOfT);
        if (this.exists(en.getTableName())) {
            if (dropIfExists) {
                this.expert.dropEntity(this, en);
            } else {
                this.expert.createRelation(this, en);
                return en;
            }
        }
        this.holder.remove(classOfT.getName());
        final Entity<T> _en = this.holder.getEntity(classOfT);
        this.expert.createEntity(this, _en);
        this.run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                NutDao.this.expert.setupEntityField(conn, _en);
            }
        });
        return en;
    }

    @Override
    public boolean drop(Class<?> classOfT) {
        Entity<?> en = this.holder.getEntity(classOfT);
        if (!this.exists(en.getTableName())) {
            return false;
        }
        return this.expert.dropEntity(this, en);
    }

    @Override
    public boolean drop(String tableName) {
        if (!this.exists(tableName)) {
            return false;
        }
        Sql sql = Sqls.createf("DROP TABLE %s", tableName);
        this._exec(sql);
        return true;
    }

    @Override
    public boolean exists(Class<?> classOfT) {
        return this.exists(this.getEntity(classOfT).getViewName());
    }

    @Override
    public boolean exists(final String tableName) {
        final boolean[] ee = new boolean[]{false};
        this.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void invoke(Connection conn) {
                ResultSet rs;
                Statement stat;
                block4: {
                    stat = null;
                    rs = null;
                    try {
                        stat = conn.createStatement();
                        String sql = "SELECT COUNT(1) FROM " + tableName + " where 1!=1";
                        rs = stat.executeQuery(sql);
                        if (!rs.next()) break block4;
                        ee[0] = true;
                    }
                    catch (SQLException sQLException) {
                        Daos.safeClose(stat, rs);
                        catch (Throwable throwable) {
                            Daos.safeClose(stat, rs);
                            throw throwable;
                        }
                    }
                }
                Daos.safeClose(stat, rs);
            }
        });
        return ee[0];
    }

    private LinkVisitor doInsert(EntityOperator opt) {
        return new DoInsertLinkVisitor().opt(opt);
    }

    private LinkVisitor doInsertRelation(EntityOperator opt) {
        return new DoInsertRelationLinkVisitor(this.holder).opt(opt);
    }

    private LinkVisitor doUpdate(EntityOperator opt) {
        return new DoUpdateLinkVisitor().opt(opt);
    }

    private LinkVisitor doUpdateRelation(EntityOperator opt, Chain chain, Condition cnd) {
        return new DoUpdateRelationLinkVisitor(chain.toMap(), cnd).opt(opt);
    }

    private LinkVisitor doClearRelationByLinkedField(EntityOperator opt) {
        return new DoClearRelationByLinkedFieldLinkVisitor().opt(opt);
    }

    private LinkVisitor doClearRelationByHostField(EntityOperator opt) {
        return new DoClearRelationByHostFieldLinkVisitor().opt(opt);
    }

    private LinkVisitor doDelete(EntityOperator opt) {
        return new DoDeleteLinkVisitor().opt(opt);
    }

    private LinkVisitor doClear(EntityOperator opt) {
        return new DoClearLinkVisitor().opt(opt);
    }

    private LinkVisitor doFetch(final EntityOperator opt) {
        return new LinkVisitor(){

            @Override
            public void visit(Object obj, LinkField lnk) {
                Pojo pojo = opt.maker().makeQuery(lnk.getLinkedEntity());
                pojo.setOperatingObject(obj);
                pojo.append(Pojos.Items.cnd(lnk.createCondition(obj)));
                pojo.setAfter(lnk.getCallback());
                NutDao.this._exec(pojo);
                lnk.setValue(obj, pojo.getObject(Object.class));
            }
        };
    }

    private LinkVisitor doLinkQuery(final EntityOperator opt, final Condition cnd) {
        return new LinkVisitor(){

            @Override
            public void visit(Object obj, LinkField lnk) {
                Pojo pojo = opt.maker().makeQuery(lnk.getLinkedEntity());
                pojo.setOperatingObject(obj);
                PItem[] _cndItems = Pojos.Items.cnd(lnk.createCondition(obj));
                pojo.append(_cndItems);
                if (cnd != null) {
                    if (cnd instanceof Criteria) {
                        Criteria cri = (Criteria)cnd;
                        SqlExpressionGroup seg = cri.where();
                        if (_cndItems.length > 0 && seg != null && !seg.isEmpty()) {
                            seg.setTop(false);
                            pojo.append(Pojos.Items.wrap(" AND "));
                        }
                        pojo.append(cri);
                        if (cri.getPager() != null) {
                            pojo.setPager(cri.getPager());
                            NutDao.this.expert.formatQuery(pojo);
                        }
                    } else {
                        pojo.append(new ConditionPItem(cnd));
                    }
                }
                pojo.setAfter(lnk.getCallback());
                pojo.setEntity(lnk.getLinkedEntity());
                NutDao.this._exec(pojo);
                lnk.setValue(obj, pojo.getResult());
            }
        };
    }

    private <T> EntityOperator _opt() {
        EntityOperator opt = new EntityOperator();
        opt.dao = this;
        return opt;
    }

    <T> EntityOperator _opt(Entity<T> en) {
        EntityOperator opt = this._opt();
        opt.entity = en;
        return opt;
    }

    <T> EntityOperator _opt(Class<T> classOfT) {
        return this._opt(this.holder.getEntity(classOfT));
    }

    EntityOperator _optBy(Object obj) {
        if (null == obj) {
            return null;
        }
        Entity<?> en = this.holder.getEntityBy(obj);
        if (null == en) {
            return null;
        }
        EntityOperator re = this._opt(en);
        re.myObj = obj.getClass().isArray() ? Lang.array2list((Object[])obj) : obj;
        return re;
    }

    @Override
    public void setExpert(Object obj) throws Exception {
        if (obj == null) {
            throw new NullPointerException("expert MUST NOT NULL!!");
        }
        if (obj instanceof JdbcExpert) {
            this.expert = (JdbcExpert)obj;
        } else {
            String name = obj.toString();
            this.expert = Jdbcs.getExpert(name, "");
            if (this.expert == null) {
                if (name.contains(".")) {
                    this.expert = (JdbcExpert)Lang.loadClass(name).newInstance();
                } else {
                    throw new DaoException("not such expert=" + obj);
                }
            }
        }
        DataSource ds = this.dataSource;
        if (ds != null) {
            this.dataSource = null;
            this.setDataSource(ds);
        }
    }

    @Override
    public Sql execute(Sql sql) {
        if (sql != null) {
            this.execute(new Sql[]{sql});
        }
        return sql;
    }

    @Override
    public <T> T insert(final T t, boolean ignoreNull, boolean ignoreZero, boolean ignoreBlankStr) {
        Object obj = Lang.first(t);
        Entity<?> en = this.getEntity(obj.getClass());
        ArrayList<String> names = new ArrayList<String>();
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isName() || mf.isPk() || mf.isId()) {
                names.add(mf.getName());
                continue;
            }
            Object tmp = mf.getValue(obj);
            if (ignoreNull && tmp == null || ignoreZero && (tmp == null || tmp instanceof Number && ((Number)tmp).intValue() == 0) || ignoreBlankStr && tmp instanceof CharSequence && Strings.isBlank((CharSequence)tmp)) continue;
            names.add(mf.getName());
        }
        FieldFilter ff = FieldFilter.create(obj.getClass(), "^(" + Strings.join("|", names.toArray()) + ")$");
        Molecule m = new Molecule<T>(){

            @Override
            public void run() {
                NutDao.this.insert(t);
                this.setObj(t);
            }
        };
        return ff.run(m);
    }

    @Override
    public <T> List<T> query(final Class<T> classOfT, final Condition cnd, final Pager pager, FieldMatcher matcher) {
        if (matcher == null) {
            return this.query(classOfT, cnd, pager);
        }
        FieldFilter ff = FieldFilter.create(classOfT, matcher);
        Molecule m = new Molecule<List<T>>(){

            @Override
            public void run() {
                this.setObj(NutDao.this.query(classOfT, cnd, pager));
            }
        };
        return (List)ff.run(m);
    }

    @Override
    public <T> List<T> query(final Class<T> classOfT, final Condition cnd, final Pager pager, String regex) {
        if (regex == null) {
            return this.query(classOfT, cnd, pager);
        }
        FieldFilter ff = FieldFilter.create(classOfT, FieldMatcher.make(regex, null, false));
        Molecule m = new Molecule<List<T>>(){

            @Override
            public void run() {
                this.setObj(NutDao.this.query(classOfT, cnd, pager));
            }
        };
        return (List)ff.run(m);
    }

    @Override
    public <T> T insertOrUpdate(T t) {
        return this.insertOrUpdate(t, null, null);
    }

    @Override
    public <T> T insertOrUpdate(T t, FieldFilter insertFieldFilter, FieldFilter updateFieldFilter) {
        if (t == null) {
            return null;
        }
        Object obj = Lang.first(t);
        Entity<?> en = this.getEntity(obj.getClass());
        if (en.getPkType() == PkType.NAME) {
            MappingField mf = en.getNameField();
            Object val = mf.getValue(obj);
            if (val == null || this.fetch(obj.getClass(), (Condition)Cnd.where(mf.getName(), "=", val)) == null) {
                this.insert(t, insertFieldFilter);
            } else {
                this.update(t, updateFieldFilter);
            }
            return t;
        }
        if (this.fetch(t) != null) {
            this.update(t, updateFieldFilter);
        } else {
            this.insert(t, insertFieldFilter);
        }
        return t;
    }

    @Override
    public int updateAndIncrIfMatch(final Object obj, FieldFilter fieldFilter, String fieldName) {
        final EntityOperator opt = this._optBy(obj);
        if (null == opt) {
            return 0;
        }
        if (fieldName == null) {
            fieldName = "version";
        }
        if (fieldFilter == null) {
            fieldFilter = FieldFilter.create(opt.entity.getType(), null, "^" + fieldName + "$", false);
        } else {
            FieldMatcher fieldMatcher = fieldFilter.map().get(opt.entity.getType());
            if (fieldMatcher == null) {
                fieldMatcher = FieldMatcher.make(null, "^" + fieldName + "$", false);
                fieldFilter.map().put(opt.entity.getType(), fieldMatcher);
            } else if (fieldMatcher.getLocked() == null) {
                fieldMatcher.setLocked("^" + fieldName + "$");
            }
        }
        final String _fieldName = fieldName;
        fieldFilter.run(new Atom(){

            @Override
            public void run() {
                opt.addUpdateAndIncrIfMatch(opt.entity, obj, _fieldName);
                opt.exec();
            }
        });
        return opt.getUpdateCount();
    }

    @Override
    public int updateWithVersion(Object obj) {
        return this.updateWithVersion(obj, null);
    }

    @Override
    public int updateWithVersion(Object obj, FieldFilter fieldFilter) {
        return this.updateAndIncrIfMatch(obj, fieldFilter, this.getEntity(Lang.first(obj).getClass()).getVersionField().getName());
    }

    @Override
    public <T> T fetchByJoin(Class<T> klass, String regex, long id) {
        Entity<T> en = this.getEntity(klass);
        MappingField mf = en.getIdField();
        return this.fetchByJoin(klass, regex, en, mf, id);
    }

    @Override
    public <T> T fetchByJoin(Class<T> klass, String regex, String name) {
        Entity<T> en = this.getEntity(klass);
        MappingField mf = en.getNameField();
        return this.fetchByJoin(klass, regex, en, mf, name);
    }

    public <T> T fetchByJoin(Class<T> klass, String regex, Entity<T> en, MappingField mf, Object value) {
        String key = en.getTableName() + "." + mf.getColumnNameInSql();
        T t = this.fetchByJoin(klass, regex, Cnd.where(key, "=", value));
        if (t != null) {
            this._fetchLinks(t, regex, false, true, true, null);
        }
        return t;
    }

    @Override
    public <T> T fetchByJoin(Class<T> classOfT, String regex, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeQueryByJoin(this.holder.getEntity(classOfT), regex).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setPager(this.createPager(1, 1)).setAfter(new PojoFetchEntityByJoinCallback(regex));
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        T t = pojo.getObject(classOfT);
        if (t != null) {
            this._fetchLinks(t, regex, false, true, true, null);
        }
        return t;
    }

    @Override
    public <T> List<T> queryByJoin(Class<T> classOfT, String regex, Condition cnd) {
        return this.queryByJoin(classOfT, regex, cnd, null);
    }

    @Override
    public <T> List<T> queryByJoin(Class<T> classOfT, String regex, Condition cnd, Pager pager) {
        Pojo pojo = this.pojoMaker.makeQueryByJoin(this.holder.getEntity(classOfT), regex).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setPager(pager).setAfter(new PojoQueryEntityByJoinCallback(regex));
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        List<T> list = pojo.getList(classOfT);
        if (list != null && list.size() > 0) {
            for (T t : list) {
                this._fetchLinks(t, regex, false, true, true, null);
            }
        }
        return list;
    }

    @Override
    public <T> int countByJoin(Class<T> classOfT, String regex, Condition cnd) {
        Pojo pojo = this.pojoMaker.makeCountByJoin(this.holder.getEntity(classOfT), regex).append(Pojos.Items.cnd(cnd)).addParamsBy("*").setAfter(this._pojo_fetchInt);
        this.expert.formatQuery(pojo);
        this._exec(pojo);
        return pojo.getInt(0);
    }

    protected Object _fetchLinks(Object t, String regex, boolean visitOne, boolean visitMany, boolean visitManyMany, Condition cnd) {
        EntityOperator opt = this._optBy(t);
        if (null == opt) {
            return t;
        }
        if (visitMany) {
            opt.entity.visitMany(t, regex, this.doLinkQuery(opt, cnd));
        }
        if (visitManyMany) {
            opt.entity.visitManyMany(t, regex, this.doLinkQuery(opt, cnd));
        }
        if (visitOne) {
            opt.entity.visitOne(t, regex, this.doFetch(opt));
        }
        opt.exec();
        return t;
    }

    @Override
    public EntityHolder getEntityHolder() {
        return this.holder;
    }

    @Override
    public <T> T insert(T obj, String actived) {
        Object first = Lang.first(obj);
        if (null == first) {
            return null;
        }
        if (Strings.isBlank(actived)) {
            return this.insert(obj);
        }
        return this.insert(obj, FieldFilter.create(first.getClass(), actived));
    }

    @Override
    public void truncate(Class<?> klass) {
        Entity<?> en = this.getEntity(klass);
        this.truncate(en.getTableName());
    }

    @Override
    public void truncate(String tableName) {
        if (!this.exists(tableName)) {
            return;
        }
        Sql sql = Sqls.createf("TRUNCATE TABLE %s", tableName);
        this._exec(sql);
    }
}

