/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload;

import java.util.regex.Pattern;
import org.nutz.filepool.FilePool;
import org.nutz.filepool.NutFilePool;
import org.nutz.filepool.SynchronizedFilePool;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class UploadingContext {
    private static final Log log = Logs.get();
    private String charset = "UTF-8";
    private FilePool filePool;
    private int bufferSize = 8192;
    private boolean ignoreNull;
    private int maxFileSize;
    private String nameFilter;
    private String contentTypeFilter;
    private Pattern nameFilterPattern;

    public static UploadingContext create(String poolPath) {
        return UploadingContext.create(NutFilePool.getOrCreatePool(poolPath, 0L));
    }

    public static UploadingContext create(FilePool pool) {
        return new UploadingContext(pool);
    }

    public UploadingContext(String poolPath) {
        this(NutFilePool.getOrCreatePool(poolPath, 2000L));
    }

    public UploadingContext(FilePool pool) {
        this.setFilePool(pool);
    }

    public String getCharset() {
        return this.charset;
    }

    public UploadingContext setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public FilePool getFilePool() {
        return this.filePool;
    }

    public UploadingContext setFilePool(FilePool pool) {
        if (!(pool instanceof SynchronizedFilePool)) {
            pool = new SynchronizedFilePool(pool);
        }
        this.filePool = pool;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public UploadingContext setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        if (bufferSize < 128 && log.isWarnEnabled()) {
            log.warn("Uploading buffer is less than 128!! Auto-fix to 128!! 8192 will be much better!!");
            this.bufferSize = 128;
        }
        return this;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public UploadingContext setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public UploadingContext setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public UploadingContext setNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
        if (!Strings.isBlank(nameFilter)) {
            this.nameFilterPattern = Pattern.compile(nameFilter);
        }
        return this;
    }

    public boolean isNameAccepted(String name) {
        if (null == this.nameFilter || Strings.isBlank(name) || "\"\"".equals(name)) {
            return true;
        }
        if (this.nameFilterPattern == null) {
            return Pattern.matches(this.nameFilter, name.toLowerCase());
        }
        return this.nameFilterPattern.matcher(name.toLowerCase()).find();
    }

    public String getContentTypeFilter() {
        return this.contentTypeFilter;
    }

    public UploadingContext setContentTypeFilter(String contentTypeFilter) {
        this.contentTypeFilter = contentTypeFilter;
        return this;
    }

    public boolean isContentTypeAccepted(String contentType) {
        if (null == this.contentTypeFilter || Strings.isBlank(contentType)) {
            return true;
        }
        return Pattern.matches(this.contentTypeFilter, contentType.toLowerCase());
    }
}

