/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.filepool;

import java.io.File;
import java.io.IOException;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SimpleFilePool
implements FilePool {
    private static final Log log = Logs.get();
    private File home;
    private long max;
    private long current;

    public SimpleFilePool(String homePath, long max) {
        if (log.isInfoEnabled()) {
            log.infof("Init simple-file-pool by: %s [%s]", homePath, max);
        }
        this.max = max;
        this.home = Files.createDirIfNoExists(homePath);
        this.current = 0L;
    }

    private File _F(long fId, String suffix) {
        return new File(this.home.getAbsolutePath() + "/" + fId + (null == suffix ? "" : suffix));
    }

    @Override
    public synchronized boolean hasFile(long fId, String suffix) {
        return this._F(fId, suffix).exists();
    }

    @Override
    public long current() {
        return this.current;
    }

    @Override
    public synchronized File removeFile(long fId, String suffix) {
        File f = this._F(fId, suffix);
        if (f.exists()) {
            Files.deleteFile(f);
        }
        return f;
    }

    @Override
    public synchronized File createFile(String suffix) {
        File f = this._F(this.current++, suffix);
        if (this.current > this.max) {
            this.current = 0L;
        }
        if (!f.exists()) {
            try {
                Files.createNewFile(f);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return f;
    }

    @Override
    public long getFileId(File f) {
        String nm = Files.getMajorName(f);
        try {
            return Long.parseLong(nm);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    @Override
    public File getFile(long fId, String suffix) {
        File re = this._F(fId, suffix);
        if (re.exists()) {
            return re;
        }
        return null;
    }

    @Override
    public synchronized File returnFile(long fId, String suffix) {
        File re = this._F(fId, suffix);
        if (!re.exists()) {
            try {
                Files.createNewFile(re);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return re;
    }

    @Override
    public synchronized boolean hasDir(long fId) {
        return this._F(fId, null).exists();
    }

    @Override
    public synchronized File removeDir(long fId) {
        File f = this._F(fId, null);
        Files.deleteDir(f);
        return f;
    }

    @Override
    public synchronized File createDir() {
        File f = this._F(this.current++, null);
        if (this.current > this.max) {
            this.current = 0L;
        }
        if (f.exists()) {
            Files.clearDir(f);
        } else {
            Files.makeDir(f);
        }
        return f;
    }

    @Override
    public File getDir(long fId) {
        File re = this._F(fId, null);
        if (re.exists()) {
            return re;
        }
        return null;
    }

    @Override
    public synchronized File returnDir(long fId) {
        File re = this._F(fId, null);
        if (!re.exists()) {
            Files.makeDir(re);
        }
        return re;
    }

    @Override
    public synchronized void clear() {
        Files.clearDir(this.home);
    }
}

