/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.ast;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveInsert
extends SQLInsertInto {
    private boolean overwrite = false;
    private List<SQLAssignItem> partitions = new ArrayList<SQLAssignItem>();

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public List<SQLAssignItem> getPartitions() {
        return this.partitions;
    }

    public void addPartition(SQLAssignItem partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        this.partitions.add(partition);
    }

    public void setPartitions(List<SQLAssignItem> partitions) {
        this.partitions = partitions;
    }

    public void cloneTo(HiveInsert x) {
        this.cloneTo(x);
        x.overwrite = this.overwrite;
        for (SQLAssignItem item : this.partitions) {
            x.addPartition(item.clone());
        }
    }

    @Override
    public SQLInsertInto clone() {
        HiveInsert x = new HiveInsert();
        this.cloneTo(x);
        return x;
    }

    @Override
    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    @Override
    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    @Override
    public void setTableSource(SQLName tableName) {
        this.setTableSource(new SQLExprTableSource(tableName));
    }

    @Override
    public SQLSelect getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(SQLSelect query) {
        if (query != null) {
            query.setParent(this);
        }
        this.query = query;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof HiveASTVisitor) {
            this.accept0((HiveASTVisitor)visitor);
        } else {
            this.accept0((OdpsASTVisitor)visitor);
        }
    }

    protected void accept0(OdpsASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.tableSource);
            this.acceptChild((SQLASTVisitor)visitor, this.partitions);
            this.acceptChild((SQLASTVisitor)visitor, this.query);
        }
        visitor.endVisit(this);
    }

    protected void accept0(HiveASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.tableSource);
            this.acceptChild((SQLASTVisitor)visitor, this.partitions);
            this.acceptChild((SQLASTVisitor)visitor, this.query);
        }
        visitor.endVisit(this);
    }
}

