/*
 * Decompiled with CFR 0.152.
 */
package cn.apiclub.captcha.text.producer;

import cn.apiclub.captcha.text.producer.TextProducer;
import java.security.SecureRandom;
import java.util.Random;

public class DefaultTextProducer
implements TextProducer {
    private static final Random RAND = new SecureRandom();
    private static final int DEFAULT_LENGTH = 5;
    private static final char[] DEFAULT_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'k', 'm', 'n', 'p', 'r', 'w', 'x', 'y', '2', '3', '4', '5', '6', '7', '8'};
    private final int _length;
    private final char[] _srcChars;

    public DefaultTextProducer() {
        this(5, DEFAULT_CHARS);
    }

    public DefaultTextProducer(int length, char[] srcChars) {
        this._length = length;
        this._srcChars = DefaultTextProducer.copyOf(srcChars, srcChars.length);
    }

    @Override
    public String getText() {
        String capText = "";
        int i = 0;
        while (i < this._length) {
            capText = String.valueOf(capText) + this._srcChars[RAND.nextInt(this._srcChars.length)];
            ++i;
        }
        return capText;
    }

    private static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

