/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nutz.lang.Strings;

public class FieldMeta {
    Map<String, String> map = new HashMap<String, String>();

    public FieldMeta(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean needPairEnd = false;
        Object object = s.toCharArray();
        int n = ((char[])object).length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(object[i]);
            if (needPairEnd) {
                if (c.charValue() == '\"') {
                    needPairEnd = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c.charValue() == '\"') {
                needPairEnd = true;
                continue;
            }
            if (c.charValue() == ';' || c.charValue() == '\n') {
                if (sb.length() > 0) {
                    list.add(sb.toString().trim());
                }
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        object = list.iterator();
        while (object.hasNext()) {
            String pair = (String)object.next();
            if (pair.isEmpty()) continue;
            String name = pair.split("[:=]")[0];
            String value = pair.replaceAll("^[^=:]*[=:]", "");
            this.map.put(Strings.trim(name), FieldMeta.formatValue(value));
        }
    }

    private static String formatValue(String s) {
        if (null != (s = Strings.trim(s)) && s.length() > 2 && s.charAt(0) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        if ("\"\"".equals(s)) {
            return "";
        }
        return s;
    }

    public String getContentType() {
        return this.map.get("Content-Type");
    }

    public String getName() {
        return this.map.get("name");
    }

    public String getFileLocalPath() {
        return this.map.get("filename");
    }

    public String getFileLocalName() {
        return new File(this.getFileLocalPath().replace('\\', '/')).getName();
    }

    public String getFileExtension() {
        String name = this.getFileLocalPath();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos);
        }
        return "";
    }

    public String getContentDisposition() {
        return this.map.get("Content-Disposition");
    }

    public boolean isFile() {
        return null != this.getFileLocalPath();
    }
}

