/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import java.lang.reflect.Field;
import java.util.Map;
import org.nutz.dao.Dao;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.util.Daos;
import org.nutz.json.Json;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback2;
import org.nutz.lang.util.NutMap;

public abstract class Chain {
    public static Chain make(String name, Object value) {
        return new DefaultChain(name, value);
    }

    public abstract int size();

    public abstract Chain name(String var1);

    public abstract Chain value(Object var1);

    public abstract Chain adaptor(ValueAdaptor var1);

    public abstract ValueAdaptor adaptor();

    public abstract Chain add(String var1, Object var2);

    public abstract String name();

    public abstract Object value();

    public abstract Chain next();

    public abstract Chain head();

    public abstract Chain updateBy(Entity<?> var1);

    public abstract <T> T toObject(Class<T> var1);

    public abstract Map<String, Object> toMap();

    public abstract boolean isSpecial();

    public abstract boolean special();

    public Map<String, Object> toEntityMap(String tableName) {
        Map<String, Object> map = this.toMap();
        map.put(".table", tableName);
        return map;
    }

    public String toString() {
        return Json.toJson(this.toMap());
    }

    public static Chain from(Object obj, FieldMatcher fm) {
        if (null == obj) {
            return null;
        }
        Chain c = null;
        if (obj instanceof Map) {
            for (Map.Entry en : ((Map)obj).entrySet()) {
                Object key = en.getKey();
                if (null == key) continue;
                String name = key.toString();
                if (null != fm && !fm.match(name)) continue;
                Object v = en.getValue();
                if (null != fm && (null != v ? fm.isIgnoreBlankStr() && v instanceof String && Strings.isBlank((String)v) : fm.isIgnoreNull())) continue;
                if (c == null) {
                    c = Chain.make(name, v);
                    continue;
                }
                c = c.add(name, v);
            }
        } else {
            Mirror<Class<?>> mirror = Mirror.me(obj.getClass());
            for (Field f : mirror.getFields()) {
                Object v;
                if (null != fm && !fm.match(f.getName()) || (null != (v = mirror.getValue(obj, f.getName())) ? fm != null && fm.isIgnoreBlankStr() && v instanceof String && Strings.isBlank((String)v) : fm != null && fm.isIgnoreNull())) continue;
                c = c == null ? Chain.make(f.getName(), v) : c.add(f.getName(), v);
            }
        }
        return c;
    }

    public static Chain from(Object obj) {
        return Chain.from(obj, null);
    }

    public static Chain from(Object obj, FieldMatcher fm, Dao dao) {
        final Chain[] chains = new Chain[1];
        boolean re = Daos.filterFields(obj, fm, dao, new Callback2<MappingField, Object>(){

            @Override
            public void invoke(MappingField mf, Object val) {
                if (mf.isReadonly() || !mf.isUpdate()) {
                    return;
                }
                if (chains[0] == null) {
                    chains[0] = Chain.make(mf.getName(), val);
                } else {
                    chains[0].add(mf.getName(), val);
                }
            }
        });
        if (re) {
            return chains[0];
        }
        return null;
    }

    public abstract Chain addSpecial(String var1, Object var2);

    public static Chain makeSpecial(String name, Object value) {
        DefaultChain chain = new DefaultChain(name, value);
        ((DefaultChain)chain).head.special = true;
        return chain;
    }

    public static class Entry {
        protected String name;
        Object value;
        ValueAdaptor adaptor;
        boolean special;
        Entry next;

        public Entry(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class DefaultChain
    extends Chain {
        private Entry head;
        private Entry current;
        private Entry tail;
        private int size;

        public DefaultChain(String name, Object value) {
            this.current = this.head = new Entry(name, value);
            this.tail = this.head;
            this.size = 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Chain name(String name) {
            this.current.name = name;
            return this;
        }

        @Override
        public Chain value(Object value) {
            this.current.value = value;
            return this;
        }

        @Override
        public Chain adaptor(ValueAdaptor adaptor) {
            this.current.adaptor = adaptor;
            return this;
        }

        @Override
        public ValueAdaptor adaptor() {
            return this.current.adaptor;
        }

        @Override
        public Chain add(String name, Object value) {
            this.tail = this.tail.next = new Entry(name, value);
            ++this.size;
            return this;
        }

        @Override
        public String name() {
            return this.current.name;
        }

        @Override
        public Object value() {
            return this.current.value;
        }

        @Override
        public Chain next() {
            this.current = this.current.next;
            return this.current == null ? null : this;
        }

        @Override
        public Chain head() {
            this.current = this.head;
            return this;
        }

        @Override
        public Chain addSpecial(String name, Object value) {
            this.add(name, value);
            this.tail.special = true;
            return this;
        }

        @Override
        public boolean special() {
            return this.current.special;
        }

        @Override
        public boolean isSpecial() {
            Entry entry = this.head;
            do {
                if (!entry.special) continue;
                return true;
            } while ((entry = entry.next) != null);
            return false;
        }

        @Override
        public Map<String, Object> toMap() {
            NutMap map = new NutMap();
            Entry current = this.head;
            while (current != null) {
                map.put(current.name, current.value);
                if (current.adaptor != null) {
                    map.put("." + current.name + ".adaptor", current.adaptor);
                }
                current = current.next;
            }
            return map;
        }

        @Override
        public Chain updateBy(Entity<?> entity) {
            if (null != entity) {
                Entry current = this.head;
                while (current != null) {
                    MappingField ef = entity.getField(current.name);
                    if (null != ef) {
                        current.name = ef.getColumnNameInSql();
                    }
                    current = current.next;
                }
            }
            return this.head();
        }

        @Override
        public <T> T toObject(Class<T> classOfT) {
            Mirror<Class<T>> mirror = Mirror.me(classOfT);
            Class<T> re = mirror.born(new Object[0]);
            Entry current = this.head;
            while (current != null) {
                mirror.setValue(re, current.name, current.value);
                current = current.next;
            }
            return (T)re;
        }
    }
}

