/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;

class FileHashMapEntry<K>
implements Serializable,
Comparable<FileHashMapEntry> {
    private static final long serialVersionUID = 1L;
    private long filePosition = -1L;
    private int objectSize = -1;
    private K key = null;

    FileHashMapEntry(long pos, int size, K key) {
        this.filePosition = pos;
        this.objectSize = size;
        this.key = key;
    }

    FileHashMapEntry(long pos, int size) {
        this(pos, size, null);
    }

    @Override
    public int compareTo(FileHashMapEntry o) {
        FileHashMapEntry other = o;
        Long thisPos = new Long(this.filePosition);
        Long otherPos = new Long(other.filePosition);
        return thisPos.compareTo(otherPos);
    }

    public String toString() {
        return "FileHashMapEntry[filePosition=" + this.filePosition + ", objectSize=" + this.objectSize + ", key=" + (this.key == null ? "<null>" : this.key) + "]";
    }

    K getKey() {
        return this.key;
    }

    void setKey(K newKey) {
        this.key = newKey;
    }

    long getFilePosition() {
        return this.filePosition;
    }

    void setFilePosition(long pos) {
        this.filePosition = pos;
    }

    int getObjectSize() throws IllegalStateException {
        assert (this.objectSize > 0) : "No object stored yet";
        return this.objectSize;
    }

    void setObjectSize(int size) {
        this.objectSize = size;
    }
}

