/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private T[] array = null;
    private int nextIndex = 0;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    public ArrayIterator(T[] array, int index) {
        this.array = array;
        this.nextIndex = index;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    @Override
    public boolean hasNext() {
        return this.array != null && this.nextIndex < this.array.length;
    }

    @Override
    public T next() throws NoSuchElementException {
        T result = null;
        try {
            if (this.array == null) {
                throw new NoSuchElementException();
            }
            result = this.array[this.nextIndex++];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public T previous() throws NoSuchElementException {
        T result = null;
        try {
            result = this.array[--this.nextIndex];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

