/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.clapper.util.io.JustifyStyle;
import org.clapper.util.text.TextUtil;

public class JustifyTextWriter
extends PrintWriter {
    public static final int DEFAULT_LINE_LENGTH = 80;
    private PrintWriter writer = null;
    private int lineLength = 80;
    private StringBuffer buffer = new StringBuffer();
    private JustifyStyle justification = JustifyStyle.LEFT_JUSTIFY;

    public JustifyTextWriter(Writer output, JustifyStyle justification) {
        this(new PrintWriter(output), justification, 80);
    }

    public JustifyTextWriter(PrintWriter output, JustifyStyle justification) {
        this(output, justification, 80);
    }

    public JustifyTextWriter(OutputStream output, JustifyStyle justification) {
        this(output, justification, 80);
    }

    public JustifyTextWriter(Writer output, JustifyStyle justification, int lineLength) {
        this(new PrintWriter(output), justification, lineLength);
    }

    public JustifyTextWriter(PrintWriter output, JustifyStyle justification, int lineLength) {
        super(output);
        this.writer = output;
        this.setLineLength(lineLength);
        this.setJustification(justification);
    }

    public JustifyTextWriter(OutputStream output, JustifyStyle justification, int lineLength) {
        super(output);
        this.writer = new PrintWriter(output);
        this.setLineLength(lineLength);
        this.setJustification(justification);
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void flush() {
        this.flushBufferedLine();
        this.writer.flush();
    }

    public JustifyStyle getJustification() {
        return this.justification;
    }

    public void setJustification(JustifyStyle style) {
        this.justification = style;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int newLineLength) throws IndexOutOfBoundsException {
        if (newLineLength < 0) {
            throw new IndexOutOfBoundsException("Line length of " + newLineLength + " is negative.");
        }
        this.lineLength = newLineLength;
    }

    @Override
    public void print(boolean b) {
        Boolean B = new Boolean(b);
        this.write(B.toString());
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] s) {
        this.write(s, 0, s.length);
    }

    @Override
    public void print(double d) {
        Double D = new Double(d);
        this.write(D.toString());
    }

    @Override
    public void print(float f) {
        Float F = new Float(f);
        this.write(F.toString());
    }

    @Override
    public void print(int i) {
        Integer I = new Integer(i);
        this.write(I.toString());
    }

    @Override
    public void print(long l) {
        Long L = new Long(l);
        this.write(L.toString());
    }

    public void print(short s) {
        Short S = new Short(s);
        this.write(S.toString());
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public void print(Object x) {
        this.write(x.toString());
    }

    @Override
    public void println() {
        this.flushBufferedLine();
        this.writer.println();
    }

    @Override
    public void println(boolean b) {
        Boolean B = new Boolean(b);
        this.println(B.toString());
    }

    @Override
    public void println(char c) {
        this.println(c);
    }

    @Override
    public void println(char[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.print(s[i]);
        }
        this.println();
    }

    @Override
    public void println(double d) {
        Double D = new Double(d);
        this.println(D.toString());
    }

    @Override
    public void println(float f) {
        Float F = new Float(f);
        this.println(F.toString());
    }

    @Override
    public void println(int i) {
        Integer I = new Integer(i);
        this.println(I.toString());
    }

    @Override
    public void println(long l) {
        Long L = new Long(l);
        this.println(L.toString());
    }

    public void println(short s) {
        Short S = new Short(s);
        this.println(S.toString());
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.println(x.toString());
    }

    @Override
    public void write(int c) {
        this.buffer.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        while (off < cbuf.length && len > 0) {
            this.write(cbuf[off]);
            --len;
            ++off;
        }
    }

    @Override
    public void write(String s, int off, int len) {
        char[] cbuf = s.toCharArray();
        this.write(cbuf, off, len);
    }

    @Override
    public void write(String s) {
        char[] cbuf = s.toCharArray();
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    private synchronized void flushBufferedLine() {
        if (this.buffer.length() > 0) {
            String s = this.buffer.toString();
            switch (this.justification) {
                case LEFT_JUSTIFY: {
                    this.writer.print(s);
                    break;
                }
                case RIGHT_JUSTIFY: {
                    this.writer.print(TextUtil.rightJustifyString(s, this.lineLength));
                    break;
                }
                case CENTER: {
                    this.writer.print(TextUtil.centerString(s, this.lineLength));
                }
            }
            this.buffer.setLength(0);
        }
    }
}

