/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.html;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.text.TextUtil;
import org.clapper.util.text.XStringBuffer;
import org.clapper.util.text.XStringBuilder;

public final class HTMLUtil {
    private static final String BUNDLE_NAME = "org.clapper.util.html.HTMLUtil";
    private static ResourceBundle resourceBundle = null;
    private static Pattern entityPattern = null;

    private HTMLUtil() {
    }

    public static String stripHTMLTags(String s) {
        char[] ch = s.toCharArray();
        boolean inElement = false;
        XStringBuilder buf = new XStringBuilder();
        block4: for (int i = 0; i < ch.length; ++i) {
            switch (ch[i]) {
                case '<': {
                    inElement = true;
                    continue block4;
                }
                case '>': {
                    if (inElement) {
                        inElement = false;
                        continue block4;
                    }
                    buf.append(ch[i]);
                    continue block4;
                }
                default: {
                    if (inElement) continue block4;
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String escapeHTML(String s) {
        StringBuilder buf = new StringBuilder();
        block5: for (char c : s.toCharArray()) {
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertCharacterEntities(String s) {
        Class<HTMLUtil> clazz = HTMLUtil.class;
        synchronized (HTMLUtil.class) {
            block14: {
                try {
                    if (entityPattern == null) {
                        entityPattern = Pattern.compile("&(#?[^;\\s&]+);?");
                    }
                }
                catch (PatternSyntaxException ex) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            XStringBuffer buf = new XStringBuffer();
            Matcher matcher = null;
            Class<HTMLUtil> clazz2 = HTMLUtil.class;
            synchronized (HTMLUtil.class) {
                matcher = entityPattern.matcher(s);
                // ** MonitorExit[var3_5] (shouldn't be in output)
                while (true) {
                    String match = null;
                    String preMatch = null;
                    String postMatch = null;
                    if (!matcher.find()) break;
                    match = matcher.group(1);
                    preMatch = s.substring(0, matcher.start(1) - 1);
                    if (preMatch != null) {
                        buf.append(preMatch);
                    }
                    if (s.charAt(matcher.end() - 1) != ';') {
                        buf.append(s.substring(matcher.start(), matcher.end()));
                        postMatch = s.substring(matcher.end(1));
                    } else {
                        postMatch = s.substring(matcher.end(1) + 1);
                        buf.append(HTMLUtil.convertEntity(match));
                    }
                    if (postMatch == null) break;
                    s = postMatch;
                    matcher.reset(s);
                }
                if (s.length() > 0) {
                    buf.append(s);
                }
                return buf.toString();
            }
        }
    }

    public static String makeCharacterEntities(String s) {
        char c;
        ResourceBundle bundle = HTMLUtil.getResourceBundle();
        HashMap<Character, String> charToEntityName = new HashMap<Character, String>();
        Enumeration<String> keys = bundle.getKeys();
        XStringBuffer buf = new XStringBuffer();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String sChar = bundle.getString(key);
            c = sChar.charAt(0);
            buf.clear();
            buf.append(key);
            buf.delete("html_");
            charToEntityName.put(Character.valueOf(c), buf.toString());
        }
        char[] chars = s.toCharArray();
        buf.clear();
        for (int i = 0; i < chars.length; ++i) {
            c = chars[i];
            String entity = (String)charToEntityName.get(Character.valueOf(c));
            if (entity == null) {
                if (!TextUtil.isPrintable(c)) {
                    buf.append("&#");
                    buf.append((Object)c);
                    buf.append(';');
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append('&');
            buf.append(entity);
            buf.append(';');
        }
        return buf.toString();
    }

    public static String textFromHTML(String s) {
        String stripped = HTMLUtil.convertCharacterEntities(HTMLUtil.stripHTMLTags(s));
        char[] ch = stripped.toCharArray();
        StringBuilder buf = new StringBuilder();
        block9: for (int i = 0; i < ch.length; ++i) {
            switch (ch[i]) {
                case '\u2018': 
                case '\u2019': {
                    buf.append('\'');
                    continue block9;
                }
                case '\u201c': 
                case '\u201d': {
                    buf.append('\"');
                    continue block9;
                }
                case '\u2014': {
                    buf.append("--");
                    continue block9;
                }
                case '\u2011': 
                case '\u2013': {
                    buf.append('-');
                    continue block9;
                }
                case '\u200c': 
                case '\u200d': {
                    continue block9;
                }
                case '\u2122': {
                    buf.append("[TM]");
                    continue block9;
                }
                case '\u00a0': 
                case '\u2002': 
                case '\u2003': 
                case '\u2009': 
                case '\u200a': {
                    buf.append(' ');
                    continue block9;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    private static String convertEntity(String s) {
        StringBuilder buf = new StringBuilder();
        ResourceBundle bundle = HTMLUtil.getResourceBundle();
        if (s.charAt(0) == '#') {
            if (s.length() == 1) {
                buf.append('#');
            } else {
                boolean isHex = s.length() > 2 && s.charAt(1) == 'x';
                boolean isLegal = false;
                try {
                    int cc = isHex ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s.substring(1));
                    if (Character.isDefined((char)cc)) {
                        buf.append((char)cc);
                        isLegal = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!isLegal) {
                    buf.append("&#");
                    if (isHex) {
                        buf.append('x');
                    }
                    buf.append(s + ";");
                }
            }
        } else {
            try {
                buf.append(bundle.getString("html_" + s));
            }
            catch (MissingResourceException ex) {
                buf.append("&" + s + ";");
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResourceBundle() {
        Class<HTMLUtil> clazz = HTMLUtil.class;
        synchronized (HTMLUtil.class) {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return resourceBundle;
        }
    }
}

