/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import org.clapper.util.classutil.ClassUtilException;

public class ClassUtil {
    static final String BUNDLE_NAME = "org.clapper.util.classutil.Bundle";

    private ClassUtil() {
    }

    public static boolean fileCanContainClasses(File file) {
        boolean can = false;
        String fileName = file.getPath();
        if (file.exists()) {
            can = fileName.toLowerCase().endsWith(".jar") || fileName.toLowerCase().endsWith(".zip") || file.isDirectory();
        }
        return can;
    }

    public static String getShortClassName(String fullClassName) {
        String shortClassName = fullClassName;
        int i = shortClassName.lastIndexOf(46);
        if (i != -1 && ++i < shortClassName.length()) {
            shortClassName = shortClassName.substring(i);
        }
        return shortClassName;
    }

    public static String getShortClassName(Class cls) {
        return ClassUtil.getShortClassName(cls.getName());
    }

    public static Object instantiateClass(String className) throws ClassUtilException {
        try {
            Class<?> cls = Class.forName(className);
            return cls.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new ClassUtilException("Can't load class " + className, ex);
        }
        catch (ClassCastException ex) {
            throw new ClassUtilException("Can't load class " + className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ClassUtilException("Can't load class " + className, ex);
        }
        catch (InstantiationException ex) {
            throw new ClassUtilException("Can't load class " + className, ex);
        }
    }
}

