/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassFinder;
import org.clapper.util.classutil.ClassInfo;

public final class AndClassFilter
implements ClassFilter {
    private List<ClassFilter> filters = new LinkedList<ClassFilter>();

    public AndClassFilter() {
    }

    public AndClassFilter(ClassFilter ... filters) {
        for (ClassFilter filter : filters) {
            this.addFilter(filter);
        }
    }

    public AndClassFilter addFilter(ClassFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public void removeFilter(ClassFilter filter) {
        this.filters.remove(filter);
    }

    public Collection<ClassFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public int getTotalFilters() {
        return this.filters.size();
    }

    @Override
    public boolean accept(ClassInfo classInfo, ClassFinder classFinder) {
        ClassFilter filter;
        boolean accepted = true;
        Iterator<ClassFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (accepted = (filter = iterator.next()).accept(classInfo, classFinder))) {
        }
        return accepted;
    }
}

