/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.UpdateChecker;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class GithubUpdateChecker
extends UpdateChecker {
    public GithubUpdateChecker(String username, String reponame) throws MalformedURLException {
        this("https://api.github.com/repos/" + username + "/" + reponame + "/releases/latest");
    }

    public GithubUpdateChecker(String url) throws MalformedURLException {
        super(url);
    }

    private static String removeLatestFromURL(String url) {
        if (url.endsWith("/latest")) {
            return url.substring(0, url.length() - "/latest".length());
        }
        return url;
    }

    @Override
    protected void obtainLatestRelease() throws IOException {
        try {
            super.obtainLatestRelease();
        }
        catch (FileNotFoundException e) {
            this.jsonURL = new URL(GithubUpdateChecker.removeLatestFromURL(this.jsonURL.toString()));
            HttpURLConnection request = (HttpURLConnection)this.jsonURL.openConnection();
            request.connect();
            try {
                JsonParser jp = new JsonParser();
                JsonElement root = jp.parse(new InputStreamReader((InputStream)request.getContent()));
                this.latest = root.getAsJsonArray().get(0).getAsJsonObject();
            }
            catch (JsonSyntaxException e2) {
                System.out.println(this.jsonURL);
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public Semver getLatestReleaseVersion() throws IOException {
        try {
            return ModInfo.safeVersion(this.getElementAsString("tag_name"));
        }
        catch (SemverException e) {
            JOptionPane.showMessageDialog(null, this.getElementAsString("html_url") + "\nrelease has a missing or bad version number: \"" + this.getElementAsString("tag_name") + "\".\nGo yell at the author to fix it.", "Warning", 2);
            return null;
        }
    }

    @Override
    public URL getLatestReleaseURL() throws IOException {
        return new URL(this.getElementAsString("html_url"));
    }

    @Override
    public URL getLatestDownloadURL() throws IOException {
        JsonElement assets = this.getElement("assets");
        if (!(assets instanceof JsonArray)) {
            throw new RuntimeException("Excepted assets to be of type array");
        }
        for (JsonElement asset : (JsonArray)assets) {
            JsonObject object;
            String url;
            if (!(asset instanceof JsonObject) || !this.isJar(url = (object = (JsonObject)asset).get("browser_download_url").getAsString())) continue;
            return new URL(url);
        }
        throw new RuntimeException("Could not find jar asset to download");
    }

    private boolean isJar(String url) {
        return url.toLowerCase().endsWith(".jar");
    }
}

