/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Curve;
import java.util.ArrayList;
import java.util.List;

public class Mainline {
    public final List<Key> keys;

    public Mainline() {
        this(new ArrayList<Key>());
    }

    public Mainline(List<Key> keys) {
        this.keys = keys;
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|";
        for (Key key : this.keys) {
            toReturn = toReturn + "\n" + key;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }

    public Key getKey(int index) {
        return this.keys.get(index);
    }

    public Key getKeyBeforeTime(int time) {
        Key found = this.keys.get(0);
        for (Key key : this.keys) {
            if (key.time > time) break;
            found = key;
        }
        return found;
    }

    public static class Key {
        public final int id;
        public final int time;
        final List<BoneRef> boneRefs;
        final List<ObjectRef> objectRefs;
        public final Curve curve;

        public Key(int id, int time, Curve curve) {
            this(id, time, curve, new ArrayList<BoneRef>(), new ArrayList<ObjectRef>());
        }

        public Key(int id, int time, Curve curve, List<BoneRef> boneRefs, List<ObjectRef> objectRefs) {
            this.id = id;
            this.time = time;
            this.curve = curve;
            this.boneRefs = boneRefs;
            this.objectRefs = objectRefs;
        }

        public void addBoneRef(BoneRef ref) {
            this.boneRefs.add(ref);
        }

        public void addObjectRef(ObjectRef ref) {
            this.objectRefs.add(ref);
        }

        public BoneRef getBoneRef(int index) {
            if (index < 0 || index >= this.boneRefs.size()) {
                return null;
            }
            return this.boneRefs.get(index);
        }

        public ObjectRef getObjectRef(int i) {
            if (i < 0 || i >= this.objectRefs.size()) {
                return null;
            }
            return this.objectRefs.get(i);
        }

        public BoneRef getBoneRef(BoneRef ref) {
            return this.getBoneRefTimeline(ref.timeline);
        }

        public BoneRef getBoneRefTimeline(int timeline) {
            for (BoneRef boneRef : this.boneRefs) {
                if (boneRef.timeline != timeline) continue;
                return boneRef;
            }
            return null;
        }

        public ObjectRef getObjectRef(ObjectRef ref) {
            return this.getObjectRefTimeline(ref.timeline);
        }

        public ObjectRef getObjectRefTimeline(int timeline) {
            for (ObjectRef objRef : this.objectRefs) {
                if (objRef.timeline != timeline) continue;
                return objRef;
            }
            return null;
        }

        public String toString() {
            String toReturn = this.getClass().getSimpleName() + "|[id:" + this.id + ", time: " + this.time + ", curve: [" + this.curve + "]";
            for (BoneRef boneRef : this.boneRefs) {
                toReturn = toReturn + "\n" + boneRef;
            }
            for (ObjectRef objectRef : this.objectRefs) {
                toReturn = toReturn + "\n" + objectRef;
            }
            toReturn = toReturn + "]";
            return toReturn;
        }

        public static class ObjectRef
        extends BoneRef
        implements Comparable<ObjectRef> {
            public final int zIndex;

            public ObjectRef(int id, int timeline, int key, BoneRef parent, int zIndex) {
                super(id, timeline, key, parent);
                this.zIndex = zIndex;
            }

            @Override
            public String toString() {
                return super.toString() + ", z_index: " + this.zIndex;
            }

            @Override
            public int compareTo(ObjectRef o) {
                return (int)Math.signum(this.zIndex - o.zIndex);
            }
        }

        public static class BoneRef {
            public final int id;
            public final int key;
            public final int timeline;
            public final BoneRef parent;

            public BoneRef(int id, int timeline, int key, BoneRef parent) {
                this.id = id;
                this.timeline = timeline;
                this.key = key;
                this.parent = parent;
            }

            public String toString() {
                int parentId = this.parent != null ? this.parent.id : -1;
                return this.getClass().getSimpleName() + "|id: " + this.id + ", parent:" + parentId + ", timeline: " + this.timeline + ", key: " + this.key;
            }
        }
    }
}

