/*
 * Decompiled with CFR 0.152.
 */
package basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup;

import basemod.ReflectionHacks;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.LineFinder;
import com.evacipated.cardcrawl.modthespire.lib.Matcher;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertLocator;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.evacipated.cardcrawl.modthespire.lib.StaticSpireField;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;
import com.megacrit.cardcrawl.screens.mainMenu.ScrollBar;
import com.megacrit.cardcrawl.screens.mainMenu.ScrollBarListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class ScrollingTooltips {
    private static float BODY_TEXT_WIDTH = -1.0f;
    private static float TIP_DESC_LINE_SPACING;
    private static float BOX_EDGE_H;

    private static float powerTipsHeight(ArrayList<PowerTip> powerTips) {
        ScrollingTooltips.getSizes();
        float height = 0.0f;
        for (PowerTip tip : powerTips) {
            float textHeight = -FontHelper.getSmartHeight((BitmapFont)FontHelper.tipBodyFont, (String)tip.body, (float)BODY_TEXT_WIDTH, (float)TIP_DESC_LINE_SPACING) - 7.0f * Settings.scale;
            height += textHeight + BOX_EDGE_H * 3.15f;
        }
        return height;
    }

    private static void getSizes() {
        if (BODY_TEXT_WIDTH < 0.0f) {
            BODY_TEXT_WIDTH = ((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BODY_TEXT_WIDTH")).floatValue();
            TIP_DESC_LINE_SPACING = ((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "TIP_DESC_LINE_SPACING")).floatValue();
            BOX_EDGE_H = ((Float)ReflectionHacks.getPrivateStatic(TipHelper.class, "BOX_EDGE_H")).floatValue();
        }
    }

    public static void queueScrollingPowerTips(float x, float y, ArrayList<PowerTip> powerTips, float scrollingSize) {
        y -= 20.0f * Settings.scale;
        float tipsHeight = ScrollingTooltips.powerTipsHeight(powerTips);
        if (tipsHeight > scrollingSize) {
            IsScrolling.isScrolling.set((Object)Float.valueOf(scrollingSize));
            Fields.scrollUpperBound = tipsHeight - scrollingSize;
        }
        TipHelper.queuePowerTips((float)x, (float)y, powerTips);
    }

    @SpirePatches(value={@SpirePatch(clz=SingleCardViewPopup.class, method="open", paramtypez={AbstractCard.class}), @SpirePatch(clz=SingleCardViewPopup.class, method="open", paramtypez={AbstractCard.class, CardGroup.class})})
    public static class ResetScrolling {
        public static void MyPrefix() {
            Fields.scrollPosition = (Fields.scrollTarget = 0.0f);
        }

        public static void Raw(CtBehavior ctBehavior) throws CannotCompileException {
            ctBehavior.insertBefore(ResetScrolling.class.getName() + ".MyPrefix();");
        }
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="renderTips")
    public static class ChangeMethodCall {
        public static ExprEditor Instrument() {
            return new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getMethodName().equals("queuePowerTips")) {
                        m.replace(ScrollingTooltips.class.getName() + ".queueScrollingPowerTips($$, $2);");
                    }
                }
            };
        }
    }

    @SpirePatch(clz=TipHelper.class, method="<class>")
    public static class IsScrolling {
        public static StaticSpireField<Float> isScrolling = new StaticSpireField(() -> Float.valueOf(-1.0f));
    }

    @SpirePatch(clz=SingleCardViewPopup.class, method="updateInput")
    public static class UpdateScrollBar {
        @SpireInsertPatch(locator=Locator.class)
        public static SpireReturn<Void> Insert(SingleCardViewPopup __instance) {
            if (Fields.scrollBar.update()) {
                return SpireReturn.Return(null);
            }
            if (InputHelper.scrolledUp) {
                Fields.scrollTarget = Fields.scrollTarget - Settings.SCROLL_SPEED / 2.0f;
            } else if (InputHelper.scrolledDown) {
                Fields.scrollTarget = Fields.scrollTarget + Settings.SCROLL_SPEED / 2.0f;
            }
            Fields.scrollPosition = MathHelper.scrollSnapLerpSpeed((float)Fields.scrollPosition, (float)Fields.scrollTarget);
            if (Fields.scrollTarget < 0.0f) {
                Fields.scrollTarget = 0.0f;
            }
            if (Fields.scrollTarget > Fields.scrollUpperBound) {
                Fields.scrollTarget = Fields.scrollUpperBound;
            }
            UpdateScrollBar.updateBarPosition();
            return SpireReturn.Continue();
        }

        private static void updateBarPosition() {
            float percent = MathHelper.percentFromValueBetween((float)Fields.scrollLowerBound, (float)Fields.scrollUpperBound, (float)Fields.scrollPosition);
            Fields.scrollBar.parentScrolledToPercent(percent);
        }

        private static class Locator
        extends SpireInsertLocator {
            private Locator() {
            }

            public int[] Locate(CtBehavior ctBehavior) throws Exception {
                Matcher.FieldAccessMatcher matcher = new Matcher.FieldAccessMatcher(InputHelper.class, "justClickedLeft");
                return LineFinder.findInOrder((CtBehavior)ctBehavior, (Matcher)matcher);
            }
        }
    }

    @SpirePatch(clz=TipHelper.class, method="renderPowerTips")
    public static class RenderScrollingPowerTips {
        private static OrthographicCamera camera = null;

        public static void Prefix(float x, @ByRef float[] y, SpriteBatch sb, ArrayList<PowerTip> powerTips) {
            if (camera == null) {
                try {
                    Field f = CardCrawlGame.class.getDeclaredField("camera");
                    f.setAccessible(true);
                    camera = (OrthographicCamera)f.get(Gdx.app.getApplicationListener());
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (((Float)IsScrolling.isScrolling.get()).floatValue() > 0.0f) {
                Fields.scrollBar.changeHeight(((Float)IsScrolling.isScrolling.get()).floatValue() - 32.0f * Settings.scale);
                Fields.scrollBar.setCenter(x + 320.0f * Settings.scale + ScrollBar.TRACK_W / 2.0f, y[0] - ((Float)IsScrolling.isScrolling.get()).floatValue() / 2.0f + 32.0f * Settings.scale);
                sb.flush();
                Rectangle scissors = new Rectangle();
                Rectangle clipBounds = new Rectangle(1300.0f * Settings.scale, y[0] - ((Float)IsScrolling.isScrolling.get()).floatValue(), 320.0f * Settings.scale + ScrollBar.TRACK_W, ((Float)IsScrolling.isScrolling.get()).floatValue() + 32.0f * Settings.scale);
                ScissorStack.calculateScissors((Camera)camera, (Matrix4)sb.getTransformMatrix(), (Rectangle)clipBounds, (Rectangle)scissors);
                ScissorStack.pushScissors((Rectangle)scissors);
                y[0] = y[0] + Fields.scrollPosition;
            }
        }

        public static void Postfix(float x, float y, SpriteBatch sb, ArrayList<PowerTip> powerTips) {
            if (((Float)IsScrolling.isScrolling.get()).floatValue() > 0.0f) {
                if (camera != null) {
                    Fields.scrollBar.render(sb);
                    sb.flush();
                    ScissorStack.popScissors();
                }
                IsScrolling.isScrolling.set((Object)Float.valueOf(-1.0f));
            }
        }
    }

    private static class Fields {
        private static ScrollBar scrollBar = new ScrollBar(new ScrollListener(), 1300.0f * Settings.scale, 0.0f * Settings.scale, 440.0f * Settings.scale){

            public void reset() {
            }
        };
        private static float scrollPosition = 0.0f;
        private static float scrollTarget = 0.0f;
        private static float scrollLowerBound = 0.0f;
        private static float scrollUpperBound = 200.0f;
        private static boolean grabbedScreen = false;
        private static float grabStartY = 0.0f;

        private Fields() {
        }
    }

    private static class ScrollListener
    implements ScrollBarListener {
        private ScrollListener() {
        }

        public void scrolledUsingBar(float v) {
            Fields.scrollTarget = MathHelper.valueFromPercentBetween((float)Fields.scrollLowerBound, (float)Fields.scrollUpperBound, (float)v);
            UpdateScrollBar.updateBarPosition();
        }
    }
}

