/*
 * Decompiled with CFR 0.152.
 */
package basemod.devcommands.blight;

import basemod.DevConsole;
import basemod.devcommands.ConsoleCommand;
import basemod.devcommands.blight.Blight;
import com.megacrit.cardcrawl.blights.AbstractBlight;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.BlightHelper;
import java.util.ArrayList;
import java.util.Arrays;

public class BlightAdd
extends ConsoleCommand {
    public BlightAdd() {
        this.requiresPlayer = true;
        this.minExtraTokens = 1;
        this.maxExtraTokens = 1;
        this.simpleCheck = true;
    }

    @Override
    public void execute(String[] tokens, int depth) {
        CharSequence[] blightNameArray = Arrays.copyOfRange(tokens, 2, tokens.length);
        String blightName = String.join((CharSequence)" ", blightNameArray);
        AbstractBlight blight = AbstractDungeon.player.getBlight(blightName);
        if (blight != null) {
            blight.incrementUp();
            blight.stack();
        } else if (BlightHelper.getBlight((String)blightName) != null) {
            AbstractDungeon.getCurrRoom().spawnBlightAndObtain((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, BlightHelper.getBlight((String)blightName));
        } else {
            DevConsole.log("invalid blight ID");
        }
    }

    @Override
    public ArrayList<String> extraOptions(String[] tokens, int depth) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : BlightHelper.blights) {
            result.add(id.replace(' ', '_'));
        }
        return result;
    }

    @Override
    public void errorMsg() {
        Blight.cmdBlightHelp();
    }
}

