/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts;

import basemod.BaseMod;
import basemod.ReflectionHacks;
import basemod.helpers.BaseModCardTags;
import basemod.helpers.TooltipInfo;
import basemod.patches.com.megacrit.cardcrawl.screens.SingleCardViewPopup.TitleFontSize;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.evacipated.cardcrawl.modthespire.lib.SpireOverride;
import com.evacipated.cardcrawl.modthespire.lib.SpireSuper;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CustomCard
extends AbstractCard {
    public static HashMap<String, Texture> imgMap = new HashMap();
    public static final String PORTRAIT_ENDING = "_p";
    public String textureImg;
    public String textureOrbSmallImg = null;
    public String textureOrbLargeImg = null;
    public String textureBackgroundSmallImg = null;
    public String textureBackgroundLargeImg = null;
    public String textureBannerSmallImg = null;
    public String textureBannerLargeImg = null;
    private static Map<Class<? extends CustomCard>, BitmapFont> titleFontMap = new HashMap<Class<? extends CustomCard>, BitmapFont>();

    public static Texture getPortraitImage(CustomCard card) {
        return card.getPortraitImage();
    }

    private static void loadTextureFromString(String textureString) {
        if (!imgMap.containsKey(textureString)) {
            imgMap.put(textureString, ImageMaster.loadImage((String)textureString));
        }
    }

    private static Texture getTextureFromString(String textureString) {
        CustomCard.loadTextureFromString(textureString);
        return imgMap.get(textureString);
    }

    public AbstractCard makeCopy() {
        try {
            return (AbstractCard)((Object)((Object)this)).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("BaseMod failed to auto-generate makeCopy for card: " + this.cardID);
        }
    }

    public CustomCard(String id, String name, String img, int cost, String rawDescription, AbstractCard.CardType type, AbstractCard.CardColor color, AbstractCard.CardRarity rarity, AbstractCard.CardTarget target) {
        super(id, name, "status/beta", "status/beta", cost, rawDescription, type, color, rarity, target);
        this.textureImg = img;
        if (img != null) {
            this.loadCardImage(img);
        }
    }

    public CustomCard(String id, String name, RegionName img, int cost, String rawDescription, AbstractCard.CardType type, AbstractCard.CardColor color, AbstractCard.CardRarity rarity, AbstractCard.CardTarget target) {
        super(id, name, "status/beta", img.name, cost, rawDescription, type, color, rarity, target);
    }

    public Texture getOrbSmallTexture() {
        if (this.textureOrbSmallImg == null) {
            return BaseMod.getEnergyOrbTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureOrbSmallImg);
    }

    public Texture getOrbLargeTexture() {
        if (this.textureOrbLargeImg == null) {
            return BaseMod.getEnergyOrbPortraitTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureOrbLargeImg);
    }

    public void setOrbTexture(String orbSmallImg, String orbLargeImg) {
        this.textureOrbSmallImg = orbSmallImg;
        this.textureOrbLargeImg = orbLargeImg;
        CustomCard.loadTextureFromString(orbSmallImg);
        CustomCard.loadTextureFromString(orbLargeImg);
    }

    public Texture getBackgroundSmallTexture() {
        if (this.textureBackgroundSmallImg == null) {
            switch (this.type) {
                case ATTACK: {
                    return BaseMod.getAttackBgTexture(this.color);
                }
                case POWER: {
                    return BaseMod.getPowerBgTexture(this.color);
                }
            }
            return BaseMod.getSkillBgTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureBackgroundSmallImg);
    }

    public Texture getBackgroundLargeTexture() {
        if (this.textureBackgroundLargeImg == null) {
            switch (this.type) {
                case ATTACK: {
                    return BaseMod.getAttackBgPortraitTexture(this.color);
                }
                case POWER: {
                    return BaseMod.getPowerBgPortraitTexture(this.color);
                }
            }
            return BaseMod.getSkillBgPortraitTexture(this.color);
        }
        return CustomCard.getTextureFromString(this.textureBackgroundLargeImg);
    }

    public void setBackgroundTexture(String backgroundSmallImg, String backgroundLargeImg) {
        this.textureBackgroundSmallImg = backgroundSmallImg;
        this.textureBackgroundLargeImg = backgroundLargeImg;
        CustomCard.loadTextureFromString(backgroundSmallImg);
        CustomCard.loadTextureFromString(backgroundLargeImg);
    }

    public Texture getBannerSmallTexture() {
        if (this.textureBannerSmallImg == null) {
            return null;
        }
        return CustomCard.getTextureFromString(this.textureBannerSmallImg);
    }

    public Texture getBannerLargeTexture() {
        if (this.textureBannerLargeImg == null) {
            return null;
        }
        return CustomCard.getTextureFromString(this.textureBannerLargeImg);
    }

    public void setBannerTexture(String bannerSmallImg, String bannerLargeImg) {
        this.textureBannerSmallImg = bannerSmallImg;
        this.textureBannerLargeImg = bannerLargeImg;
        CustomCard.loadTextureFromString(bannerSmallImg);
        CustomCard.loadTextureFromString(bannerLargeImg);
    }

    public float calculateModifiedCardDamage(AbstractPlayer player, AbstractMonster mo, float tmp) {
        return tmp;
    }

    public float calculateModifiedCardDamage(AbstractPlayer player, float tmp) {
        return this.calculateModifiedCardDamage(player, null, tmp);
    }

    public void loadCardImage(String img) {
        Texture cardTexture;
        if (imgMap.containsKey(img)) {
            cardTexture = imgMap.get(img);
        } else {
            cardTexture = ImageMaster.loadImage((String)img);
            imgMap.put(img, cardTexture);
        }
        cardTexture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        int tw = cardTexture.getWidth();
        int th = cardTexture.getHeight();
        TextureAtlas.AtlasRegion cardImg = new TextureAtlas.AtlasRegion(cardTexture, 0, 0, tw, th);
        ReflectionHacks.setPrivateInherited((Object)this, CustomCard.class, "portrait", cardImg);
    }

    public List<TooltipInfo> getCustomTooltips() {
        return null;
    }

    public List<TooltipInfo> getCustomTooltipsTop() {
        return null;
    }

    public boolean isStrike() {
        return this.hasTag(BaseModCardTags.BASIC_STRIKE);
    }

    public boolean isDefend() {
        return this.hasTag(BaseModCardTags.BASIC_DEFEND);
    }

    public void unlock() {
        this.isLocked = false;
    }

    public float getTitleFontSize() {
        return -1.0f;
    }

    private BitmapFont getTitleFont() {
        if (this.getTitleFontSize() < 0.0f) {
            return null;
        }
        BitmapFont font = titleFontMap.get(((Object)((Object)this)).getClass());
        if (font == null) {
            font = CustomCard.generateTitleFont(this.getTitleFontSize());
            titleFontMap.put(((Object)((Object)this)).getClass(), font);
        }
        return font;
    }

    @SpireOverride
    protected void renderTitle(SpriteBatch sb) {
        BitmapFont titleFont = this.getTitleFont();
        if (titleFont == null) {
            SpireSuper.call((Object[])new Object[]{sb});
            return;
        }
        BitmapFont savedFont = FontHelper.cardTitleFont_small;
        FontHelper.cardTitleFont_small = titleFont;
        SpireSuper.call((Object[])new Object[]{sb});
        FontHelper.cardTitleFont_small = savedFont;
    }

    private static BitmapFont generateTitleFont(float size) {
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        param.minFilter = Texture.TextureFilter.Linear;
        param.magFilter = Texture.TextureFilter.Linear;
        param.hinting = FreeTypeFontGenerator.Hinting.Slight;
        param.spaceX = 0;
        param.kerning = true;
        param.borderColor = new Color(0.35f, 0.35f, 0.35f, 1.0f);
        param.borderWidth = 2.25f * Settings.scale;
        param.gamma = 0.9f;
        param.borderGamma = 0.9f;
        param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
        param.shadowOffsetX = Math.round(3.0f * Settings.scale);
        param.shadowOffsetY = Math.round(3.0f * Settings.scale);
        param.borderStraight = false;
        param.characters = "";
        param.incremental = true;
        param.size = Math.round(size * Settings.scale);
        FreeTypeFontGenerator g = new FreeTypeFontGenerator(TitleFontSize.fontFile);
        g.scaleForPixelHeight(param.size);
        BitmapFont font = g.generateFont(param);
        font.setUseIntegerPositions(false);
        font.getData().markupEnabled = true;
        if (LocalizedStrings.break_chars != null) {
            font.getData().breakChars = LocalizedStrings.break_chars.toCharArray();
        }
        return font;
    }

    protected Texture getPortraitImage() {
        Texture portraitTexture;
        if (this.textureImg == null) {
            return null;
        }
        int endingIndex = this.textureImg.lastIndexOf(".");
        String newPath = this.textureImg.substring(0, endingIndex) + PORTRAIT_ENDING + this.textureImg.substring(endingIndex);
        System.out.println("Finding texture: " + newPath);
        try {
            portraitTexture = ImageMaster.loadImage((String)newPath);
        }
        catch (Exception e) {
            portraitTexture = null;
        }
        return portraitTexture;
    }

    public static class RegionName {
        public final String name;

        public RegionName(String name) {
            this.name = name;
        }
    }
}

