/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.IUIElement;
import basemod.ModPanel;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import java.util.function.Consumer;

public class ModToggleButton
implements IUIElement {
    private static final float TOGGLE_Y_DELTA = 8.0f;
    private static final float TOGGLE_X_EXTEND = 12.0f;
    private static final float HB_WIDTH_EXTENDED = 200.0f;
    private Consumer<ModToggleButton> toggle;
    private Hitbox hb;
    private float x;
    private float y;
    private float w;
    private float h;
    public boolean enabled;
    public ModPanel parent;

    public ModToggleButton(float xPos, float yPos, ModPanel p, Consumer<ModToggleButton> c) {
        this(xPos, yPos, false, true, p, c);
    }

    public ModToggleButton(float xPos, float yPos, boolean enabled, boolean extendedHitbox, ModPanel p, Consumer<ModToggleButton> c) {
        this.x = xPos * Settings.scale;
        this.y = yPos * Settings.scale;
        this.w = ImageMaster.OPTION_TOGGLE.getWidth();
        this.h = ImageMaster.OPTION_TOGGLE.getHeight();
        this.hb = extendedHitbox ? new Hitbox(this.x - 12.0f * Settings.scale, this.y - 8.0f * Settings.scale, 200.0f * Settings.scale, this.h * Settings.scale) : new Hitbox(this.x, this.y - 8.0f * Settings.scale, this.w * Settings.scale, this.h * Settings.scale);
        this.enabled = enabled;
        this.parent = p;
        this.toggle = c;
    }

    public void wrapHitboxToText(String text, float lineWidth, float lineSpacing, BitmapFont font) {
        float tWidth = FontHelper.getSmartWidth((BitmapFont)font, (String)text, (float)lineWidth, (float)lineSpacing);
        this.hb.width = tWidth + this.h * Settings.scale + 12.0f;
    }

    @Override
    public void render(SpriteBatch sb) {
        if (this.hb.hovered) {
            sb.setColor(Color.CYAN);
        } else if (this.enabled) {
            sb.setColor(Color.LIGHT_GRAY);
        } else {
            sb.setColor(Color.WHITE);
        }
        sb.draw(ImageMaster.OPTION_TOGGLE, this.x, this.y, this.w * Settings.scale, this.h * Settings.scale);
        if (this.enabled) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.OPTION_TOGGLE_ON, this.x, this.y, this.w * Settings.scale, this.h * Settings.scale);
        }
        this.hb.render(sb);
    }

    @Override
    public void update() {
        this.hb.update();
        if (this.hb.justHovered) {
            CardCrawlGame.sound.playV("UI_HOVER", 0.75f);
        }
        if (this.hb.hovered && InputHelper.justClickedLeft) {
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.1f);
            this.hb.clickStarted = true;
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            this.onToggle();
        }
    }

    private void onToggle() {
        this.enabled = !this.enabled;
        this.toggle.accept(this);
    }

    @Override
    public int renderLayer() {
        return 1;
    }

    @Override
    public int updateOrder() {
        return 1;
    }
}

