/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.BaseMod;
import basemod.ModPanel;
import basemod.ModTextPanelInputHelper;
import basemod.interfaces.PostUpdateSubscriber;
import basemod.interfaces.RenderSubscriber;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import java.util.function.Consumer;

public class ModTextPanel
implements RenderSubscriber,
PostUpdateSubscriber {
    private String prevName = "";
    public static String textField;
    public Hitbox yesHb = null;
    public Hitbox noHb = null;
    public Consumer<ModTextPanel> confirm = null;
    public Consumer<ModTextPanel> cancel = null;
    public String defaultName;
    public String explanationText;
    public static final String CANCEL_TEXT = "Cancel";
    public static final String CONFIRM_TEXT = "Confirm";
    private static final int CONFIRM_W = 360;
    private static final int CONFIRM_H = 414;
    private static final int YES_W = 173;
    private static final int NO_W = 161;
    private static final int BUTTON_H = 74;
    private Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color uiColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private float animTimer = 0.0f;
    private float waitTimer = 0.0f;
    private static final float ANIM_TIME = 0.25f;
    public boolean shown = false;
    private static final float SCREEN_DARKNESS = 0.75f;
    private InputProcessor oldInputProcessor;
    private ModPanel panel;

    public ModTextPanel() {
        BaseMod.subscribe(this);
    }

    @Override
    public void receivePostUpdate() {
        if (!this.shown) {
            return;
        }
        if (Gdx.input.isKeyPressed(67) && !textField.equals("") && this.waitTimer <= 0.0f) {
            textField = textField.substring(0, textField.length() - 1);
            this.waitTimer = 0.09f;
        }
        if (this.waitTimer > 0.0f) {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
        }
        if (this.shown) {
            if (this.animTimer != 0.0f) {
                this.animTimer -= Gdx.graphics.getDeltaTime();
                if (this.animTimer < 0.0f) {
                    this.animTimer = 0.0f;
                }
                this.screenColor.a = Interpolation.fade.apply(0.75f, 0.0f, this.animTimer * 1.0f / 0.25f);
                this.uiColor.a = Interpolation.fade.apply(1.0f, 0.0f, this.animTimer * 1.0f / 0.25f);
            } else {
                this.updateYes();
                this.updateNo();
                if (Gdx.input.isKeyJustPressed(66)) {
                    this.confirm();
                } else if (InputHelper.pressedEscape) {
                    InputHelper.pressedEscape = false;
                    this.cancel();
                }
            }
        } else if (this.animTimer != 0.0f) {
            this.animTimer -= Gdx.graphics.getDeltaTime();
            if (this.animTimer < 0.0f) {
                this.animTimer = 0.0f;
            }
            this.screenColor.a = Interpolation.fade.apply(0.0f, 0.75f, this.animTimer * 1.0f / 0.25f);
            this.uiColor.a = Interpolation.fade.apply(0.0f, 1.0f, this.animTimer * 1.0f / 0.25f);
        }
    }

    private void updateYes() {
        this.yesHb.update();
        if (this.yesHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (InputHelper.justClickedLeft && this.yesHb.hovered) {
            CardCrawlGame.sound.play("UI_CLICK_1");
            this.yesHb.clickStarted = true;
        }
        if (this.yesHb.clicked) {
            this.yesHb.clicked = false;
            this.confirm();
        }
    }

    private void updateNo() {
        this.noHb.update();
        if (this.noHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (InputHelper.justClickedLeft && this.noHb.hovered) {
            CardCrawlGame.sound.play("UI_CLICK_1");
            this.noHb.clickStarted = true;
        }
        if (this.noHb.clicked) {
            this.noHb.clicked = false;
            this.cancel();
        }
    }

    public void show(ModPanel panel, String curName, String defaultValue, String explanationText, Consumer<ModTextPanel> cancel, Consumer<ModTextPanel> confirm) {
        this.panel = panel;
        panel.isUp = false;
        this.oldInputProcessor = Gdx.input.getInputProcessor();
        Gdx.input.setInputProcessor((InputProcessor)new ModTextPanelInputHelper());
        System.out.println("setting new input processor");
        if (this.yesHb == null) {
            this.yesHb = new Hitbox(160.0f * Settings.scale, 70.0f * Settings.scale);
        }
        if (this.noHb == null) {
            this.noHb = new Hitbox(160.0f * Settings.scale, 70.0f * Settings.scale);
        }
        this.yesHb.move(860.0f * Settings.scale, Settings.OPTION_Y - 118.0f * Settings.scale);
        this.noHb.move(1062.0f * Settings.scale, Settings.OPTION_Y - 118.0f * Settings.scale);
        this.shown = true;
        this.animTimer = 0.25f;
        textField = curName;
        this.prevName = curName;
        this.cancel = cancel;
        this.confirm = confirm;
        this.defaultName = defaultValue;
        this.explanationText = explanationText;
    }

    private void removeListeners() {
        this.confirm = null;
        this.cancel = null;
    }

    private void resetToSettings() {
        this.panel.isUp = true;
        CardCrawlGame.mainMenuScreen.darken();
        CardCrawlGame.mainMenuScreen.hideMenuButtons();
        CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.SETTINGS;
        CardCrawlGame.cancelButton.show("Close");
    }

    public void confirm() {
        if ((textField = textField.trim()).equals("")) {
            textField = this.defaultName;
        }
        this.confirm.accept(this);
        this.removeListeners();
        this.resetToSettings();
        this.yesHb.move(-1000.0f, -1000.0f);
        this.noHb.move(-1000.0f, -1000.0f);
        this.shown = false;
        this.animTimer = 0.25f;
        Gdx.input.setInputProcessor(this.oldInputProcessor);
    }

    public void cancel() {
        textField = this.prevName;
        if (textField.equals("")) {
            textField = this.defaultName;
        }
        this.cancel.accept(this);
        this.removeListeners();
        this.resetToSettings();
        this.yesHb.move(-1000.0f, -1000.0f);
        this.noHb.move(-1000.0f, -1000.0f);
        this.shown = false;
        this.animTimer = 0.25f;
        Gdx.input.setInputProcessor(this.oldInputProcessor);
    }

    @Override
    public void receiveRender(SpriteBatch sb) {
        if (!this.shown) {
            return;
        }
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        sb.setColor(this.uiColor);
        sb.draw(ImageMaster.OPTION_CONFIRM, (float)Settings.WIDTH / 2.0f - 180.0f, Settings.OPTION_Y - 207.0f, 180.0f, 207.0f, 360.0f, 414.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 360, 414, false, false);
        sb.draw(ImageMaster.RENAME_BOX, (float)Settings.WIDTH / 2.0f - 160.0f, Settings.OPTION_Y - 160.0f, 160.0f, 160.0f, 320.0f, 320.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 320, 320, false, false);
        FontHelper.renderSmartText((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_small, (String)textField, (float)((float)Settings.WIDTH / 2.0f - 120.0f * Settings.scale), (float)(Settings.OPTION_Y + 4.0f * Settings.scale), (float)100000.0f, (float)0.0f, (Color)this.uiColor);
        float tmpAlpha = (MathUtils.cosDeg((float)(System.currentTimeMillis() / 3L % 360L)) + 1.25f) / 3.0f * this.uiColor.a;
        FontHelper.renderSmartText((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_small, (String)"_", (float)((float)Settings.WIDTH / 2.0f - 122.0f * Settings.scale + FontHelper.getSmartWidth((BitmapFont)FontHelper.cardTitleFont_small, (String)textField, (float)1000000.0f, (float)0.0f)), (float)(Settings.OPTION_Y + 4.0f * Settings.scale), (float)100000.0f, (float)0.0f, (Color)new Color(1.0f, 1.0f, 1.0f, tmpAlpha));
        Color c = Settings.GOLD_COLOR.cpy();
        c.a = this.uiColor.a;
        FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont, (String)this.explanationText, (float)((float)Settings.WIDTH / 2.0f), (float)(Settings.OPTION_Y + 126.0f * Settings.scale), (Color)c);
        if (this.yesHb.clickStarted) {
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.uiColor.a * 0.9f));
            sb.draw(ImageMaster.OPTION_YES, (float)Settings.WIDTH / 2.0f - 86.5f - 100.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 86.5f, 37.0f, 173.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 173, 74, false, false);
            sb.setColor(new Color(this.uiColor));
        } else {
            sb.draw(ImageMaster.OPTION_YES, (float)Settings.WIDTH / 2.0f - 86.5f - 100.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 86.5f, 37.0f, 173.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 173, 74, false, false);
        }
        if (!this.yesHb.clickStarted && this.yesHb.hovered) {
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.uiColor.a * 0.25f));
            sb.setBlendFunction(770, 1);
            sb.draw(ImageMaster.OPTION_YES, (float)Settings.WIDTH / 2.0f - 86.5f - 100.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 86.5f, 37.0f, 173.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 173, 74, false, false);
            sb.setBlendFunction(770, 771);
            sb.setColor(this.uiColor);
        }
        c = this.yesHb.clickStarted ? Color.LIGHT_GRAY.cpy() : (this.yesHb.hovered ? Settings.CREAM_COLOR.cpy() : Settings.GOLD_COLOR.cpy());
        c.a = this.uiColor.a;
        FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_small, (String)CONFIRM_TEXT, (float)((float)Settings.WIDTH / 2.0f - 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)c, (float)1.0f);
        sb.draw(ImageMaster.OPTION_NO, (float)Settings.WIDTH / 2.0f - 80.5f + 106.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 80.5f, 37.0f, 161.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 161, 74, false, false);
        if (!this.noHb.clickStarted && this.noHb.hovered) {
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.uiColor.a * 0.25f));
            sb.setBlendFunction(770, 1);
            sb.draw(ImageMaster.OPTION_NO, (float)Settings.WIDTH / 2.0f - 80.5f + 106.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 80.5f, 37.0f, 161.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 161, 74, false, false);
            sb.setBlendFunction(770, 771);
            sb.setColor(this.uiColor);
        }
        c = this.noHb.clickStarted ? Color.LIGHT_GRAY.cpy() : (this.noHb.hovered ? Settings.CREAM_COLOR.cpy() : Settings.GOLD_COLOR.cpy());
        c.a = this.uiColor.a;
        FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_small, (String)CANCEL_TEXT, (float)((float)Settings.WIDTH / 2.0f + 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)c, (float)1.0f);
        if (this.shown) {
            this.yesHb.render(sb);
            this.noHb.render(sb);
        }
    }
}

