/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.IUIElement;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import java.util.function.Consumer;

public class ModColorDisplay
implements IUIElement {
    public float hbShrink = 16.0f;
    public float r = 1.0f;
    public float g = 1.0f;
    public float b = 1.0f;
    public float a = 1.0f;
    public float rOutline = 0.0f;
    public float gOutline = 0.0f;
    public float bOutline = 0.0f;
    public float aOutline = 1.0f;
    public float x;
    public float y;
    public float w;
    public float h;
    public Consumer<ModColorDisplay> click;
    public Texture texture;
    public Texture outline;
    private Hitbox hb;

    public ModColorDisplay(float x, float y, Texture texture, Texture outline, Consumer<ModColorDisplay> click) {
        this.texture = texture;
        this.outline = outline;
        this.x = x;
        this.y = y;
        this.w = texture.getWidth();
        this.h = texture.getHeight();
        this.click = click;
        float hbx = (x + this.hbShrink) * Settings.scale;
        float hby = (y + this.hbShrink) * Settings.scale;
        float hbw = (this.w - 2.0f * this.hbShrink) * Settings.scale;
        float hbh = (this.h - 2.0f * this.hbShrink) * Settings.scale;
        this.hb = new Hitbox(hbx, hby, hbw, hbh);
    }

    public ModColorDisplay(float x, float y, float hbShrink, Texture texture, Texture outline, Consumer<ModColorDisplay> click) {
        this(x, y, texture, outline, click);
        this.hbShrink = hbShrink;
        float hbx = (x + hbShrink) * Settings.scale;
        float hby = (y + hbShrink) * Settings.scale;
        float hbw = (this.w - 2.0f * hbShrink) * Settings.scale;
        float hbh = (this.h - 2.0f * hbShrink) * Settings.scale;
        this.hb = new Hitbox(hbx, hby, hbw, hbh);
    }

    @Override
    public void render(SpriteBatch sb) {
        if (this.outline != null) {
            sb.setColor(new Color(this.rOutline, this.gOutline, this.bOutline, this.aOutline));
            sb.draw(this.outline, this.x * Settings.scale, this.y * Settings.scale, this.w * Settings.scale, this.h * Settings.scale);
        }
        sb.setColor(new Color(this.r, this.g, this.b, this.a));
        sb.draw(this.texture, this.x * Settings.scale, this.y * Settings.scale, this.w * Settings.scale, this.h * Settings.scale);
        this.hb.render(sb);
    }

    @Override
    public void update() {
        this.hb.update();
        if (this.hb.justHovered) {
            CardCrawlGame.sound.playV("UI_HOVER", 0.75f);
        }
        if (this.hb.hovered && InputHelper.justClickedLeft) {
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.1f);
            this.hb.clickStarted = true;
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            this.onClick();
        }
    }

    private void onClick() {
        this.click.accept(this);
    }

    @Override
    public int renderLayer() {
        return 1;
    }

    @Override
    public int updateOrder() {
        return 1;
    }
}

