/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.BaseMod;
import basemod.DevConsole;
import basemod.interfaces.PostUpdateSubscriber;
import basemod.interfaces.RenderSubscriber;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Bezier;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.powers.AbstractPower;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsoleTargetedPower
implements RenderSubscriber,
PostUpdateSubscriber {
    public static final Logger logger = LogManager.getLogger((String)DevConsole.class.getName());
    private Class<?> powerToApply;
    private AbstractCreature hoveredCreature;
    private Vector2 controlPoint;
    private float arrowScale;
    private float arrowScaleTimer;
    private Vector2[] points = new Vector2[20];
    private boolean isHidden;
    private int amount;

    public ConsoleTargetedPower(Class<?> power, int amount) {
        this.powerToApply = power;
        this.amount = amount;
        BaseMod.subscribe(this);
        this.isHidden = false;
        GameCursor.hidden = true;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector2();
        }
    }

    private void close() {
        this.isHidden = true;
    }

    private AbstractPower instantiatePower() {
        try {
            return (AbstractPower)this.powerToApply.getConstructor(AbstractCreature.class, Integer.TYPE, Boolean.TYPE).newInstance(this.hoveredCreature, this.amount, false);
        }
        catch (Exception exception) {
            try {
                return (AbstractPower)this.powerToApply.getConstructor(AbstractCreature.class, AbstractCreature.class, Integer.TYPE).newInstance(this.hoveredCreature, AbstractDungeon.player, this.amount);
            }
            catch (Exception exception2) {
                try {
                    return (AbstractPower)this.powerToApply.getConstructor(AbstractCreature.class, Integer.TYPE).newInstance(this.hoveredCreature, this.amount);
                }
                catch (Exception exception3) {
                    try {
                        return (AbstractPower)this.powerToApply.getConstructor(AbstractCreature.class).newInstance(this.hoveredCreature);
                    }
                    catch (Exception exception4) {
                        logger.info("Failed to instantiate " + this.powerToApply);
                        return null;
                    }
                }
            }
        }
    }

    private void updateTargetMode() {
        if (InputHelper.justClickedRight || AbstractDungeon.isScreenUp || (float)InputHelper.mY > (float)Settings.HEIGHT - 80.0f * Settings.scale || AbstractDungeon.player.hoveredCard != null || (float)InputHelper.mY < 140.0f * Settings.scale) {
            GameCursor.hidden = false;
            this.close();
        }
        this.hoveredCreature = null;
        for (AbstractCreature m : AbstractDungeon.getMonsters().monsters) {
            if (!m.hb.hovered || m.isDying) continue;
            this.hoveredCreature = m;
            break;
        }
        AbstractPlayer m = AbstractDungeon.player;
        if (m.hb.hovered && !m.isDying) {
            this.hoveredCreature = m;
        }
        if (InputHelper.justClickedLeft) {
            AbstractPower power;
            InputHelper.justClickedLeft = false;
            if (this.hoveredCreature != null && (power = this.instantiatePower()) != null) {
                AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new ApplyPowerAction(this.hoveredCreature, (AbstractCreature)AbstractDungeon.player, power, this.amount));
            }
            GameCursor.hidden = false;
            this.close();
        }
    }

    @Override
    public void receiveRender(SpriteBatch sb) {
        this.render(sb);
    }

    public void render(SpriteBatch sb) {
        if (!this.isHidden) {
            this.renderTargetingUi(sb);
            if (this.hoveredCreature != null) {
                this.hoveredCreature.renderReticle(sb);
            }
        }
    }

    public void renderTargetingUi(SpriteBatch sb) {
        float x = InputHelper.mX;
        float y = InputHelper.mY;
        this.controlPoint = new Vector2(AbstractDungeon.player.animX - (x - AbstractDungeon.player.animX) / 4.0f, AbstractDungeon.player.animY + (y - AbstractDungeon.player.animY - 40.0f * Settings.scale) / 2.0f);
        if (this.hoveredCreature == null) {
            this.arrowScale = Settings.scale;
            this.arrowScaleTimer = 0.0f;
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            this.arrowScaleTimer += Gdx.graphics.getDeltaTime();
            if (this.arrowScaleTimer > 1.0f) {
                this.arrowScaleTimer = 1.0f;
            }
            this.arrowScale = Interpolation.elasticOut.apply(Settings.scale, Settings.scale * 1.2f, this.arrowScaleTimer);
            sb.setColor(new Color(1.0f, 0.2f, 0.3f, 1.0f));
        }
        Vector2 tmp = new Vector2(this.controlPoint.x - x, this.controlPoint.y - y);
        tmp.nor();
        this.drawCurvedLine(sb, new Vector2(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY - 40.0f * Settings.scale), new Vector2(x, y), this.controlPoint);
        sb.draw(ImageMaster.TARGET_UI_ARROW, x - 128.0f, y - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.arrowScale, this.arrowScale, tmp.angle() + 90.0f, 0, 0, 256, 256, false, false);
    }

    private void drawCurvedLine(SpriteBatch sb, Vector2 start, Vector2 end, Vector2 control) {
        float radius = 7.0f * Settings.scale;
        for (int i = 0; i < this.points.length - 1; ++i) {
            float angle;
            Vector2 tmp;
            this.points[i] = (Vector2)Bezier.quadratic((Vector)this.points[i], (float)((float)i / 20.0f), (Vector)start, (Vector)control, (Vector)end, (Vector)new Vector2());
            radius += 0.4f * Settings.scale;
            if (i != 0) {
                tmp = new Vector2(this.points[i - 1].x - this.points[i].x, this.points[i - 1].y - this.points[i].y);
                angle = tmp.nor().angle() + 90.0f;
            } else {
                tmp = new Vector2(this.controlPoint.x - this.points[i].x, this.controlPoint.y - this.points[i].y);
                angle = tmp.nor().angle() + 270.0f;
            }
            sb.draw(ImageMaster.TARGET_UI_CIRCLE, this.points[i].x - 64.0f, this.points[i].y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, radius / 18.0f, radius / 18.0f, angle, 0, 0, 128, 128, false, false);
        }
    }

    @Override
    public void receivePostUpdate() {
        if (!this.isHidden) {
            this.updateTargetMode();
        }
    }
}

