/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.input.InputHelper;

public abstract class ClickableUIElement {
    protected Texture image;
    protected TextureAtlas.AtlasRegion region;
    protected float x;
    protected float y;
    protected float hb_w;
    protected float hb_h;
    protected Hitbox hitbox;
    protected float angle;
    protected Color tint;
    private boolean clickable;

    public ClickableUIElement(Texture image) {
        this(image, 0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight());
    }

    public ClickableUIElement(TextureAtlas.AtlasRegion region) {
        this(region, 0.0f, 0.0f, (float)region.packedWidth, (float)region.packedHeight);
    }

    public ClickableUIElement(TextureAtlas.AtlasRegion region, float x, float y, float hb_w, float hb_h) {
        this((Texture)null, x, y, hb_w, hb_h);
        this.region = region;
    }

    public ClickableUIElement(Texture image, float x, float y, float hb_w, float hb_h) {
        this.image = image;
        this.x = x * Settings.scale;
        this.y = y * Settings.scale;
        if (y < 0.0f) {
            this.y += (float)Settings.HEIGHT;
        }
        this.hb_w = hb_w * Settings.scale;
        this.hb_h = hb_h * Settings.scale;
        this.hitbox = new Hitbox(this.x, this.y, this.hb_w, this.hb_h);
        this.angle = 0.0f;
        this.tint = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.clickable = true;
    }

    public void update() {
        this.updateHitbox();
        if (this.hitbox.hovered) {
            this.onHover();
        } else {
            this.onUnhover();
        }
        if (this.hitbox.hovered && InputHelper.justClickedLeft && this.clickable) {
            this.onClick();
        }
    }

    public void setX(float x) {
        this.x = x;
        this.hitbox.x = x;
    }

    public void setY(float y) {
        if (y < 0.0f) {
            y += (float)Settings.HEIGHT;
        }
        this.y = y;
        this.hitbox.y = y;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    protected void updateHitbox() {
        this.hitbox.update();
    }

    public void render(SpriteBatch sb) {
        this.render(sb, Color.WHITE);
    }

    public void render(SpriteBatch sb, Color color) {
        sb.setColor(color);
        if (this.image != null) {
            float halfWidth = (float)this.image.getWidth() / 2.0f;
            float halfHeight = (float)this.image.getHeight() / 2.0f;
            sb.draw(this.image, this.x - halfWidth + halfWidth * Settings.scale, this.y - halfHeight + halfHeight * Settings.scale, halfWidth, halfHeight, (float)this.image.getWidth(), (float)this.image.getHeight(), Settings.scale, Settings.scale, this.angle, 0, 0, this.image.getWidth(), this.image.getHeight(), false, false);
            if (this.tint.a > 0.0f) {
                sb.setBlendFunction(770, 1);
                sb.setColor(this.tint);
                sb.draw(this.image, this.x - halfWidth + halfWidth * Settings.scale, this.y - halfHeight + halfHeight * Settings.scale, halfWidth, halfHeight, (float)this.image.getWidth(), (float)this.image.getHeight(), Settings.scale, Settings.scale, this.angle, 0, 0, this.image.getWidth(), this.image.getHeight(), false, false);
                sb.setBlendFunction(770, 771);
            }
        } else if (this.region != null) {
            float halfWidth = (float)this.region.packedWidth / 2.0f;
            float halfHeight = (float)this.region.packedHeight / 2.0f;
            sb.draw((TextureRegion)this.region, this.x - halfWidth + halfWidth * Settings.scale, this.y - halfHeight + halfHeight * Settings.scale, halfWidth, halfHeight, (float)this.region.packedWidth, (float)this.region.packedHeight, Settings.scale, Settings.scale, this.angle);
            if (this.tint.a > 0.0f) {
                sb.setBlendFunction(770, 1);
                sb.setColor(this.tint);
                sb.draw((TextureRegion)this.region, this.x - halfWidth + halfWidth * Settings.scale, this.y - halfHeight + halfHeight * Settings.scale, halfWidth, halfHeight, (float)this.region.packedWidth, (float)this.region.packedHeight, Settings.scale, Settings.scale, this.angle);
                sb.setBlendFunction(770, 771);
            }
        }
        this.renderHitbox(sb);
    }

    protected void renderHitbox(SpriteBatch sb) {
        this.hitbox.render(sb);
    }

    protected abstract void onHover();

    protected abstract void onUnhover();

    protected abstract void onClick();
}

