/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.Animation;
import com.brashmonkey.spriter.Curve;
import com.brashmonkey.spriter.Data;
import com.brashmonkey.spriter.Dimension;
import com.brashmonkey.spriter.Entity;
import com.brashmonkey.spriter.File;
import com.brashmonkey.spriter.FileReference;
import com.brashmonkey.spriter.Folder;
import com.brashmonkey.spriter.Mainline;
import com.brashmonkey.spriter.Point;
import com.brashmonkey.spriter.Timeline;
import com.brashmonkey.spriter.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;

public class SCMLReader {
    protected Data data;

    public SCMLReader(InputStream stream) {
        this.data = this.load(stream);
    }

    public SCMLReader(String xml) {
        this.data = this.load(xml);
    }

    protected Data load(String xml) {
        XmlReader reader = new XmlReader();
        XmlReader.Element root = reader.parse(xml);
        ArrayList<XmlReader.Element> folders = root.getChildrenByName("folder");
        ArrayList<XmlReader.Element> entities = root.getChildrenByName("entity");
        this.data = new Data(root.get("scml_version"), root.get("generator"), root.get("generator_version"), new ArrayList<Folder>(folders.size()), new ArrayList<Entity>(entities.size()));
        this.loadFolders(folders);
        this.loadEntities(entities);
        return this.data;
    }

    protected Data load(InputStream stream) {
        XmlReader reader = new XmlReader();
        try {
            XmlReader.Element root = reader.parse(stream);
            ArrayList<XmlReader.Element> folders = root.getChildrenByName("folder");
            ArrayList<XmlReader.Element> entities = root.getChildrenByName("entity");
            this.data = new Data(root.get("scml_version"), root.get("generator"), root.get("generator_version"), new ArrayList<Folder>(folders.size()), new ArrayList<Entity>(entities.size()));
            this.loadFolders(folders);
            this.loadEntities(entities);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.data;
    }

    protected void loadFolders(ArrayList<XmlReader.Element> folders) {
        for (int i = 0; i < folders.size(); ++i) {
            XmlReader.Element repo = folders.get(i);
            Folder folder = new Folder(repo.getInt("id"), repo.get("name", "no_name_" + i));
            this.loadFiles(repo.getChildrenByName("file"), folder);
            this.data.addFolder(folder);
        }
    }

    protected void loadFiles(ArrayList<XmlReader.Element> files, Folder folder) {
        for (int j = 0; j < files.size(); ++j) {
            XmlReader.Element f = files.get(j);
            File file = new File(f.getInt("id"), f.get("name"), new Dimension(f.getInt("width", 0), f.getInt("height", 0)), new Point(f.getFloat("pivot_x", 0.0f), f.getFloat("pivot_y", 1.0f)));
            folder.addFile(file);
        }
    }

    protected void loadEntities(ArrayList<XmlReader.Element> entities) {
        for (int i = 0; i < entities.size(); ++i) {
            XmlReader.Element e = entities.get(i);
            ArrayList<XmlReader.Element> infos = e.getChildrenByName("obj_info");
            ArrayList<XmlReader.Element> charMaps = e.getChildrenByName("character_map");
            ArrayList<XmlReader.Element> animations = e.getChildrenByName("animation");
            Entity entity = new Entity(e.getInt("id"), e.get("name"), new ArrayList<Animation>(animations.size()), new ArrayList<Entity.CharacterMap>(charMaps.size()), new ArrayList<Entity.ObjectInfo>(infos.size()));
            this.data.addEntity(entity);
            this.loadObjectInfos(infos, entity);
            this.loadCharacterMaps(charMaps, entity);
            this.loadAnimations(animations, entity);
        }
    }

    protected void loadObjectInfos(ArrayList<XmlReader.Element> infos, Entity entity) {
        for (int i = 0; i < infos.size(); ++i) {
            XmlReader.Element info = infos.get(i);
            Entity.ObjectInfo objInfo = new Entity.ObjectInfo(info.get("name", "info" + i), Entity.ObjectType.getObjectInfoFor(info.get("type", "")), new Dimension(info.getFloat("w", 0.0f), info.getFloat("h", 0.0f)));
            entity.addInfo(objInfo);
            XmlReader.Element frames = info.getChildByName("frames");
            if (frames == null) continue;
            ArrayList<XmlReader.Element> frameIndices = frames.getChildrenByName("i");
            for (XmlReader.Element index : frameIndices) {
                int folder = index.getInt("folder", 0);
                int file = index.getInt("file", 0);
                objInfo.frames.add(new FileReference(folder, file));
            }
        }
    }

    protected void loadCharacterMaps(ArrayList<XmlReader.Element> maps, Entity entity) {
        for (int i = 0; i < maps.size(); ++i) {
            XmlReader.Element map = maps.get(i);
            Entity.CharacterMap charMap = new Entity.CharacterMap(map.getInt("id"), map.getAttribute("name", "charMap" + i));
            entity.addCharacterMap(charMap);
            ArrayList<XmlReader.Element> mappings = map.getChildrenByName("map");
            for (XmlReader.Element mapping : mappings) {
                int folder = mapping.getInt("folder");
                int file = mapping.getInt("file");
                charMap.put(new FileReference(folder, file), new FileReference(mapping.getInt("target_folder", folder), mapping.getInt("target_file", file)));
            }
        }
    }

    protected void loadAnimations(ArrayList<XmlReader.Element> animations, Entity entity) {
        for (int i = 0; i < animations.size(); ++i) {
            XmlReader.Element a = animations.get(i);
            ArrayList<XmlReader.Element> timelines = a.getChildrenByName("timeline");
            Animation animation = new Animation(a.getInt("id"), a.get("name"), a.getInt("length"), a.getBoolean("looping", true), new ArrayList<Timeline>(timelines.size()));
            entity.addAnimation(animation);
            this.loadMainline(a.getChildByName("mainline"), animation);
            this.loadTimelines(timelines, animation, entity);
            animation.prepare();
        }
    }

    protected void loadMainline(XmlReader.Element mainline, Animation animation) {
        Mainline main = animation.mainline;
        this.loadMainlineKeys(mainline.getChildrenByName("key"), main);
    }

    protected void loadMainlineKeys(ArrayList<XmlReader.Element> keys, Mainline main) {
        for (int i = 0; i < keys.size(); ++i) {
            XmlReader.Element k = keys.get(i);
            ArrayList<XmlReader.Element> objectRefs = k.getChildrenByName("object_ref");
            ArrayList<XmlReader.Element> boneRefs = k.getChildrenByName("bone_ref");
            Curve curve = new Curve();
            curve.setType(Curve.getType(k.get("curve_type", "linear")));
            curve.constraints.set(k.getFloat("c1", 0.0f), k.getFloat("c2", 0.0f), k.getFloat("c3", 0.0f), k.getFloat("c4", 0.0f));
            Mainline.Key key = new Mainline.Key(k.getInt("id"), k.getInt("time", 0), curve, new ArrayList<Mainline.Key.BoneRef>(boneRefs.size()), new ArrayList<Mainline.Key.ObjectRef>(objectRefs.size()));
            main.keys.add(key);
            this.loadRefs(objectRefs, boneRefs, key);
        }
    }

    protected void loadRefs(ArrayList<XmlReader.Element> objectRefs, ArrayList<XmlReader.Element> boneRefs, Mainline.Key key) {
        for (XmlReader.Element e : boneRefs) {
            Mainline.Key.BoneRef boneRef = new Mainline.Key.BoneRef(e.getInt("id"), e.getInt("timeline"), e.getInt("key"), key.getBoneRef(e.getInt("parent", -1)));
            key.addBoneRef(boneRef);
        }
        for (XmlReader.Element o : objectRefs) {
            Mainline.Key.ObjectRef objectRef = new Mainline.Key.ObjectRef(o.getInt("id"), o.getInt("timeline"), o.getInt("key"), key.getBoneRef(o.getInt("parent", -1)), o.getInt("z_index", 0));
            key.addObjectRef(objectRef);
        }
        Collections.sort(key.objectRefs);
    }

    protected void loadTimelines(ArrayList<XmlReader.Element> timelines, Animation animation, Entity entity) {
        for (int i = 0; i < timelines.size(); ++i) {
            XmlReader.Element t = timelines.get(i);
            ArrayList<XmlReader.Element> keys = timelines.get(i).getChildrenByName("key");
            String name = t.get("name");
            Entity.ObjectType type = Entity.ObjectType.getObjectInfoFor(t.get("object_type", "sprite"));
            Entity.ObjectInfo info = entity.getInfo(name);
            if (info == null) {
                info = new Entity.ObjectInfo(name, type, new Dimension(0.0f, 0.0f));
            }
            Timeline timeline = new Timeline(t.getInt("id"), name, info, new ArrayList<Timeline.Key>(keys.size()));
            animation.addTimeline(timeline);
            this.loadTimelineKeys(keys, timeline);
        }
    }

    protected void loadTimelineKeys(ArrayList<XmlReader.Element> keys, Timeline timeline) {
        for (int i = 0; i < keys.size(); ++i) {
            XmlReader.Element k = keys.get(i);
            Curve curve = new Curve();
            curve.setType(Curve.getType(k.get("curve_type", "linear")));
            curve.constraints.set(k.getFloat("c1", 0.0f), k.getFloat("c2", 0.0f), k.getFloat("c3", 0.0f), k.getFloat("c4", 0.0f));
            Timeline.Key key = new Timeline.Key(k.getInt("id"), k.getInt("time", 0), k.getInt("spin", 1), curve);
            XmlReader.Element obj = k.getChildByName("bone");
            if (obj == null) {
                obj = k.getChildByName("object");
            }
            Point position = new Point(obj.getFloat("x", 0.0f), obj.getFloat("y", 0.0f));
            Point scale = new Point(obj.getFloat("scale_x", 1.0f), obj.getFloat("scale_y", 1.0f));
            Point pivot = new Point(obj.getFloat("pivot_x", 0.0f), obj.getFloat("pivot_y", timeline.objectInfo.type == Entity.ObjectType.Bone ? 0.5f : 1.0f));
            float angle = obj.getFloat("angle", 0.0f);
            float alpha = 1.0f;
            int folder = -1;
            int file = -1;
            if (obj.getName().equals("object") && timeline.objectInfo.type == Entity.ObjectType.Sprite) {
                alpha = obj.getFloat("a", 1.0f);
                folder = obj.getInt("folder", -1);
                file = obj.getInt("file", -1);
                File f = this.data.getFolder(folder).getFile(file);
                pivot = new Point(obj.getFloat("pivot_x", f.pivot.x), obj.getFloat("pivot_y", f.pivot.y));
                timeline.objectInfo.size.set(f.size);
            }
            Timeline.Key.Object object = obj.getName().equals("bone") ? new Timeline.Key.Object(position, scale, pivot, angle, alpha, new FileReference(folder, file)) : new Timeline.Key.Object(position, scale, pivot, angle, alpha, new FileReference(folder, file));
            key.setObject(object);
            timeline.addKey(key);
        }
    }

    public Data getData() {
        return this.data;
    }
}

