/*
 * Decompiled with CFR 0.152.
 */
package com.brashmonkey.spriter;

import com.brashmonkey.spriter.File;
import java.util.ArrayList;
import java.util.List;

public class Folder {
    final List<File> files;
    public final Integer id;
    public final String name;

    Folder(int id, String name) {
        this(id, name, new ArrayList<File>());
    }

    Folder(int id, String name, List<File> files) {
        this.id = id;
        this.name = name;
        this.files = files;
    }

    void addFile(File file) {
        this.files.add(file);
    }

    public File getFile(int index) {
        return this.files.get(index);
    }

    public File getFile(String name) {
        int index = this.getFileIndex(name);
        if (index >= 0) {
            return this.getFile(index);
        }
        return null;
    }

    int getFileIndex(String name) {
        for (File file : this.files) {
            if (!file.name.equals(name)) continue;
            return file.id;
        }
        return -1;
    }

    public String toString() {
        String toReturn = this.getClass().getSimpleName() + "|[id: " + this.id + ", name: " + this.name;
        for (File file : this.files) {
            toReturn = toReturn + "\n" + file;
        }
        toReturn = toReturn + "]";
        return toReturn;
    }
}

