/*
 * Decompiled with CFR 0.152.
 */
package basemod.abstracts.cardbuilder;

import basemod.abstracts.CustomCard;
import basemod.abstracts.cardbuilder.actionbuilder.ActionBuilder;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.DamageAllEnemiesAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.utility.ExhaustAllEtherealAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class CardBasic
extends CustomCard {
    public static final int BASE_MAX_UPGRADES = 1;
    public static final int BASE_COST = -1;
    public static final String BASE_DESCRIPTION = "";
    protected boolean doDamage = false;
    protected boolean doBlock = false;
    protected boolean doMagicNumber = false;
    protected boolean doCost = false;
    protected boolean doEthereal = false;
    protected boolean doExhaust = false;
    protected boolean hasDescription = false;
    protected String description;
    protected int upgradeDamageAmt;
    protected int upgradeBlockAmt;
    protected int upgradeMagicNumberAmt;
    protected int upgradedCost;
    protected boolean upgradedEthereal;
    protected boolean upgradedExhaust;
    protected boolean doUpgradeDamage = false;
    protected boolean doUpgradeBlock = false;
    protected boolean doUpgradeMagicNumber = false;
    protected boolean doUpgradeCost = false;
    protected boolean doUpgradeEthereal = false;
    protected boolean doUpgradeExhaust = false;
    protected int upgradeCount = 0;
    protected int maxUpgrades = 1;
    protected List<ActionBuilder> actions;
    protected AbstractGameAction.AttackEffect attackEffect;

    public CardBasic(String cardId, String name, String img, AbstractCard.CardType cardType, AbstractCard.CardColor cardColor, AbstractCard.CardRarity rarity, AbstractCard.CardTarget target) {
        super(cardId, name, img, -1, BASE_DESCRIPTION, cardType, cardColor, rarity, target);
        if (target == AbstractCard.CardTarget.ALL_ENEMY) {
            this.isMultiDamage = true;
        }
        this.actions = new ArrayList<ActionBuilder>();
    }

    public CardBasic end() {
        this.rawDescription = this.buildDescription();
        this.initializeDescription();
        return this;
    }

    public CardBasic setDescription(String description) {
        this.description = description;
        this.hasDescription = true;
        return this;
    }

    public CardBasic setDamage(int damage) {
        this.baseDamage = damage;
        this.doDamage = true;
        return this;
    }

    public CardBasic setUpgradeDamageAmt(int damage) {
        this.upgradeDamageAmt = damage;
        this.doUpgradeDamage = true;
        return this;
    }

    public CardBasic setBlock(int block) {
        this.baseBlock = block;
        this.doBlock = true;
        return this;
    }

    public CardBasic setUpgradeBlockAmt(int block) {
        this.upgradeBlockAmt = block;
        this.doUpgradeBlock = true;
        return this;
    }

    public CardBasic setMagicNumber(int number) {
        this.magicNumber = this.baseMagicNumber = number;
        this.doMagicNumber = true;
        return this;
    }

    public CardBasic setUpgradeMagicNumberAmt(int number) {
        this.upgradeMagicNumberAmt = number;
        this.doUpgradeMagicNumber = true;
        return this;
    }

    public CardBasic setCost(int cost) {
        this.costForTurn = this.cost = cost;
        this.doCost = true;
        return this;
    }

    public CardBasic setUpgradedCost(int cost) {
        this.upgradedCost = cost;
        this.doUpgradeCost = true;
        return this;
    }

    public CardBasic setEthereal(boolean isEthereal) {
        this.isEthereal = isEthereal;
        this.doEthereal = true;
        return this;
    }

    public CardBasic setUpgradedEthereal(boolean isEthereal) {
        this.upgradedEthereal = isEthereal;
        this.doUpgradeEthereal = true;
        return this;
    }

    public CardBasic setExhaust(boolean exhaust) {
        this.exhaust = exhaust;
        this.doExhaust = true;
        return this;
    }

    public CardBasic setUpgradedExhaust(boolean isExhaust) {
        this.upgradedExhaust = isExhaust;
        this.doUpgradeExhaust = true;
        return this;
    }

    public CardBasic addAction(ActionBuilder builder) {
        this.actions.add(builder);
        return this;
    }

    public CardBasic setAttackEffect(AbstractGameAction.AttackEffect effect) {
        this.attackEffect = effect;
        return this;
    }

    private String buildDescription() {
        if (this.hasDescription) {
            return this.description;
        }
        StringBuilder description = new StringBuilder();
        description.append(this.isEthereal ? "Ethereal. NL " : BASE_DESCRIPTION).append(this.doDamage ? "Deal !D! damage. " : BASE_DESCRIPTION).append(this.doBlock ? "Gain !B! block. " : BASE_DESCRIPTION);
        for (ActionBuilder builder : this.actions) {
            description.append(builder.description(this));
        }
        description.append(this.exhaust ? " NL Exhaust." : BASE_DESCRIPTION);
        return description.toString();
    }

    public boolean canUpgrade() {
        return this.upgradeCount < this.maxUpgrades;
    }

    public void upgrade() {
        if (!this.canUpgrade()) {
            return;
        }
        this.upgradeName();
        if (this.doUpgradeDamage) {
            this.upgradeDamage(this.upgradeDamageAmt);
        }
        if (this.doUpgradeBlock) {
            this.upgradeBlock(this.upgradeBlockAmt);
        }
        if (this.doUpgradeMagicNumber) {
            this.upgradeMagicNumber(this.upgradeMagicNumberAmt);
        }
        if (this.doUpgradeCost) {
            this.upgradeBaseCost(this.upgradedCost);
        }
        if (this.doUpgradeEthereal) {
            this.isEthereal = this.upgradedEthereal;
        }
        if (this.doUpgradeExhaust) {
            this.exhaust = this.upgradedExhaust;
        }
        this.rawDescription = this.buildDescription();
        this.initializeDescription();
        ++this.upgradeCount;
    }

    private CardBasic apply(boolean doApply, Supplier<CardBasic> applyFunc) {
        return doApply ? applyFunc.get() : this;
    }

    @Override
    public AbstractCard makeCopy() {
        CardBasic card = new CardBasic(this.cardID, this.name, this.textureImg, this.type, this.color, this.rarity, this.target);
        card.apply(this.hasDescription, () -> card.setDescription(this.description)).apply(this.doDamage, () -> card.setDamage(this.baseDamage)).apply(this.doBlock, () -> card.setBlock(this.baseBlock)).apply(this.doMagicNumber, () -> card.setMagicNumber(this.magicNumber)).apply(this.doCost, () -> card.setCost(this.cost)).apply(this.doEthereal, () -> card.setEthereal(this.isEthereal)).apply(this.doExhaust, () -> card.setExhaust(this.exhaust)).apply(this.doUpgradeDamage, () -> card.setUpgradeDamageAmt(this.upgradeDamageAmt)).apply(this.doUpgradeBlock, () -> card.setUpgradeBlockAmt(this.upgradeBlockAmt)).apply(this.doUpgradeMagicNumber, () -> card.setUpgradeMagicNumberAmt(this.upgradeMagicNumberAmt)).apply(this.doUpgradeCost, () -> card.setUpgradedCost(this.upgradedCost)).apply(this.doUpgradeEthereal, () -> card.setUpgradedEthereal(this.upgradedEthereal)).apply(this.doUpgradeExhaust, () -> card.setUpgradedExhaust(this.upgradedExhaust));
        for (ActionBuilder builder : this.actions) {
            card.addAction(builder);
        }
        return card.end();
    }

    public void triggerOnEndOfPlayerTurn() {
        AbstractDungeon.actionManager.addToTop((AbstractGameAction)new ExhaustAllEtherealAction());
    }

    public void use(AbstractPlayer player, AbstractMonster monster) {
        if (this.damage > 0) {
            if (this.target == AbstractCard.CardTarget.ENEMY) {
                AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new DamageAction((AbstractCreature)monster, new DamageInfo((AbstractCreature)player, this.damage, this.damageTypeForTurn), this.attackEffect));
            }
            if (this.target == AbstractCard.CardTarget.ALL_ENEMY) {
                AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new DamageAllEnemiesAction((AbstractCreature)player, this.multiDamage, this.damageTypeForTurn, this.attackEffect));
            }
        }
        if (this.block > 0) {
            AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new GainBlockAction((AbstractCreature)player, (AbstractCreature)player, this.block));
        }
        if (!this.actions.isEmpty()) {
            for (ActionBuilder builder : this.actions) {
                if (builder.toTop()) {
                    AbstractDungeon.actionManager.addToTop(builder.buildAction(this, player, monster));
                    continue;
                }
                AbstractDungeon.actionManager.addToBottom(builder.buildAction(this, player, monster));
            }
        }
    }
}

