/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.BaseMod;
import basemod.IUIElement;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.charSelect.CharacterSelectScreen;
import java.util.ArrayList;

public class CustomCharacterSelectScreen
extends CharacterSelectScreen {
    private static final int optionsPerIndex = 4;
    private int selectIndex = 0;
    private int maxSelectIndex;
    private int optionsIndex;
    private LeftOptionsButton leftArrow = new LeftOptionsButton("img/tinyLeftArrow.png", (int)(425.0f * Settings.scale), (int)(180.0f * Settings.scale));
    private RightOptionsButton rightArrow = new RightOptionsButton("img/tinyRightArrow.png", (int)(1425.0f * Settings.scale), (int)(180.0f * Settings.scale));
    private ArrayList<CharacterOption> allOptions;

    public CustomCharacterSelectScreen() {
        this.updateOptionsIndex();
        this.allOptions = new ArrayList();
    }

    public void initialize() {
        super.initialize();
        this.allOptions.clear();
        for (CharacterOption option : BaseMod.generateCharacterOptions()) {
            this.options.add(option);
        }
        for (CharacterOption option : this.options) {
            this.allOptions.add(option);
        }
        this.selectIndex = 0;
        this.updateOptionsIndex();
        this.maxSelectIndex = (int)Math.ceil((float)this.allOptions.size() / 4.0f) - 1;
        this.options = new ArrayList<CharacterOption>(this.allOptions.subList(0, Math.min(4, this.allOptions.size())));
        this.positionButtons();
    }

    public void render(SpriteBatch sb) {
        super.render(sb);
        if (this.selectIndex < this.maxSelectIndex) {
            this.rightArrow.render(sb);
        }
        if (this.selectIndex != 0) {
            this.leftArrow.render(sb);
        }
    }

    public void update() {
        super.update();
        if (this.selectIndex < this.maxSelectIndex) {
            this.rightArrow.update();
        }
        if (this.selectIndex != 0) {
            this.leftArrow.update();
        }
    }

    private void positionButtons() {
        int count = this.options.size();
        float offsetX = (float)Settings.WIDTH / 2.0f - 440.0f * Settings.scale + 110.0f * Settings.scale;
        for (int i = 0; i < count; ++i) {
            ((CharacterOption)this.options.get(i)).move(offsetX + (float)i * 220.0f * Settings.scale, 190.0f * Settings.scale);
        }
    }

    private void setCurrentOptions(boolean rightClicked) {
        if (rightClicked && this.selectIndex < this.maxSelectIndex) {
            ++this.selectIndex;
        } else if (!rightClicked && this.selectIndex > 0) {
            --this.selectIndex;
        }
        this.updateOptionsIndex();
        int endIndex = this.optionsIndex + 4;
        this.options = new ArrayList<CharacterOption>(this.allOptions.subList(this.optionsIndex, Math.min(this.allOptions.size(), endIndex)));
        this.options.forEach(o -> {
            o.selected = false;
        });
        this.positionButtons();
    }

    private void updateOptionsIndex() {
        this.optionsIndex = 4 * this.selectIndex;
    }

    private class RightOptionsButton
    implements IUIElement {
        private Texture arrow;
        private int x;
        private int y;
        private int w;
        private int h;
        private Hitbox hitbox;

        public RightOptionsButton(String imgUrl, int x, int y) {
            this.arrow = ImageMaster.loadImage((String)imgUrl);
            this.x = x;
            this.y = y;
            this.w = (int)(Settings.scale * (float)this.arrow.getWidth());
            this.h = (int)(Settings.scale * (float)this.arrow.getHeight());
            this.hitbox = new Hitbox((float)x, (float)y, (float)this.w, (float)this.h);
        }

        @Override
        public void render(SpriteBatch sb) {
            sb.setColor(Color.WHITE);
            sb.draw(this.arrow, (float)this.x, (float)this.y, (float)this.w, (float)this.h);
            this.hitbox.render(sb);
        }

        @Override
        public void update() {
            this.hitbox.update();
            if (this.hitbox.hovered && InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                CustomCharacterSelectScreen.this.setCurrentOptions(true);
            }
        }

        @Override
        public int renderLayer() {
            return 0;
        }

        @Override
        public int updateOrder() {
            return 0;
        }
    }

    private class LeftOptionsButton
    implements IUIElement {
        private Texture arrow;
        private int x;
        private int y;
        private int w;
        private int h;
        private Hitbox hitbox;

        public LeftOptionsButton(String imgUrl, int x, int y) {
            this.arrow = ImageMaster.loadImage((String)imgUrl);
            this.x = x;
            this.y = y;
            this.w = (int)(Settings.scale * (float)this.arrow.getWidth());
            this.h = (int)(Settings.scale * (float)this.arrow.getHeight());
            this.hitbox = new Hitbox((float)x, (float)y, (float)this.w, (float)this.h);
        }

        @Override
        public void render(SpriteBatch sb) {
            sb.setColor(Color.WHITE);
            sb.draw(this.arrow, (float)this.x, (float)this.y, (float)this.w, (float)this.h);
            this.hitbox.render(sb);
        }

        @Override
        public void update() {
            this.hitbox.update();
            if (this.hitbox.hovered && InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                CustomCharacterSelectScreen.this.setCurrentOptions(false);
            }
        }

        @Override
        public int renderLayer() {
            return 0;
        }

        @Override
        public int updateOrder() {
            return 0;
        }
    }
}

