/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import org.clapper.util.text.AbstractVariableSubstituter;
import org.clapper.util.text.UndefinedVariableException;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.VariableSyntaxException;

public class UnixShellVariableSubstituter
extends AbstractVariableSubstituter {
    private static final char VAR_START = '$';
    private static final char VAR_OPEN_BRACE = '{';
    private static final char VAR_CLOSE_BRACE = '}';
    private static final char VAR_IF_EXISTS_OP = '?';
    public static final String VARIABLE_METACHARACTERS = new String(new char[]{'$', '{', '}', '?'});
    private boolean honorEscapes = false;

    public boolean getHonorEscapes() {
        return this.honorEscapes;
    }

    public void setHonorEscapes(boolean enable) {
        this.honorEscapes = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substitute(String s, VariableDereferencer deref, VariableNameChecker nameChecker, Object context, boolean allowEscapes) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        boolean save = this.getHonorEscapes();
        this.setHonorEscapes(allowEscapes);
        try {
            String string = this.substitute(s, deref, nameChecker, context);
            return string;
        }
        finally {
            this.setHonorEscapes(save);
        }
    }

    @Override
    public String substitute(String s, VariableDereferencer deref, VariableNameChecker nameChecker, Object context) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        StringBuilder result = new StringBuilder();
        int len = s.length();
        StringBuilder var = new StringBuilder();
        StringBuilder defaultValue = new StringBuilder();
        ParseState state = ParseState.NOT_IN_VAR;
        boolean braces = false;
        boolean nextIsLiteral = false;
        boolean syntaxError = false;
        if (nameChecker == null) {
            nameChecker = this;
        }
        char[] ch = s.toCharArray();
        int i = 0;
        while (i < len && !syntaxError) {
            char c = ch[i++];
            if (nextIsLiteral) {
                result.append(c);
                nextIsLiteral = false;
                continue;
            }
            if (state == ParseState.NOT_IN_VAR) {
                if (c == '$') {
                    state = ParseState.IN_VAR;
                    continue;
                }
                if (this.honorEscapes && c == '\\') {
                    nextIsLiteral = true;
                    continue;
                }
                result.append(c);
                continue;
            }
            if (state == ParseState.IN_DEFAULT_VALUE) {
                if (c == '}') {
                    state = ParseState.IN_VAR;
                    --i;
                    continue;
                }
                defaultValue.append(c);
                continue;
            }
            if (var.length() == 0 && c == '{') {
                braces = true;
                continue;
            }
            if (braces && c == '?') {
                state = ParseState.IN_DEFAULT_VALUE;
                continue;
            }
            if (nameChecker.legalVariableCharacter(c)) {
                var.append(c);
                continue;
            }
            String varName = var.toString();
            state = ParseState.NOT_IN_VAR;
            if (braces) {
                if (c == '}') {
                    result.append(this.dereference(varName, defaultValue.toString(), context, deref));
                } else {
                    result.append('$');
                    result.append('{');
                    result.append(var.toString());
                    --i;
                    syntaxError = true;
                }
                braces = false;
            } else if (var.length() == 0) {
                result.append('$');
                --i;
                syntaxError = true;
            } else {
                result.append(this.dereference(varName, defaultValue.toString(), context, deref));
                --i;
            }
            var.setLength(0);
        }
        if (state == ParseState.IN_VAR) {
            if (braces) {
                result.append('$');
                result.append('{');
                result.append(var.toString());
                syntaxError = true;
            } else if (var.length() == 0) {
                result.append('$');
            } else {
                result.append(this.dereference(var.toString(), defaultValue.toString(), context, deref));
            }
        }
        if (syntaxError && this.getAbortOnSyntaxError()) {
            throw new VariableSyntaxException("Syntax error in reference to variable \"" + var.toString() + "\"");
        }
        return result.toString();
    }

    public static boolean isVariableMetacharacter(char c) {
        boolean isMeta = false;
        char[] meta = VARIABLE_METACHARACTERS.toCharArray();
        for (int i = 0; i < meta.length; ++i) {
            if (c != meta[i]) continue;
            isMeta = true;
            break;
        }
        return isMeta;
    }

    private String dereference(String varName, String defaultValue, Object context, VariableDereferencer deref) throws VariableSubstitutionException {
        String result = deref.getVariableValue(varName, context);
        if (result == null || result.length() == 0) {
            if (defaultValue.length() == 0 && this.getAbortOnUndefinedVariable()) {
                throw new UndefinedVariableException("Variable \"" + varName + "\" is undefined.");
            }
            result = defaultValue;
        }
        return result;
    }

    private static enum ParseState {
        NOT_IN_VAR,
        IN_VAR,
        IN_DEFAULT_VALUE;

    }
}

