/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesMap
extends AbstractMap<String, String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EntrySet entrySetResult = null;
    private Properties properties = null;

    public PropertiesMap(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        PropertiesMap propertiesMap = this;
        synchronized (propertiesMap) {
            if (this.entrySetResult == null) {
                this.entrySetResult = new EntrySet();
            }
        }
        return this.entrySetResult;
    }

    @Override
    public String get(Object key) {
        return this.properties.getProperty((String)key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public String put(String key, String value) {
        String previous = (String)this.properties.setProperty(key, value);
        this.entrySetResult = null;
        return previous;
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    private class KeySetIterator
    implements Iterator<String> {
        private Enumeration<?> propertyNames;

        KeySetIterator() {
            this.propertyNames = PropertiesMap.this.properties.propertyNames();
        }

        @Override
        public String next() {
            return (String)this.propertyNames.nextElement();
        }

        @Override
        public boolean hasNext() {
            return this.propertyNames.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean contains(Object key) {
            return PropertiesMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            return PropertiesMap.this.remove(key) != null;
        }

        @Override
        public int size() {
            return PropertiesMap.this.size();
        }

        @Override
        public void clear() {
            PropertiesMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private Set<PropertiesMapEntry> entrySetResult = new HashSet<PropertiesMapEntry>();

        EntrySet() {
            KeySet keySet = new KeySet();
            Iterator<String> it = keySet.iterator();
            while (it.hasNext()) {
                this.entrySetResult.add(new PropertiesMapEntry(it.next()));
            }
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<PropertiesMapEntry> it;
                {
                    this.it = EntrySet.this.entrySetResult.iterator();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return this.it.next();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            boolean has = false;
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                has = PropertiesMap.this.containsKey(key);
            }
            return has;
        }

        @Override
        public boolean remove(Object o) {
            return PropertiesMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return PropertiesMap.this.size();
        }

        @Override
        public void clear() {
            PropertiesMap.this.clear();
        }
    }

    private class PropertiesMapEntry
    implements Map.Entry<String, String> {
        private String key = null;

        PropertiesMapEntry(String key) {
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            return PropertiesMapEntry.class.isInstance(o);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return PropertiesMap.this.get(this.key);
        }

        @Override
        public String setValue(String value) {
            return PropertiesMap.this.put(this.key, value);
        }
    }
}

