/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.clapper.util.misc.XDate;

public class BuildInfo {
    public static final String BUILD_OS_KEY = "build.os";
    public static final String BUILD_VM_KEY = "build.vm";
    public static final String BUILD_COMPILER_KEY = "build.compiler";
    public static final String BUILD_ANT_VERSION_KEY = "build.ant.version";
    public static final String BUILD_DATE_KEY = "build.date";
    public static final String BUILT_BY_KEY = "built.by";
    public static final String BUILD_ID_KEY = "build.id";
    public static final String DATE_FORMAT_STRING = "yyyy/MM/dd HH:mm:ss z";
    public static final String BUILD_ID_DATE_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    private static ResourceBundle buildInfoBundle = null;

    public BuildInfo(String bundleName) {
        this.getBuildInfoBundle(bundleName);
    }

    public String getBuildDate() {
        return BuildInfo.getBundleString(BUILD_DATE_KEY);
    }

    public String getBuildUserID() {
        return BuildInfo.getBundleString(BUILT_BY_KEY);
    }

    public String getBuildOperatingSystem() {
        return BuildInfo.getBundleString(BUILD_OS_KEY);
    }

    public String getBuildID() {
        return BuildInfo.getBundleString(BUILD_ID_KEY);
    }

    public String getBuildJavaVM() {
        return BuildInfo.getBundleString(BUILD_VM_KEY);
    }

    public String getBuildJavaCompiler() {
        return BuildInfo.getBundleString(BUILD_COMPILER_KEY);
    }

    public String getBuildAntVersion() {
        return BuildInfo.getBundleString(BUILD_ANT_VERSION_KEY);
    }

    public static void makeBuildInfoBundle(File bundleFile, String javaCompiler, String antVersion) throws IOException {
        Properties props = new Properties();
        String vmInfo = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")";
        props.setProperty(BUILD_VM_KEY, vmInfo);
        String osInfo = System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
        props.setProperty(BUILD_OS_KEY, osInfo);
        if (javaCompiler != null) {
            props.setProperty(BUILD_COMPILER_KEY, javaCompiler);
        }
        if (antVersion != null) {
            props.setProperty(BUILD_ANT_VERSION_KEY, antVersion);
        }
        XDate now = new XDate();
        SimpleDateFormat dateFmt = new SimpleDateFormat(DATE_FORMAT_STRING);
        props.setProperty(BUILD_DATE_KEY, dateFmt.format(now));
        props.setProperty(BUILD_ID_KEY, now.formatInTimeZone(BUILD_ID_DATE_FORMAT_STRING, TimeZone.getTimeZone("UTC")));
        String user = System.getProperty("user.name");
        String host = "localhost";
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            host = localhost.getHostName();
        }
        catch (Exception localhost) {
            // empty catch block
        }
        props.setProperty(BUILT_BY_KEY, user + " on " + host);
        String header = "Build information. AUTOMATICALLY GENERATED. DO NOT EDIT!";
        System.out.println("Updating " + bundleFile);
        FileOutputStream out = new FileOutputStream(bundleFile);
        props.store(out, header);
    }

    public void showBuildInfo(PrintStream out) {
        this.showBuildInfo(new PrintWriter(out));
    }

    public void showBuildInfo(PrintWriter out) {
        out.println("Build date:     " + this.getBuildDate());
        out.println("Built by:       " + this.getBuildUserID());
        out.println("Built on:       " + this.getBuildOperatingSystem());
        out.println("Build Java VM:  " + this.getBuildJavaVM());
        out.println("Build compiler: " + this.getBuildJavaCompiler());
        out.println("Ant version:    " + this.getBuildAntVersion());
    }

    private synchronized ResourceBundle getBuildInfoBundle(String bundleName) {
        if (buildInfoBundle == null) {
            try {
                buildInfoBundle = ResourceBundle.getBundle(bundleName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return buildInfoBundle;
    }

    private static String getBundleString(String key) {
        String result = "";
        try {
            if (buildInfoBundle != null) {
                result = buildInfoBundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }
}

