/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.logging;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.clapper.util.logging.LogLevel;

public class Logger {
    public static LogLevel LEVEL_DEBUG = LogLevel.DEBUG;
    public static LogLevel LEVEL_ERROR = LogLevel.ERROR;
    public static LogLevel LEVEL_FATAL = LogLevel.FATAL;
    public static LogLevel LEVEL_INFO = LogLevel.INFO;
    public static LogLevel LEVEL_TRACE = LogLevel.TRACE;
    public static LogLevel LEVEL_WARNING = LogLevel.WARNING;
    private Log realLogger = null;
    private String className = null;
    private static Collection<Logger> loggers = new ArrayList<Logger>();
    private static boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger(String className) {
        this.className = className;
        Collection<Logger> collection = loggers;
        synchronized (collection) {
            loggers.add(this);
            if (enabled) {
                Logger.enableLogger(this);
            }
        }
    }

    public Logger(Class cls) {
        this(cls.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableLogging() throws UnsupportedOperationException {
        Collection<Logger> collection = loggers;
        synchronized (collection) {
            if (!enabled) {
                for (Logger logger : loggers) {
                    Logger.enableLogger(logger);
                }
                enabled = true;
            }
        }
    }

    public void debug(Object message) {
        if (this.realLogger != null) {
            this.realLogger.debug(message.toString());
        }
    }

    public void debug(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.debug(message.toString(), ex);
        }
    }

    public void error(Object message) {
        if (this.realLogger != null) {
            this.realLogger.error(message.toString());
        }
    }

    public void error(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.error(message.toString(), ex);
        }
    }

    public void fatal(Object message) {
        if (this.realLogger != null) {
            this.realLogger.fatal(message.toString());
        }
    }

    public void fatal(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.fatal(message.toString(), ex);
        }
    }

    public void info(Object message) {
        if (this.realLogger != null) {
            this.realLogger.info(message.toString());
        }
    }

    public void info(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.info(message.toString(), ex);
        }
    }

    public void message(LogLevel level, Object message) {
        switch (level) {
            case DEBUG: {
                this.debug(message);
                break;
            }
            case ERROR: {
                this.error(message);
                break;
            }
            case FATAL: {
                this.fatal(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case TRACE: {
                this.trace(message);
                break;
            }
            case WARNING: {
                this.warn(message);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void message(LogLevel level, Object message, Throwable ex) {
        switch (level) {
            case DEBUG: {
                this.debug(message, ex);
                break;
            }
            case ERROR: {
                this.error(message, ex);
                break;
            }
            case FATAL: {
                this.fatal(message, ex);
                break;
            }
            case INFO: {
                this.info(message, ex);
                break;
            }
            case TRACE: {
                this.trace(message, ex);
                break;
            }
            case WARNING: {
                this.warn(message, ex);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void trace(Object message) {
        if (this.realLogger != null) {
            this.realLogger.trace(message.toString());
        }
    }

    public void trace(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.trace(message.toString(), ex);
        }
    }

    public void warn(Object message) {
        if (this.realLogger != null) {
            this.realLogger.warn(message.toString());
        }
    }

    public void warn(Object message, Throwable ex) {
        if (this.realLogger != null) {
            this.realLogger.warn(message.toString(), ex);
        }
    }

    public boolean isDebugEnabled() {
        return this.realLogger == null ? false : this.realLogger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.realLogger == null ? false : this.realLogger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.realLogger == null ? false : this.realLogger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.realLogger == null ? false : this.realLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.realLogger == null ? false : this.realLogger.isTraceEnabled();
    }

    public boolean isWarningEnabled() {
        return this.realLogger == null ? false : this.realLogger.isWarnEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableLogger(Logger logger) throws UnsupportedOperationException {
        Logger logger2 = logger;
        synchronized (logger2) {
            if (logger.realLogger == null) {
                logger.realLogger = LogFactory.getLog(logger.className);
            }
        }
    }
}

