/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class WordWrapWriter
extends PrintWriter {
    public static final int DEFAULT_LINE_LENGTH = 80;
    static final char NEWLINE_MARKER = '\n';
    private PrintWriter writer = null;
    private int lineLength = 80;
    private StringBuffer buffer = null;
    private int indentation = 0;
    private char indentChar = (char)32;
    private String prefix = null;
    private boolean emittedPrefix = false;

    public WordWrapWriter(Writer output) {
        this(new PrintWriter(output));
    }

    public WordWrapWriter(PrintWriter output) {
        this(output, 80);
    }

    public WordWrapWriter(OutputStream output) {
        this(output, 80);
    }

    public WordWrapWriter(Writer output, int lineLength) {
        this(new PrintWriter(output), lineLength);
    }

    public WordWrapWriter(PrintWriter output, int lineLength) {
        this(output, lineLength, 0);
    }

    public WordWrapWriter(OutputStream output, int lineLength) {
        this(output, lineLength, 0);
    }

    public WordWrapWriter(Writer output, int lineLength, int indentSpaces) {
        this(new PrintWriter(output), lineLength, indentSpaces);
    }

    public WordWrapWriter(PrintWriter output, int lineLength, int indentSpaces) {
        super(output);
        this.writer = output;
        this.setLineLength(lineLength);
        this.setIndentation(indentSpaces);
    }

    public WordWrapWriter(OutputStream output, int lineLength, int indentSpaces) {
        this(new OutputStreamWriter(output), lineLength, indentSpaces);
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public synchronized void flush() {
        if (this.buffer != null && this.buffer.length() > 0) {
            this.flushBuffer(this.buffer);
            this.buffer.setLength(0);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public char getIndentationChar() {
        return this.indentChar;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setIndentation(int newIndentation) {
        if (newIndentation < 0) {
            throw new IndexOutOfBoundsException("Indentation of " + newIndentation + " is negative.");
        }
        this.indentation = newIndentation;
    }

    public void setIndentationChar(char c) {
        this.indentChar = c;
    }

    public void setLineLength(int newLineLength) throws IndexOutOfBoundsException {
        if (newLineLength < 0) {
            throw new IndexOutOfBoundsException("Line length of " + newLineLength + " is negative.");
        }
        this.lineLength = newLineLength;
    }

    public String setPrefix(String newPrefix) {
        String result = this.prefix;
        this.prefix = newPrefix;
        this.emittedPrefix = false;
        return result;
    }

    @Override
    public void print(boolean b) {
        Boolean B = new Boolean(b);
        this.write(B.toString());
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] s) {
        this.write(s, 0, s.length);
    }

    @Override
    public void print(double d) {
        Double D = new Double(d);
        this.write(D.toString());
    }

    @Override
    public void print(float f) {
        Float F = new Float(f);
        this.write(F.toString());
    }

    @Override
    public void print(int i) {
        Integer I = new Integer(i);
        this.write(I.toString());
    }

    @Override
    public void print(long l) {
        Long L = new Long(l);
        this.write(L.toString());
    }

    public void print(short s) {
        Short S = new Short(s);
        this.write(S.toString());
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public void print(Object x) {
        this.write(x.toString());
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void println(boolean b) {
        Boolean B = new Boolean(b);
        this.println(B.toString());
    }

    @Override
    public void println(char c) {
        this.println(c);
    }

    @Override
    public void println(char[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.print(s[i]);
        }
        this.println();
    }

    @Override
    public void println(double d) {
        Double D = new Double(d);
        this.println(D.toString());
    }

    @Override
    public void println(float f) {
        Float F = new Float(f);
        this.println(F.toString());
    }

    @Override
    public void println(int i) {
        Integer I = new Integer(i);
        this.println(I.toString());
    }

    @Override
    public void println(long l) {
        Long L = new Long(l);
        this.println(L.toString());
    }

    public void println(short s) {
        Short S = new Short(s);
        this.println(S.toString());
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.println(x.toString());
    }

    @Override
    public synchronized void write(int c) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(this.lineLength * 2);
        }
        this.buffer.append((char)c);
        if (c == 10) {
            this.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        while (off < cbuf.length && len > 0) {
            this.write(cbuf[off]);
            --len;
            ++off;
        }
    }

    @Override
    public void write(String s, int off, int len) {
        char[] cbuf = s.toCharArray();
        this.write(cbuf, off, len);
    }

    @Override
    public void write(String s) {
        char[] cbuf = s.toCharArray();
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    private void flushBuffer(StringBuffer buf) {
        StringTokenizer lineTok = new StringTokenizer(buf.toString(), "\n", true);
        String localPrefix = this.prefix == null ? "" : this.prefix;
        int currentLength = 0;
        boolean lastWasNewline = true;
        while (lineTok.hasMoreTokens()) {
            String line = lineTok.nextToken();
            if (line.length() == 1 && line.charAt(0) == '\n') {
                this.writer.println();
                lastWasNewline = true;
                currentLength = 0;
                continue;
            }
            StringTokenizer wordTok = new StringTokenizer(line);
            while (wordTok.hasMoreTokens()) {
                String word = wordTok.nextToken();
                int wordLength = word.length();
                if (wordLength + currentLength + 1 > this.lineLength && !lastWasNewline) {
                    this.writer.println();
                    currentLength = 0;
                    lastWasNewline = true;
                }
                if (lastWasNewline) {
                    currentLength += this.indent();
                    lastWasNewline = false;
                } else {
                    this.writer.print(' ');
                    ++currentLength;
                }
                this.writer.print(word);
                currentLength += wordLength;
            }
        }
        if (currentLength > 0) {
            this.writer.println();
        }
        this.writer.flush();
    }

    private int indent() {
        int i;
        int result = 0;
        if (this.prefix != null) {
            int len = this.prefix.length();
            if (!this.emittedPrefix) {
                this.writer.write(this.prefix);
                this.emittedPrefix = true;
            } else {
                for (i = 0; i < len; ++i) {
                    this.writer.write(this.indentChar);
                }
            }
            result += len;
        }
        for (i = 0; i < this.indentation; ++i) {
            this.writer.write(this.indentChar);
            ++result;
        }
        return result;
    }
}

