/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.clapper.util.classutil.ClassUtil;
import org.clapper.util.logging.Logger;

public class ClassLoaderBuilder {
    private Collection<URL> urlList = new LinkedHashSet<URL>();
    private static final Logger log = new Logger(ClassLoaderBuilder.class);

    public boolean add(File file) {
        boolean added = false;
        String fileName = file.getPath();
        try {
            if (ClassUtil.fileCanContainClasses(file)) {
                if (file.isDirectory() && !fileName.endsWith("/")) {
                    fileName = fileName + "/";
                    file = new File(fileName);
                }
                this.urlList.add(file.toURI().toURL());
                added = true;
            }
        }
        catch (MalformedURLException ex) {
            log.error("Unexpected exception", ex);
        }
        if (!added) {
            log.debug("Skipping non-jar, non-zip, non-directory \"" + fileName + "\"");
        }
        return added;
    }

    public int add(File[] files) {
        int total = 0;
        for (File f : files) {
            if (!this.add(f)) continue;
            ++total;
        }
        return total;
    }

    public int add(Collection<File> files) {
        int total = 0;
        for (File f : files) {
            if (!this.add(f)) continue;
            ++total;
        }
        return total;
    }

    public void addClassPath() {
        String path = null;
        try {
            path = System.getProperty("java.class.path");
        }
        catch (Exception ex) {
            path = "";
            log.error("Unable to get class path", ex);
        }
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.add(new File(tok.nextToken()));
            }
        }
    }

    public void clear() {
        this.urlList.clear();
    }

    public ClassLoader createClassLoader() throws SecurityException {
        return new URLClassLoader(this.urlList.toArray(new URL[this.urlList.size()]), this.getClass().getClassLoader());
    }

    public ClassLoader createClassLoader(ClassLoader parentLoader) throws SecurityException {
        return new URLClassLoader(this.urlList.toArray(new URL[this.urlList.size()]), parentLoader);
    }
}

