/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassInfo;
import org.clapper.util.classutil.ClassInfoClassVisitor;
import org.clapper.util.classutil.ClassUtil;
import org.clapper.util.classutil.ClassUtilException;
import org.clapper.util.io.AndFileFilter;
import org.clapper.util.io.FileFilterMatchType;
import org.clapper.util.io.FileOnlyFilter;
import org.clapper.util.io.RecursiveFileFinder;
import org.clapper.util.io.RegexFileFilter;
import org.clapper.util.logging.Logger;
import org.shaded.objectweb.asm.ClassReader;
import org.shaded.objectweb.asm.ClassVisitor;

public class ClassFinder {
    private LinkedHashMap<String, File> placesToSearch = new LinkedHashMap();
    private Map<String, ClassInfo> foundClasses = new LinkedHashMap<String, ClassInfo>();
    private static final Logger log = new Logger(ClassFinder.class);

    public void addClassPath() {
        String path = null;
        try {
            path = System.getProperty("java.class.path");
        }
        catch (Exception ex) {
            path = "";
            log.error("Unable to get class path", ex);
        }
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            this.add(new File(tok.nextToken()));
        }
    }

    public boolean add(File file) {
        boolean added = false;
        if (ClassUtil.fileCanContainClasses(file)) {
            String absPath = file.getAbsolutePath();
            if (this.placesToSearch.get(absPath) == null) {
                this.placesToSearch.put(absPath, file);
                if (this.isJar(absPath)) {
                    this.loadJarClassPathEntries(file);
                }
            }
            added = true;
        }
        return added;
    }

    public int add(File[] files) {
        int totalAdded = 0;
        for (File file : files) {
            if (!this.add(file)) continue;
            ++totalAdded;
        }
        return totalAdded;
    }

    public int add(Collection<File> files) {
        int totalAdded = 0;
        for (File file : files) {
            if (!this.add(file)) continue;
            ++totalAdded;
        }
        return totalAdded;
    }

    public void clear() {
        this.placesToSearch.clear();
        this.foundClasses.clear();
    }

    public int findClasses(Collection<ClassInfo> classes) {
        return this.findClasses(classes, null);
    }

    public int findClasses(Collection<ClassInfo> classes, ClassFilter filter) {
        int total = 0;
        this.foundClasses.clear();
        for (File file : this.placesToSearch.values()) {
            String name = file.getPath();
            log.info("Finding classes in " + name);
            if (this.isJar(name)) {
                this.processJar(name, this.foundClasses);
                continue;
            }
            if (this.isZip(name)) {
                this.processZip(name, this.foundClasses);
                continue;
            }
            this.processDirectory(file, this.foundClasses);
        }
        log.info("Loaded " + this.foundClasses.size() + " classes.");
        for (ClassInfo classInfo : this.foundClasses.values()) {
            String className = classInfo.getClassName();
            String locationName = classInfo.getClassLocation().getPath();
            log.debug("Looking at " + locationName + " (" + className + ")");
            if (filter == null || filter.accept(classInfo, this)) {
                log.debug("Filter accepted " + className);
                ++total;
                classes.add(classInfo);
                continue;
            }
            log.debug("Filter rejected " + className);
        }
        log.info("Returning " + total + " total classes");
        this.foundClasses.clear();
        return total;
    }

    public int findAllSuperClasses(ClassInfo classInfo, Map<String, ClassInfo> superClasses) {
        ClassInfo superClassInfo;
        int total = 0;
        String superClassName = classInfo.getSuperClassName();
        if (superClassName != null && (superClassInfo = this.foundClasses.get(superClassName)) != null) {
            superClasses.put(superClassName, superClassInfo);
            ++total;
            total += this.findAllSuperClasses(superClassInfo, superClasses);
        }
        return total;
    }

    public int findAllInterfaces(ClassInfo classInfo, Map<String, ClassInfo> interfaces) {
        ClassInfo superClassInfo;
        int total = 0;
        String superClassName = classInfo.getSuperClassName();
        if (superClassName != null && (superClassInfo = this.foundClasses.get(superClassName)) != null) {
            total += this.findAllInterfaces(superClassInfo, interfaces);
        }
        String[] interfaceNames = classInfo.getInterfaces();
        if (interfaces != null) {
            for (String interfaceName : interfaceNames) {
                ClassInfo intfClassInfo = this.foundClasses.get(interfaceName);
                if (intfClassInfo == null) continue;
                interfaces.put(interfaceName, intfClassInfo);
                ++total;
                total += this.findAllInterfaces(intfClassInfo, interfaces);
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJar(String jarName, Map<String, ClassInfo> foundClasses) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarName);
            File jarFile = new File(jarName);
            this.processOpenZip(jar, jarFile, new ClassInfoClassVisitor(foundClasses, jarFile));
        }
        catch (IOException ex) {
            log.error("Can't open jar file \"" + jarName + "\"", ex);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex) {
                log.error("Can't close " + jarName, ex);
            }
            jar = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZip(String zipName, Map<String, ClassInfo> foundClasses) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipName);
            File zipFile = new File(zipName);
            this.processOpenZip(zip, zipFile, new ClassInfoClassVisitor(foundClasses, zipFile));
        }
        catch (IOException ex) {
            log.error("Can't open jar file \"" + zipName + "\"", ex);
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException ex) {
                log.error("Can't close " + zipName, ex);
            }
            zip = null;
        }
    }

    private void processOpenZip(ZipFile zip, File zipFile, ClassVisitor classVisitor) {
        String zipName = zipFile.getPath();
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
            try {
                log.debug("Loading " + zipName + "(" + entry.getName() + ")");
                this.loadClassData(zip.getInputStream(entry), classVisitor);
            }
            catch (IOException ex) {
                log.error("Can't open \"" + entry.getName() + "\" in zip file \"" + zipName + "\": ", ex);
            }
            catch (ClassUtilException ex) {
                log.error("Can't open \"" + entry.getName() + "\" in zip file \"" + zipName + "\": ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectory(File dir, Map<String, ClassInfo> foundClasses) {
        RecursiveFileFinder finder = new RecursiveFileFinder();
        RegexFileFilter nameFilter = new RegexFileFilter("\\.class$", FileFilterMatchType.FILENAME);
        AndFileFilter fileFilter = new AndFileFilter(nameFilter, new FileOnlyFilter());
        ArrayList<File> files = new ArrayList<File>();
        finder.findFiles(dir, fileFilter, files);
        ClassInfoClassVisitor classVisitor = new ClassInfoClassVisitor(foundClasses, dir);
        for (File f : files) {
            String path = f.getPath();
            log.debug("Loading " + f.getPath());
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                this.loadClassData(is, classVisitor);
            }
            catch (IOException ex) {
                log.error("Can't open \"" + path + "\": ", ex);
            }
            catch (ClassUtilException ex) {
                log.error("Can't open \"" + path + "\": ", ex);
            }
            finally {
                if (is == null) continue;
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {
                    log.error("Can't close InputStream for \"" + path + "\"", ex);
                }
            }
        }
    }

    private void loadJarClassPathEntries(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return;
            }
            Map<String, Attributes> map = manifest.getEntries();
            Attributes attrs = manifest.getMainAttributes();
            Set<Object> keys = attrs.keySet();
            for (Object key : keys) {
                String element;
                String value = (String)attrs.get(key);
                if (!key.toString().equals("Class-Path")) continue;
                String jarName = jar.getName();
                log.debug("Adding Class-Path from jar " + jarName);
                StringBuilder buf = new StringBuilder();
                StringTokenizer tok = new StringTokenizer(value);
                while (tok.hasMoreTokens()) {
                    buf.setLength(0);
                    element = tok.nextToken();
                    String parent = jarFile.getParent();
                    if (parent != null) {
                        buf.append(parent);
                        buf.append(File.separator);
                    }
                    buf.append(element);
                }
                element = buf.toString();
                log.debug("From " + jarName + ": " + element);
                this.add(new File(element));
            }
        }
        catch (IOException ex) {
            log.error("I/O error processing jar file \"" + jarFile.getPath() + "\"", ex);
        }
    }

    private void loadClassData(InputStream is, ClassVisitor classVisitor) throws ClassUtilException {
        try {
            ClassReader cr = new ClassReader(is);
            cr.accept(classVisitor, ClassInfo.ASM_CR_ACCEPT_CRITERIA);
        }
        catch (Exception ex) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassFinder.cantReadClassStream", "Unable to load class from open input stream", ex);
        }
    }

    private boolean isJar(String fileName) {
        return fileName.toLowerCase().endsWith(".jar");
    }

    private boolean isZip(String fileName) {
        return fileName.toLowerCase().endsWith(".zip");
    }
}

