/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.ui;

import com.evacipated.cardcrawl.modthespire.GithubUpdateChecker;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.ModList;
import com.evacipated.cardcrawl.modthespire.ModUpdate;
import com.evacipated.cardcrawl.modthespire.UpdateChecker;
import com.evacipated.cardcrawl.modthespire.ui.JModPanelCheckBoxList;
import com.evacipated.cardcrawl.modthespire.ui.MessageConsole;
import com.evacipated.cardcrawl.modthespire.ui.ModPanel;
import com.evacipated.cardcrawl.modthespire.ui.UpdateWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class ModSelectWindow
extends JFrame {
    private static final long serialVersionUID = -8232997068791248057L;
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 500;
    private static final String DEBUG_OPTION = "Debug";
    private static final String PLAY_OPTION = "Play";
    private static final String JAR_DUMP_OPTION = "Dump Patched Jar";
    static final Icon ICON_UPDATE = new ImageIcon(ModSelectWindow.class.getResource("/assets/update.gif"));
    static final Icon ICON_LOAD = new ImageIcon(ModSelectWindow.class.getResource("/assets/ajax-loader.gif"));
    static final Icon ICON_GOOD = new ImageIcon(ModSelectWindow.class.getResource("/assets/good.gif"));
    static final Icon ICON_WARNING = new ImageIcon(ModSelectWindow.class.getResource("/assets/warning.gif"));
    static final Icon ICON_ERROR = new ImageIcon(ModSelectWindow.class.getResource("/assets/error.gif"));
    static final Icon ICON_WORKSHOP = new ImageIcon(ModSelectWindow.class.getResource("/assets/workshop.gif"));
    private ModInfo[] info;
    private boolean showingLog = false;
    private boolean isMaximized = false;
    private boolean isCentered = false;
    private Rectangle location;
    private JButton playBtn;
    private JModPanelCheckBoxList modList;
    private ModInfo currentModInfo;
    private TitledBorder name;
    private JTextArea authors;
    private JLabel modVersion;
    private JTextArea status;
    private JLabel mtsVersion;
    private JLabel stsVersion;
    private JTextArea description;
    private JTextArea credits;
    private JPanel bannerNoticePanel;
    private JLabel mtsUpdateBanner;
    private JLabel betaWarningBanner;
    private JPanel modBannerNoticePanel;
    private JLabel modUpdateBanner;
    static List<ModUpdate> MODUPDATES;

    public static Properties getDefaults() {
        Properties properties = new Properties();
        properties.setProperty("x", "center");
        properties.setProperty("y", "center");
        properties.setProperty("width", Integer.toString(800));
        properties.setProperty("height", Integer.toString(500));
        properties.setProperty("maximize", Boolean.toString(false));
        return properties;
    }

    public ModSelectWindow(ModInfo[] modInfos) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.info = modInfos;
        this.readWindowPosSize();
        this.setupDetectMaximize();
        this.initUI();
        if (Loader.MTS_CONFIG.getBool("maximize")) {
            this.isMaximized = true;
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private void readWindowPosSize() {
        if (Loader.MTS_CONFIG.getInt("width") < 800) {
            Loader.MTS_CONFIG.setInt("width", 800);
        }
        if (Loader.MTS_CONFIG.getInt("height") < 500) {
            Loader.MTS_CONFIG.setInt("height", 500);
        }
        this.location = new Rectangle();
        this.location.width = Loader.MTS_CONFIG.getInt("width");
        this.location.height = Loader.MTS_CONFIG.getInt("height");
        if (Loader.MTS_CONFIG.getString("x").equals("center") || Loader.MTS_CONFIG.getString("y").equals("center")) {
            this.isCentered = true;
        } else {
            this.isCentered = false;
            this.location.x = Loader.MTS_CONFIG.getInt("x");
            this.location.y = Loader.MTS_CONFIG.getInt("y");
            if (!this.isInScreenBounds(this.location)) {
                Loader.MTS_CONFIG.setString("x", "center");
                Loader.MTS_CONFIG.setString("y", "center");
                this.isCentered = true;
            }
        }
        try {
            Loader.MTS_CONFIG.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupDetectMaximize() {
        final ModSelectWindow tmpthis = this;
        this.addComponentListener(new ComponentAdapter(){
            int skipMoves = 2;

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (!ModSelectWindow.this.showingLog) {
                    Dimension d = tmpthis.getContentPane().getSize();
                    if (!ModSelectWindow.this.isMaximized) {
                        ModSelectWindow.this.saveWindowDimensions(d);
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                super.componentMoved(e);
                if (!ModSelectWindow.this.showingLog && this.skipMoves == 0) {
                    if (ModSelectWindow.this.isInScreenBounds(ModSelectWindow.this.getLocationOnScreen(), ModSelectWindow.this.getBounds())) {
                        ModSelectWindow.this.saveWindowLocation();
                    }
                    ModSelectWindow.this.isCentered = false;
                } else if (this.skipMoves > 0) {
                    --this.skipMoves;
                }
            }
        });
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                super.windowStateChanged(e);
                if (!ModSelectWindow.this.showingLog) {
                    if ((e.getNewState() & 6) != 0) {
                        ModSelectWindow.this.isMaximized = true;
                        ModSelectWindow.this.saveWindowMaximize();
                    } else {
                        ModSelectWindow.this.isMaximized = false;
                        ModSelectWindow.this.saveWindowMaximize();
                    }
                }
            }
        });
    }

    private void initUI() {
        this.setTitle("ModTheSpire " + Loader.MTS_VERSION);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.rootPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.getContentPane().setPreferredSize(new Dimension(this.location.width, this.location.height));
        this.getContentPane().add((Component)this.makeModListPanel(), "West");
        this.getContentPane().add((Component)this.makeInfoPanel(), "Center");
        this.getContentPane().add((Component)this.makeTopPanel(), "North");
        this.pack();
        if (this.isCentered) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(this.location.getLocation());
        }
        JRootPane rootPane = SwingUtilities.getRootPane(this.playBtn);
        rootPane.setDefaultButton(this.playBtn);
        EventQueue.invokeLater(this.playBtn::requestFocusInWindow);
    }

    private JPanel makeModListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(220, 300));
        DefaultListModel<ModPanel> model = new DefaultListModel<ModPanel>();
        this.modList = new JModPanelCheckBoxList(this, model);
        ModList mods = ModList.loadModLists();
        mods.loadModsInOrder(model, this.info, this.modList);
        this.modList.publishBoxChecked();
        JScrollPane modScroller = new JScrollPane(this.modList);
        panel.add((Component)modScroller, "Center");
        this.playBtn = new JButton(Loader.OUT_JAR ? JAR_DUMP_OPTION : PLAY_OPTION);
        this.playBtn.addActionListener(event -> {
            this.showingLog = true;
            this.playBtn.setEnabled(false);
            this.getContentPane().removeAll();
            JTextArea textArea = new JTextArea();
            textArea.setLineWrap(true);
            textArea.setFont(new Font("monospaced", 0, 12));
            JScrollPane logScroller = new JScrollPane(textArea);
            this.getContentPane().add((Component)logScroller, "Center");
            MessageConsole mc = new MessageConsole(textArea);
            mc.redirectOut(null, System.out);
            mc.redirectErr(null, System.err);
            this.setResizable(true);
            this.pack();
            if (this.isCentered) {
                this.setLocationRelativeTo(null);
            }
            Thread tCfg = new Thread(() -> ModList.save(ModList.getDefaultList(), this.modList.getCheckedMods()));
            tCfg.start();
            Thread t = new Thread(() -> {
                File[] selectedMods = this.modList.getCheckedMods();
                Loader.runMods(selectedMods);
            });
            t.start();
        });
        if (Loader.STS_BETA && !Loader.allowBeta) {
            this.playBtn.setEnabled(false);
        }
        panel.add((Component)this.playBtn, "South");
        JButton openFolderBtn = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        openFolderBtn.setToolTipText("Open Mods Directory");
        openFolderBtn.addActionListener(event -> {
            try {
                File file = new File(Loader.MOD_DIR);
                if (!file.exists()) {
                    file.mkdir();
                }
                Desktop.getDesktop().open(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        JButton updatesBtn = new JButton(ICON_UPDATE);
        updatesBtn.setToolTipText("Check for Mod Updates");
        updatesBtn.addActionListener(event -> this.startCheckingForModUpdates(updatesBtn));
        JButton settingsBtn = new JButton("Settings");
        settingsBtn.addActionListener(event -> {});
        JButton toggleAllBtn = new JButton(UIManager.getIcon("Tree.collapsedIcon"));
        toggleAllBtn.setToolTipText("Toggle all mods On/Off");
        toggleAllBtn.addActionListener(event -> {
            this.modList.toggleAllMods();
            this.repaint();
        });
        JPanel btnPanel = new JPanel(new GridLayout(1, 0));
        btnPanel.add(updatesBtn);
        btnPanel.add(openFolderBtn);
        JComboBox<String> profilesList = new JComboBox<String>(ModList.getAllModListNames().toArray(new String[0]));
        JButton addProfile = new JButton("+");
        JButton delProfile = new JButton("-");
        profilesList.addActionListener(event -> {
            String profileName = (String)profilesList.getSelectedItem();
            delProfile.setEnabled(!ModList.DEFAULT_LIST.equals(profileName));
            ModList newList = new ModList(profileName);
            DefaultListModel newModel = (DefaultListModel)this.modList.getModel();
            newList.loadModsInOrder(newModel, this.info, this.modList);
            Thread tCfg = new Thread(() -> ModList.save(profileName, this.modList.getCheckedMods()));
            tCfg.start();
        });
        profilesList.setSelectedItem(ModList.getDefaultList());
        JPanel profilesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 2;
        profilesPanel.add((Component)toggleAllBtn, c);
        c.weightx = 0.9;
        c.ipady = 0;
        profilesPanel.add(profilesList, c);
        c.weightx = 0.0;
        c.ipady = 2;
        addProfile.setToolTipText("Add new profile");
        addProfile.addActionListener(event -> {
            String s = JOptionPane.showInputDialog(this, "Profile Name:", "New Profile", -1);
            if (s != null && !s.isEmpty()) {
                profilesList.addItem(s);
                profilesList.setSelectedIndex(profilesList.getItemCount() - 1);
            }
        });
        profilesPanel.add((Component)addProfile, c);
        delProfile.setToolTipText("Delete profile");
        delProfile.addActionListener(event -> {
            String profileName = (String)profilesList.getSelectedItem();
            int n = JOptionPane.showConfirmDialog(this, "Are you sure?\nThis action cannot be undone.", "Delete Profile \"" + profileName + "\"", 0);
            if (n == 0) {
                profilesList.removeItem(profileName);
                profilesList.setSelectedItem(ModList.DEFAULT_LIST);
                ModList.delete(profileName);
            }
        });
        profilesPanel.add((Component)delProfile, c);
        JPanel topPanel = new JPanel(new GridLayout(0, 1));
        topPanel.add(btnPanel);
        topPanel.add(profilesPanel);
        panel.add((Component)topPanel, "North");
        return panel;
    }

    private JPanel makeInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.makeModBannerPanel(), "North");
        panel.add((Component)this.makeStatusPanel(), "South");
        JPanel infoPanel = new JPanel();
        this.name = BorderFactory.createTitledBorder("Mod Info");
        this.name.setTitleFont(this.name.getTitleFont().deriveFont(1));
        infoPanel.setBorder(BorderFactory.createCompoundBorder(this.name, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        this.authors = this.makeInfoTextAreaField("Author(s)", " ");
        infoPanel.add((Component)this.authors, c);
        c.gridy = 1;
        this.modVersion = this.makeInfoLabelField("ModVersion", " ");
        infoPanel.add((Component)this.modVersion, c);
        c.gridy = 2;
        this.mtsVersion = this.makeInfoLabelField("ModTheSpire Version", " ");
        infoPanel.add((Component)this.mtsVersion, c);
        c.gridy = 3;
        this.stsVersion = this.makeInfoLabelField("Slay the Spire Version", " ");
        infoPanel.add((Component)this.stsVersion, c);
        c.gridy = 4;
        this.credits = this.makeInfoTextAreaField("Additional Credits", " ");
        infoPanel.add((Component)this.credits, c);
        c.gridy = 5;
        this.status = this.makeInfoTextAreaField("Status", " ");
        infoPanel.add((Component)this.status, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.description = this.makeInfoTextAreaField("Description", " ");
        infoPanel.add((Component)this.description, c);
        panel.add((Component)infoPanel, "Center");
        return panel;
    }

    private JLabel makeInfoLabelField(String title, String value) {
        JLabel label = new JLabel(value);
        TitledBorder border = BorderFactory.createTitledBorder(title);
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        label.setFont(label.getFont().deriveFont(0));
        label.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return label;
    }

    private JTextArea makeInfoTextAreaField(String title, String value) {
        JTextArea label = new JTextArea(value);
        TitledBorder border = BorderFactory.createTitledBorder(title);
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        label.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label.setEditable(false);
        label.setAlignmentX(0.0f);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setOpaque(false);
        label.setFont(border.getTitleFont().deriveFont(0).deriveFont(11.0f));
        return label;
    }

    private JPanel makeModBannerPanel() {
        this.modBannerNoticePanel = new JPanel();
        this.modBannerNoticePanel.setLayout(new GridLayout(0, 1));
        this.modBannerNoticePanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
        this.modUpdateBanner = new JLabel();
        this.modUpdateBanner.setIcon(ICON_WARNING);
        this.modUpdateBanner.setText("<html>An update is available for this mod.</html>");
        this.modUpdateBanner.setHorizontalAlignment(0);
        this.modUpdateBanner.setOpaque(true);
        this.modUpdateBanner.setBackground(new Color(255, 193, 7));
        this.modUpdateBanner.setBorder(new EmptyBorder(5, 5, 5, 5));
        return this.modBannerNoticePanel;
    }

    private JPanel makeStatusPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new MatteBorder(1, 0, 0, 0, Color.darkGray));
        JLabel sts_version = new JLabel("Slay the Spire version: " + Loader.STS_VERSION);
        if (Loader.STS_BETA) {
            sts_version.setText(sts_version.getText() + " BETA");
        }
        sts_version.setHorizontalAlignment(4);
        panel.add((Component)sts_version, "East");
        JCheckBox debugCheck = new JCheckBox(DEBUG_OPTION);
        if (Loader.DEBUG) {
            debugCheck.setSelected(true);
        }
        debugCheck.addActionListener(event -> {
            Loader.DEBUG = debugCheck.isSelected();
            Loader.MTS_CONFIG.setBool("debug", Loader.DEBUG);
            try {
                Loader.MTS_CONFIG.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        panel.add((Component)debugCheck, "West");
        return panel;
    }

    private JPanel makeTopPanel() {
        this.bannerNoticePanel = new JPanel();
        this.bannerNoticePanel.setLayout(new GridLayout(0, 1));
        if (Loader.STS_BETA) {
            this.betaWarningBanner = new JLabel();
            this.betaWarningBanner.setIcon(ICON_ERROR);
            this.betaWarningBanner.setText("<html>You are on the Slay the Spire beta branch.<br/>If mods are not working correctly,<br/>switch to the main branch for best results.</html>");
            this.betaWarningBanner.setHorizontalAlignment(0);
            this.betaWarningBanner.setOpaque(true);
            this.betaWarningBanner.setBackground(new Color(255, 80, 80));
            this.betaWarningBanner.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.bannerNoticePanel.add(this.betaWarningBanner);
        }
        this.mtsUpdateBanner = new JLabel();
        this.mtsUpdateBanner.setIcon(ICON_WARNING);
        this.mtsUpdateBanner.setText("<html>An update for ModTheSpire is available.<br/>Click here to open the download page.</html>");
        this.mtsUpdateBanner.setHorizontalAlignment(0);
        this.mtsUpdateBanner.setOpaque(true);
        this.mtsUpdateBanner.setBackground(new Color(255, 193, 7));
        this.mtsUpdateBanner.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mtsUpdateBanner.setCursor(Cursor.getPredefinedCursor(12));
        return this.bannerNoticePanel;
    }

    private void setMTSUpdateAvailable(final URL url) {
        this.bannerNoticePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(url.toURI());
                    }
                    catch (IOException | URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.bannerNoticePanel.add(this.mtsUpdateBanner);
        this.pack();
        this.repaint();
    }

    void saveWindowDimensions(Dimension d) {
        Loader.MTS_CONFIG.setInt("width", d.width);
        Loader.MTS_CONFIG.setInt("height", d.height);
        try {
            Loader.MTS_CONFIG.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void saveWindowMaximize() {
        Loader.MTS_CONFIG.setBool("maximize", this.isMaximized);
        try {
            Loader.MTS_CONFIG.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void saveWindowLocation() {
        Point loc = this.getLocationOnScreen();
        Loader.MTS_CONFIG.setInt("x", loc.x);
        Loader.MTS_CONFIG.setInt("y", loc.y);
        try {
            Loader.MTS_CONFIG.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean isInScreenBounds(Point location, Rectangle size) {
        size.setLocation(location);
        return this.isInScreenBounds(size);
    }

    boolean isInScreenBounds(Rectangle location) {
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = gd.getDefaultConfiguration().getBounds();
            bounds.x -= 10;
            bounds.width += 20;
            bounds.y -= 10;
            bounds.height += 20;
            if (!bounds.contains(location)) continue;
            return true;
        }
        return false;
    }

    void setModInfo(ModInfo info) {
        this.currentModInfo = info;
        this.name.setTitle(info.Name);
        this.authors.setText(String.join((CharSequence)", ", info.Authors));
        if (info.ModVersion != null) {
            this.modVersion.setText(info.ModVersion.toString());
        } else {
            this.modVersion.setText(" ");
        }
        if (info.MTS_Version != null) {
            this.mtsVersion.setText(info.MTS_Version + "+");
        } else {
            this.mtsVersion.setText(" ");
        }
        if (info.STS_Version != null && !info.STS_Version.isEmpty()) {
            this.stsVersion.setText(info.STS_Version);
        } else {
            this.stsVersion.setText(" ");
        }
        this.description.setText(info.Description);
        this.credits.setText(info.Credits);
        this.status.setText(info.statusMsg);
        this.setModUpdateBanner(info);
        this.repaint();
    }

    synchronized void setModUpdateBanner(ModInfo info) {
        if (this.currentModInfo != null && this.currentModInfo.equals(info)) {
            boolean needsUpdate = false;
            if (MODUPDATES != null) {
                for (ModUpdate modUpdate : MODUPDATES) {
                    if (!modUpdate.info.equals(info)) continue;
                    needsUpdate = true;
                    break;
                }
            }
            if (needsUpdate) {
                this.modBannerNoticePanel.add(this.modUpdateBanner);
            } else {
                this.modBannerNoticePanel.remove(this.modUpdateBanner);
            }
        }
    }

    public void startCheckingForMTSUpdate() {
        new Thread(() -> {
            try {
                GithubUpdateChecker updateChecker = new GithubUpdateChecker("kiooeht", "ModTheSpire");
                if (updateChecker.isNewerVersionAvailable(Loader.MTS_VERSION)) {
                    URL latestReleaseURL = ((UpdateChecker)updateChecker).getLatestReleaseURL();
                    this.setMTSUpdateAvailable(latestReleaseURL);
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("ERROR: ModTheSpire: " + e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
    }

    public void startCheckingForModUpdates(JButton updatesBtn) {
        updatesBtn.setIcon(ICON_LOAD);
        new Thread(() -> {
            for (int i = 0; i < this.info.length; ++i) {
                if (this.info[i].UpdateJSON == null || this.info[i].UpdateJSON.isEmpty()) continue;
                this.modList.setUpdateIcon(this.info[i], UpdateIconType.CHECKING);
            }
            boolean anyNeedUpdates = false;
            MODUPDATES = new ArrayList<ModUpdate>();
            for (int i = 0; i < this.info.length; ++i) {
                if (this.info[i].UpdateJSON == null || this.info[i].UpdateJSON.isEmpty()) continue;
                try {
                    GithubUpdateChecker updateChecker = new GithubUpdateChecker(this.info[i].UpdateJSON);
                    if (updateChecker.isNewerVersionAvailable(this.info[i].ModVersion)) {
                        anyNeedUpdates = true;
                        MODUPDATES.add(new ModUpdate(this.info[i], ((UpdateChecker)updateChecker).getLatestReleaseURL(), ((UpdateChecker)updateChecker).getLatestDownloadURL()));
                        this.setModUpdateBanner(this.info[i]);
                        this.revalidate();
                        this.repaint();
                        this.modList.setUpdateIcon(this.info[i], UpdateIconType.UPDATE_AVAILABLE);
                        continue;
                    }
                    this.modList.setUpdateIcon(this.info[i], UpdateIconType.UPTODATE);
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    System.out.println("ERROR: " + this.info[i].Name + ": " + e2.getMessage());
                    continue;
                }
                catch (IOException e3) {
                    System.out.println(e3);
                }
            }
            if (anyNeedUpdates) {
                updatesBtn.setIcon(ICON_WARNING);
                updatesBtn.setToolTipText("Mod updates are available.");
                for (ActionListener listener : updatesBtn.getActionListeners()) {
                    updatesBtn.removeActionListener(listener);
                }
                updatesBtn.addActionListener(e -> {
                    UpdateWindow win = new UpdateWindow(this);
                    win.setVisible(true);
                });
            } else {
                updatesBtn.setIcon(ICON_UPDATE);
            }
        }).start();
    }

    public void warnAboutMissingVersions() {
        for (ModInfo modInfo : this.info) {
            if (modInfo.ModVersion != null) continue;
            JOptionPane.showMessageDialog(null, modInfo.Name + " has a missing or bad version number.\nGo yell at the author to fix it.", "Warning", 2);
        }
    }

    public static enum UpdateIconType {
        NONE,
        CAN_CHECK,
        CHECKING,
        UPDATE_AVAILABLE,
        UPTODATE,
        WORKSHOP;

    }
}

